/*
 * Decompiled with CFR 0.152.
 */
package common.metrics.client.http.restTemplate;

import com.google.protobuf.Message;
import common.metrics.client.http.IProtoClient;
import common.metrics.model.protoAutoGenerate.MetricsRequest;
import common.metrics.model.protoAutoGenerate.MetricsResponse;
import java.util.Objects;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.protobuf.ProtobufHttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class ProtoRestTemplateClient
implements IProtoClient {
    private static final String URL_PATH = "/api/metrics/events/v1";
    private RestTemplate restTemplate = null;
    private String hosts;
    private int connectTimeout = 1000;
    private int readTimeout = 1000;

    public ProtoRestTemplateClient(String host, int connectTimeout, int readTimeout) {
        this.hosts = host;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public ProtoRestTemplateClient(String host) {
        this(host, 1000, 1000);
    }

    public RestTemplate createRestTemplate() {
        if (Objects.nonNull(this.restTemplate)) {
            return this.restTemplate;
        }
        HttpComponentsClientHttpRequestFactory clientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        clientHttpRequestFactory.setConnectTimeout(this.connectTimeout);
        clientHttpRequestFactory.setReadTimeout(this.readTimeout);
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)clientHttpRequestFactory);
        this.restTemplate.getMessageConverters().add(new ProtobufHttpMessageConverter());
        return this.restTemplate;
    }

    public <T extends Message> HttpEntity<T> buildHttpEntity(T req) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/x-protobuf"));
        HttpEntity httpEntity = new HttpEntity(req, (MultiValueMap)headers);
        return httpEntity;
    }

    public static String buildURL(String host) {
        String url = String.format("%s/%s", host, URL_PATH);
        return url;
    }

    @Override
    public MetricsResponse postEvent(MetricsRequest req) {
        HttpEntity<MetricsRequest> httpEntity = this.buildHttpEntity(req);
        MetricsResponse response = (MetricsResponse)this.createRestTemplate().postForObject(ProtoRestTemplateClient.buildURL(this.hosts), httpEntity, MetricsResponse.class, new Object[0]);
        return response;
    }
}

