package common.metrics.client.utils;


import java.util.concurrent.*;

public class ExecutorThreadPool implements ThreadPool {
    private ScheduledExecutorService pool;
    boolean running = false;
    private final int initialSize;
    private final String name;

    public ExecutorThreadPool(int initialSize) {
        this(initialSize, "");
    }

    public ExecutorThreadPool(int initialSize, String name) {
        this.initialSize = initialSize;
        this.name = name;
    }

    public int getInitialSize() {
        return initialSize;
    }

    @Override
    public synchronized void start() {
        if (running) {
            return;
        }

        pool = Executors.newScheduledThreadPool(initialSize, new ThreadFactory() {
            private int num = 0;

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "MetricsClient-" + num++);
                return t;
            }
        });

        running = true;
    }

    @Override
    public synchronized void stop() {
        if (!running){
            return;
        }
        running = false;
        pool.shutdownNow();
        pool = null;
    }

    @Override
    public void background(Runnable job) {
        if (!running) {
            return;
        }

        pool.execute(job);
    }

    @Override
    public void background(Runnable callable, long delay, TimeUnit unit) {
        if (!running) {
            return;
        }
        pool.schedule(callable, delay, unit);
    }

    public void schedule(Runnable task, long initDelay, long fixedDelay, TimeUnit unit) {
        if (!running) {
            return;
        }

        pool.scheduleWithFixedDelay(task, initDelay, fixedDelay, unit);
    }

}
