/*
 * Decompiled with CFR 0.152.
 */
package common.metrics.client.utils;

import common.metrics.client.utils.ThreadPool;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ExecutorThreadPool
implements ThreadPool {
    private ScheduledExecutorService pool;
    boolean running = false;
    private final int initialSize;
    private final String name;

    public ExecutorThreadPool(int initialSize) {
        this(initialSize, "");
    }

    public ExecutorThreadPool(int initialSize, String name) {
        this.initialSize = initialSize;
        this.name = name;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    @Override
    public synchronized void start() {
        if (this.running) {
            return;
        }
        this.pool = Executors.newScheduledThreadPool(this.initialSize, new ThreadFactory(){
            private int num = 0;

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "MetricsClient-" + this.num++);
                return t;
            }
        });
        this.running = true;
    }

    @Override
    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.pool.shutdownNow();
        this.pool = null;
    }

    @Override
    public void background(Runnable job) {
        if (!this.running) {
            return;
        }
        this.pool.execute(job);
    }

    @Override
    public void background(Runnable callable, long delay, TimeUnit unit) {
        if (!this.running) {
            return;
        }
        this.pool.schedule(callable, delay, unit);
    }

    public void schedule(Runnable task, long initDelay, long fixedDelay, TimeUnit unit) {
        if (!this.running) {
            return;
        }
        this.pool.scheduleWithFixedDelay(task, initDelay, fixedDelay, unit);
    }
}

