package common.metrics.client.http.retrofit2;

import common.metrics.client.http.IProtoClient;
import common.metrics.model.ERetCode;
import common.metrics.model.protoAutoGenerate.MetricsRequest;
import common.metrics.model.protoAutoGenerate.MetricsResponse;
import okhttp3.OkHttpClient;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.protobuf.ProtoConverterFactory;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class ProtoRetrofitClient implements IProtoClient {
    private Retrofit retrofit;

    private String hosts;
    private int connectTimeout = 1000;
    private int readTimeout = 1000;

    public ProtoRetrofitClient(String hosts) {
        this(hosts, 1000, 1000);
    }

    public ProtoRetrofitClient(String hosts, int connectTimeout, int readTimeout) {
        this.hosts = hosts;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;

        OkHttpClient okHttpClient = new OkHttpClient.Builder()
                .connectTimeout(connectTimeout, TimeUnit.MILLISECONDS)
                .readTimeout(readTimeout, TimeUnit.MILLISECONDS)
                .build();

        retrofit = new Retrofit.Builder()
                .baseUrl(hosts)
                .client(okHttpClient)
                .addConverterFactory(ProtoConverterFactory.create())
                .build();
    }


    @Override
    public MetricsResponse postEvent(MetricsRequest req) {
        IMetricService metricService = retrofit.create(IMetricService.class);
//        Call<MetricsResponse> responseCall = metricService.postEvent(req);
        try {
            Response<MetricsResponse> response = metricService.postEvent(req).execute();
            if (response.isSuccessful()) {
                return response.body();
            } else {
                return MetricsResponse.newBuilder()
                        .setRet(ERetCode.RET_HTTP_CALL_FIELD.getRet())
                        .setMsg(ERetCode.RET_HTTP_CALL_FIELD.getMsg() + ",code=" + response.code())
                        .build();
            }
        } catch (IOException e) {
            return MetricsResponse.newBuilder()
                    .setRet(ERetCode.RET_HTTP_CALL_EXCEPTION.getRet())
                    .setMsg(ERetCode.RET_HTTP_CALL_EXCEPTION.getMsg() + ",exception=" + e.getMessage())
                    .build();
        }
    }
}
