/*
 * Decompiled with CFR 0.152.
 */
package common.metrics.client;

import common.metrics.client.IMetricsClient;
import common.metrics.client.MetricsConfig;
import common.metrics.client.http.ProtoHttpClientFactroy;
import common.metrics.client.utils.ExecutorThreadPool;
import common.metrics.model.ERetCode;
import common.metrics.model.protoAutoGenerate.MetricsEvent;
import common.metrics.model.protoAutoGenerate.MetricsRequest;
import common.metrics.model.protoAutoGenerate.MetricsResponse;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsClient
implements IMetricsClient {
    private Logger logger = LoggerFactory.getLogger(MetricsClient.class);
    private MetricsConfig config;
    private BlockingQueue<MetricsEvent> eventQueue = null;
    private static ExecutorThreadPool threadPool;

    private MetricsClient(MetricsConfig config) {
        this.config = config;
        if (this.getStatus()) {
            if (Objects.isNull(this.eventQueue)) {
                this.eventQueue = new LinkedBlockingQueue<MetricsEvent>(config.getQueueSize());
            }
            threadPool = new ExecutorThreadPool(Math.max(config.getThreadPoolSize(), 10));
            threadPool.start();
            threadPool.schedule(new EventConsumer(), 100L, 10L, TimeUnit.MILLISECONDS);
        } else {
            this.logger.warn("MetricsClient config is NOT Complete.");
        }
    }

    public boolean getStatus() {
        return this.config != null && this.config.isConfig();
    }

    @Override
    public ERetCode sendEvents(List<MetricsEvent> events) {
        if (!this.getStatus()) {
            return ERetCode.OK;
        }
        try {
            if (this.eventQueue.size() >= this.config.getQueueSize()) {
                return ERetCode.RET_CLIENT_OVERFLOW;
            }
            events.forEach(e -> {
                this.eventQueue.add((MetricsEvent)e);
                if (this.eventQueue.size() > this.config.getPostBatchSize()) {
                    threadPool.background(new EventConsumer());
                }
            });
        }
        catch (Exception e2) {
            return ERetCode.RET_CLIENT_OVERFLOW;
        }
        return ERetCode.OK;
    }

    private void send2Server(List<MetricsEvent> events) {
        if (!this.getStatus()) {
            return;
        }
        MetricsRequest request = MetricsRequest.newBuilder().setAppId(this.config.getAppId()).setAppKey(this.config.getAppKey()).addAllEvents(events).build();
        MetricsResponse response = ProtoHttpClientFactroy.protoClientOverRetrofit(this.config.getHttpHosts(), this.config.getHttpConnectTimeout(), this.config.getHttpReadTimeout()).postEvent(request);
        this.logger.info("Metrics Send Result:[{}:{}] Size:[{}] Host:[{}]", new Object[]{response.getRet(), response.getMsg(), events.size(), this.config.getHttpHosts()});
    }

    public static final class Builder {
        private MetricsClient instance = null;

        public MetricsClient build(MetricsConfig config) {
            if (Objects.isNull(this.instance)) {
                this.instance = new MetricsClient(config);
            }
            return this.instance;
        }
    }

    private class EventConsumer
    implements Runnable {
        private EventConsumer() {
        }

        @Override
        public void run() {
            LinkedList<MetricsEvent> entryList = new LinkedList<MetricsEvent>();
            MetricsEvent entry = null;
            try {
                while ((entry = (MetricsEvent)MetricsClient.this.eventQueue.poll()) != null) {
                    entryList.add(entry);
                    if (entryList.size() < MetricsClient.this.config.getPostBatchSize()) continue;
                    break;
                }
            }
            catch (Exception ex) {
                MetricsClient.this.logger.error("MetricsClient:Failed to get events from queue.", (Throwable)ex);
            }
            if (entryList.size() > 0) {
                try {
                    MetricsClient.this.send2Server(entryList);
                    MetricsClient.this.logger.debug("MetricsClient: request sent: count={0}", (Object)entryList.size());
                }
                catch (Exception e) {
                    MetricsClient.this.logger.error("MetricsClient:Send to server failed!.", (Throwable)e);
                }
            }
        }
    }
}

