package common.metrics.client.http;

import com.google.common.collect.Maps;
import common.metrics.client.http.restTemplate.ProtoRestTemplateClient;
import common.metrics.client.http.retrofit2.ProtoRetrofitClient;

import java.util.Map;

public class ProtoHttpClientFactroy {
    private static Map<String, IProtoClient> clientMap = Maps.newHashMap();

    public static IProtoClient protoClientOverRestTemplate(String hosts) {
        return protoClient(EHttpClientType.REST_TEMPLATE, hosts, 1000, 1000);
    }

    public static IProtoClient protoClientOverRestTemplate(String hosts, int connectTimeout, int readTimeout) {
        return protoClient(EHttpClientType.REST_TEMPLATE, hosts, connectTimeout, readTimeout);
    }

    public static IProtoClient protoClientOverRetrofit(String hosts) {
        return protoClient(EHttpClientType.RETROFIT2, hosts, 1000, 1000);
    }

    public static IProtoClient protoClientOverRetrofit(String hosts, int connectTimeout, int readTimeout) {
        return protoClient(EHttpClientType.RETROFIT2, hosts, connectTimeout, readTimeout);
    }

    public static IProtoClient protoClient(EHttpClientType type, String hosts) {
        return protoClientOverRetrofit(hosts, 1000, 1000);
    }

    public static IProtoClient protoClient(EHttpClientType type, String hosts, int connectTimeout, int readTimeout) {
        if (!clientMap.containsKey(hosts)) {
            synchronized (hosts) {
                if (type == EHttpClientType.RETROFIT2) {
                    clientMap.putIfAbsent(hosts, new ProtoRetrofitClient(hosts, connectTimeout, readTimeout));
                }
                if (type == EHttpClientType.REST_TEMPLATE) {
                    clientMap.putIfAbsent(hosts, new ProtoRestTemplateClient(hosts, connectTimeout, readTimeout));
                }
            }
        }

        IProtoClient client = clientMap.get(hosts);
        return client;
    }
}
