/*
 * Decompiled with CFR 0.152.
 */
package common.metrics.client;

import com.google.common.base.Strings;
import java.util.Objects;

public class MetricsConfig {
    private String appId;
    private String appKey;
    private int threadPoolSize = 10;
    private int queueSize = 100000;
    private int postBatchSize = 1000;
    private String httpHosts;
    private int httpConnectTimeout = 1000;
    private int httpReadTimeout = 1000;

    public String getAppId() {
        return this.appId;
    }

    public MetricsConfig setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public MetricsConfig setAppKey(String appKey) {
        this.appKey = appKey;
        return this;
    }

    public String getHttpHosts() {
        return this.httpHosts;
    }

    public MetricsConfig setHttpHosts(String httpHosts) {
        this.httpHosts = httpHosts;
        return this;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public MetricsConfig setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
        return this;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public MetricsConfig setQueueSize(int queueSize) {
        this.queueSize = queueSize;
        return this;
    }

    public int getPostBatchSize() {
        return this.postBatchSize;
    }

    public MetricsConfig setPostBatchSize(int postBatchSize) {
        this.postBatchSize = postBatchSize;
        return this;
    }

    public int getHttpConnectTimeout() {
        return this.httpConnectTimeout;
    }

    public MetricsConfig setHttpConnectTimeout(int httpConnectTimeout) {
        this.httpConnectTimeout = httpConnectTimeout;
        return this;
    }

    public int getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    public MetricsConfig setHttpReadTimeout(int httpReadTimeout) {
        this.httpReadTimeout = httpReadTimeout;
        return this;
    }

    public boolean isConfig() {
        return !Strings.isNullOrEmpty((String)this.getAppId()) && !Strings.isNullOrEmpty((String)this.getHttpHosts());
    }

    public static final class Builder {
        private MetricsConfig instance = null;
        private static Builder builderInstance = null;

        public static Builder newBuilder() {
            if (Objects.nonNull(builderInstance)) {
                builderInstance = new Builder();
            }
            return builderInstance;
        }

        public MetricsConfig build() {
            if (Objects.isNull(this.instance)) {
                this.instance = new MetricsConfig();
            }
            return this.instance;
        }
    }
}

