/*
 * Decompiled with CFR 0.152.
 */
package common.metrics.micrometer.registry;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import common.metrics.micrometer.registry.IMetricsMeterRegistryConfig;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.MeterFilterReply;
import java.util.List;

public class MetricsMeterFilter
implements MeterFilter {
    private final IMetricsMeterRegistryConfig config;

    public MetricsMeterFilter(IMetricsMeterRegistryConfig config) {
        this.config = config;
    }

    public MeterFilterReply accept(Meter.Id id) {
        int ret = this.checkName(this.config.getAllowNames(), id.getName());
        if (ret == -1) {
            return MeterFilterReply.DENY;
        }
        ret = this.checkName(this.config.getDenyNames(), id.getName());
        if (ret == 1) {
            return MeterFilterReply.DENY;
        }
        return super.accept(id);
    }

    public int checkName(String valueSet, String value) {
        if (Strings.isNullOrEmpty((String)valueSet)) {
            return 0;
        }
        List nameSets = Splitter.on((String)",").splitToList((CharSequence)valueSet);
        for (String v : nameSets) {
            boolean match = value.matches(v);
            if (!match) continue;
            return 1;
        }
        return -1;
    }

    public int checkTags(String valueSet, List<Tag> tags) {
        return 0;
    }
}

