/*
 * Decompiled with CFR 0.152.
 */
package common.metrics.micrometer.registry;

import com.google.common.collect.Lists;
import common.metrics.client.MetricsClient;
import common.metrics.client.MetricsConfig;
import common.metrics.micrometer.registry.IMetricsMeterRegistryConfig;
import common.metrics.micrometer.registry.MetricsMeterFormat;
import common.metrics.model.ERetCode;
import common.metrics.model.protoAutoGenerate.FieldValue;
import common.metrics.model.protoAutoGenerate.MetricsEvent;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Timer;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricMeterSender {
    private Logger logger = LoggerFactory.getLogger(MetricMeterSender.class);
    private MetricsClient client;

    public MetricMeterSender(IMetricsMeterRegistryConfig config) {
        MetricsConfig metricsConfig = new MetricsConfig.Builder().build();
        metricsConfig.setAppId(config.getAppId()).setAppKey(config.getAppKey()).setQueueSize(config.clientQueueSize()).setPostBatchSize(config.clientBatchSize()).setThreadPoolSize(config.clientThreadSize()).setHttpHosts(config.getHost()).setHttpConnectTimeout(config.httpConnectTimeout()).setHttpReadTimeout(config.httpReadTimeout());
        this.client = new MetricsClient.Builder().build(metricsConfig);
    }

    public void sendReport(List<Meter> meters) {
        ERetCode ret;
        List<MetricsEvent> events = this.buildMetricsEvent(meters);
        if (events.size() > 0 && !(ret = this.client.sendEvents(events)).isSuccess()) {
            this.logger.warn("Send Event failed! ret=[{}]", (Object)ret);
        }
    }

    private List<MetricsEvent> buildMetricsEvent(List<Meter> meters) {
        LinkedList events = Lists.newLinkedList();
        for (Meter meter : meters) {
            MetricsEvent.Builder builder = MetricsEvent.newBuilder();
            builder.setEventId(meter.getId().getName());
            meter.getId().getTags().forEach(e -> builder.putTags(e.getKey(), e.getValue()));
            meter.measure().forEach(e -> builder.addFields(FieldValue.newBuilder().setKey(e.getStatistic().name()).setNumValue(MetricsMeterFormat.measureValueToLong(e.getValue()).longValue()).build()));
            if (meter instanceof Timer) {
                long mean = MetricsMeterFormat.measureValueToLong(((Timer)meter).mean(TimeUnit.MILLISECONDS));
                builder.addFields(FieldValue.newBuilder().setKey("MEAN").setNumValue(mean).build());
            }
            events.add(builder.build());
        }
        return events;
    }
}

