/*
 * Decompiled with CFR 0.152.
 */
package common.metrics.micrometer.registry;

import com.google.common.base.Strings;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class MetricsMeterFormat {
    public static String format(Meter meter) {
        if (Objects.isNull(meter)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("name=").append(meter.getId().getName()).append(" ");
        sb.append("type=").append(meter.getId().getType().name()).append(" ");
        String tagStr = MetricsMeterFormat.formatTags(meter.getId().getTags());
        if (!Strings.isNullOrEmpty((String)tagStr)) {
            sb.append(tagStr).append(" ");
        }
        sb.append(MetricsMeterFormat.formatMeasure(meter.measure()));
        if (meter instanceof Timer) {
            double mean = ((Timer)meter).mean(TimeUnit.MILLISECONDS);
            sb.append("AVG=").append(Double.valueOf(mean).longValue()).append(" ");
        }
        return sb.toString();
    }

    public static String formatTags(List<Tag> tags) {
        StringBuilder sb = new StringBuilder();
        tags.forEach(e -> sb.append(e.getKey()).append("=").append(e.getValue()).append(" "));
        return sb.toString();
    }

    public static String formatMeasure(Iterable<Measurement> it) {
        StringBuilder sb = new StringBuilder();
        it.forEach(m -> sb.append(m.getStatistic().name()).append("=").append(Double.valueOf(m.getValue()).longValue()).append(" "));
        return sb.toString();
    }

    public static String measureValueToString(double value) {
        return Long.valueOf(Double.valueOf(value).longValue()).toString();
    }

    public static Long measureValueToLong(double value) {
        return Double.valueOf(value).longValue();
    }
}

