package common.metrics.micrometer.registry;

import com.google.common.base.Strings;
import common.config.tools.config.ConfigTools3;
import io.micrometer.core.instrument.step.StepRegistryConfig;

import java.util.Objects;

import static common.metrics.micrometer.registry.MetricsMeterConstants.*;


public interface IMetricsMeterRegistryConfig extends StepRegistryConfig {

    @Override
    default String prefix() {
        return MetricsMeterConstants.CONFIG_PREFIX;
    }

    @Override
    default String get(String key) {
        String k = appConfigKey(key);
        String v = ConfigTools3.getString(k);
        if (Strings.isNullOrEmpty(v)) {
            v = ConfigTools3.getString(key);
        }

        return Strings.emptyToNull(v);
    }

    default String prefixedKey(String key) {
        return String.format("%s.%s", prefix(), key);
    }

    default String appConfigKey(String key) {
        return String.format("%s.%s", getAppId(), key);
    }

    default String appPrefixedKey(String key) {
        return String.format("%s.%s.%s", prefix(), key, getAppId());
    }

    default String getStr(String key) {
        String val = ConfigTools3.getString(appPrefixedKey(key));
        if (!Strings.isNullOrEmpty(val)) {
            return val;
        }

        val = ConfigTools3.getString(prefixedKey(key));
        return Strings.emptyToNull(val);
    }

    default int getInt(String key, int defaultVal) {
        Integer val = ConfigTools3.getInt(appPrefixedKey(key));
        if (Objects.nonNull(val)) {
            return val;
        }

        val = ConfigTools3.getInt(prefixedKey(key));
        return val == null ? defaultVal : val;
    }

    default boolean getBoolean(String key) {
        Boolean result = ConfigTools3.getBoolean(appPrefixedKey(key));
        if (Objects.isNull(result)) {
            result = ConfigTools3.getBoolean(prefixedKey(key));
        }

        return Objects.isNull(result) ? false : result;
    }


    default String getAppId() {
        return ConfigTools3.getString(prefixedKey(CONFIG_APPID), "sample");
    }

    default String getAppKey() {
        return ConfigTools3.getString(prefixedKey(CONFIG_APPKEY), "sample");
    }

    default String getHost() {
        return getStr(CONFIG_SERVER_HOST);
    }

    default String getAllowNames() {
        return getStr(MetricsMeterConstants.CONFIG_FILTER_ALLOW_NAMES);
    }

    default String getDenyNames() {
        return getStr(MetricsMeterConstants.CONFIG_FILTER_DENY_NAMES);
    }

    default String getAllowTags() {
        return getStr(MetricsMeterConstants.CONFIG_FILTER_ALLOW_TAGS);
    }

    default String getDenyTags() {
        return getStr(MetricsMeterConstants.CONFIG_FILTER_DENY_TAGS);
    }

    default int httpConnectTimeout() {
        return getInt("server.connectTimeout", 1000);
    }

    default int httpReadTimeout() {
        return getInt("server.readTimeout", 1000);
    }

    default int clientQueueSize() {
        return getInt("client.queueSize", 10_000);
    }

    default int clientBatchSize() {
        return getInt("client.batchSize", 1000);
    }

    default int clientThreadSize() {
        return getInt("client.threadSize", 3);
    }
}
