package common.metrics.micrometer.registry;

import common.config.tools.config.ConfigTools3;
import common.log.Logging;
import common.base.tools.sys.SystemTools;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.step.StepMeterRegistry;


import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class MetricsMeterRegistry extends StepMeterRegistry {
//    private Logger logger = LoggerFactory.getLogger(MetricsMeterRegistry.class);
    private IMetricsMeterRegistryConfig config;
    private MetricMeterSender meterSender;

    public MetricsMeterRegistry(IMetricsMeterRegistryConfig config, Clock clock) {
        super(config, clock);
        this.config = config;
        this.config().meterFilter(new MetricsMeterFilter(config));

        meterSender = new MetricMeterSender(config);

        //add common tag
        this.config().commonTags("host", SystemTools.getHostname(), "appId", config.getAppId());

        bindJvmMeter(config);

        this.start(Executors.defaultThreadFactory());
        Metrics.addRegistry(this);
    }

    private void bindJvmMeter(IMetricsMeterRegistryConfig config) {
        Tags commonTags = Tags.empty();
        commonTags.and("category", "system");

        if (config.getBoolean(MetricsMeterConstants.CONFIG_ENABLE_JVM_MEMORY)) {
            new JvmMemoryMetrics().bindTo(this);
        }

        if (config.getBoolean(MetricsMeterConstants.CONFIG_ENABLE_JVM_GC)) {
            new JvmGcMetrics().bindTo(this);
        }

        if (config.getBoolean(MetricsMeterConstants.CONFIG_ENABLE_JVM_THREAD)) {
            new JvmThreadMetrics().bindTo(this);
        }

        if (config.getBoolean(MetricsMeterConstants.CONFIG_ENABLE_PROCESSOR)) {
            new ProcessorMetrics().bindTo(this);
        }
    }

    public MetricsMeterRegistry(IMetricsMeterRegistryConfig config) {
        this(config, Clock.SYSTEM);
    }

    @Override
    protected void publish() {
        try {
            boolean pretty = config.getBoolean(MetricsMeterConstants.CONFIG_PRETTY_PRINT);
            MetricsMeterFormat.formatMeters(getMeters(),pretty);

            if (config.enabled()) {
                meterSender.sendReport(getMeters());
            }
        }finally {
            //上报完之后清除meter
            clear();
        }
    }


    @Override
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }
}