/*
 * Decompiled with CFR 0.152.
 */
package common.metrics.micrometer.registry;

import common.base.tools.sys.SystemTools;
import common.metrics.micrometer.registry.IMetricsMeterRegistryConfig;
import common.metrics.micrometer.registry.MetricMeterSender;
import common.metrics.micrometer.registry.MetricsMeterFilter;
import common.metrics.micrometer.registry.MetricsMeterFormat;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class MetricsMeterRegistry
extends StepMeterRegistry {
    private IMetricsMeterRegistryConfig config;
    private MetricMeterSender meterSender;

    public MetricsMeterRegistry(IMetricsMeterRegistryConfig config, Clock clock) {
        super((StepRegistryConfig)config, clock);
        this.config = config;
        this.config().meterFilter((MeterFilter)new MetricsMeterFilter(config));
        this.meterSender = new MetricMeterSender(config);
        this.config().commonTags(new String[]{"host", SystemTools.getHostname(), "appId", config.getAppId()});
        this.bindJvmMeter(config);
        this.start(Executors.defaultThreadFactory());
        Metrics.addRegistry((MeterRegistry)this);
    }

    private void bindJvmMeter(IMetricsMeterRegistryConfig config) {
        Tags commonTags = Tags.empty();
        commonTags.and("category", "system");
        if (config.getBoolean("jvm.memory.enable")) {
            new JvmMemoryMetrics().bindTo((MeterRegistry)this);
        }
        if (config.getBoolean("jvm.gc.enable")) {
            new JvmGcMetrics().bindTo((MeterRegistry)this);
        }
        if (config.getBoolean("jvm.thread.enable")) {
            new JvmThreadMetrics().bindTo((MeterRegistry)this);
        }
        if (config.getBoolean("processor.enable")) {
            new ProcessorMetrics().bindTo((MeterRegistry)this);
        }
    }

    public MetricsMeterRegistry(IMetricsMeterRegistryConfig config) {
        this(config, Clock.SYSTEM);
    }

    protected void publish() {
        try {
            boolean pretty = this.config.getBoolean("pretty.print");
            MetricsMeterFormat.formatMeters(this.getMeters(), pretty);
            if (this.config.enabled()) {
                this.meterSender.sendReport(this.getMeters());
            }
        }
        finally {
            this.clear();
        }
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }
}

