/*
 * Decompiled with CFR 0.152.
 */
package common.metrics.micrometer.registry;

import com.google.common.base.Strings;
import common.config.tools.config.ConfigTools3;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import java.util.Objects;

public interface IMetricsMeterRegistryConfig
extends StepRegistryConfig {
    default public String prefix() {
        return "metrics";
    }

    default public String get(String key) {
        String k = this.appConfigKey(key);
        String v = ConfigTools3.getString((String)k);
        if (Strings.isNullOrEmpty((String)v)) {
            v = ConfigTools3.getString((String)key);
        }
        return Strings.emptyToNull((String)v);
    }

    default public String prefixedKey(String key) {
        return String.format("%s.%s", this.prefix(), key);
    }

    default public String appConfigKey(String key) {
        return String.format("%s.%s", this.getAppId(), key);
    }

    default public String appPrefixedKey(String key) {
        return String.format("%s.%s.%s", this.prefix(), key, this.getAppId());
    }

    default public String getStr(String key) {
        String val = ConfigTools3.getString((String)this.appPrefixedKey(key));
        if (!Strings.isNullOrEmpty((String)val)) {
            return val;
        }
        val = ConfigTools3.getString((String)this.prefixedKey(key));
        return Strings.emptyToNull((String)val);
    }

    default public int getInt(String key, int defaultVal) {
        Integer val = ConfigTools3.getInt((String)this.appPrefixedKey(key));
        if (Objects.nonNull(val)) {
            return val;
        }
        val = ConfigTools3.getInt((String)this.prefixedKey(key));
        return val == null ? defaultVal : val;
    }

    default public boolean getBoolean(String key) {
        Boolean result = ConfigTools3.getBoolean((String)this.appPrefixedKey(key));
        if (Objects.isNull(result)) {
            result = ConfigTools3.getBoolean((String)this.prefixedKey(key));
        }
        return Objects.isNull(result) ? false : result;
    }

    default public String getAppId() {
        return ConfigTools3.getString((String)this.prefixedKey("appid"), (String)"sample");
    }

    default public String getAppKey() {
        return ConfigTools3.getString((String)this.prefixedKey("appkey"), (String)"sample");
    }

    default public String getHost() {
        return this.getStr("server.host");
    }

    default public String getAllowNames() {
        return this.getStr("filter.names.allow");
    }

    default public String getDenyNames() {
        return this.getStr("filter.names.deny");
    }

    default public String getAllowTags() {
        return this.getStr("filter.tags.allow");
    }

    default public String getDenyTags() {
        return this.getStr("filter.tags.deny");
    }

    default public int httpConnectTimeout() {
        return this.getInt("server.connectTimeout", 1000);
    }

    default public int httpReadTimeout() {
        return this.getInt("server.readTimeout", 1000);
    }

    default public int clientQueueSize() {
        return this.getInt("client.queueSize", 10000);
    }

    default public int clientBatchSize() {
        return this.getInt("client.batchSize", 1000);
    }

    default public int clientThreadSize() {
        return this.getInt("client.threadSize", 3);
    }

    default public boolean enableToServer() {
        return !Strings.isNullOrEmpty((String)this.getHost()) && !Strings.isNullOrEmpty((String)this.getAppId());
    }
}

