/*
 * Decompiled with CFR 0.152.
 */
package common.metrics.micrometer.registry;

import com.google.common.base.Strings;
import common.base.tools.sys.SystemTools;
import common.metrics.micrometer.registry.IMetricsMeterRegistryConfig;
import common.metrics.micrometer.registry.MetricMeterSender;
import common.metrics.micrometer.registry.MetricsMeterFilter;
import common.metrics.micrometer.registry.MetricsMeterFormat;
import common.metrics.micrometer.registry.SystemMetrics;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class MetricsMeterRegistry
extends StepMeterRegistry {
    private IMetricsMeterRegistryConfig config;
    private MetricMeterSender meterSender;

    public MetricsMeterRegistry(IMetricsMeterRegistryConfig config, Clock clock) {
        super((StepRegistryConfig)config, clock);
        this.config = config;
        this.config().meterFilter((MeterFilter)new MetricsMeterFilter(config));
        this.meterSender = new MetricMeterSender(config);
        if (this.config.enabled()) {
            this.config().commonTags(new String[]{"host", SystemTools.getHostname(), "appId", config.getAppId()});
        }
        this.start(Executors.defaultThreadFactory());
        Metrics.addRegistry((MeterRegistry)this);
    }

    private void bindJvmMeter(IMetricsMeterRegistryConfig config) {
        if (config.getBoolean("jvm.memory.enable")) {
            new JvmMemoryMetrics((Iterable)Tags.of((String)"system", (String)"memory")).bindTo((MeterRegistry)this);
        }
        if (config.getBoolean("jvm.gc.enable")) {
            new JvmGcMetrics((Iterable)Tags.of((String)"system", (String)"GC")).bindTo((MeterRegistry)this);
        }
        if (config.getBoolean("jvm.thread.enable")) {
            new JvmThreadMetrics((Iterable)Tags.of((String)"system", (String)"thread")).bindTo((MeterRegistry)this);
        }
        if (config.getBoolean("processor.enable")) {
            new ProcessorMetrics((Iterable)Tags.of((String)"system", (String)"cpu")).bindTo((MeterRegistry)this);
        }
    }

    public MetricsMeterRegistry(IMetricsMeterRegistryConfig config) {
        this(config, Clock.SYSTEM);
    }

    protected void publish() {
        try {
            SystemMetrics.getInstance().publish((MeterRegistry)this);
            if (this.config.enabled()) {
                boolean pretty = this.config.getBoolean("pretty.print");
                MetricsMeterFormat.formatMeters(this.getMeters().stream().filter(this::nonSystemMetric).collect(Collectors.toList()), pretty);
                MetricsMeterFormat.formatMeters(this.getMeters().stream().filter(this::isSystemMetric).collect(Collectors.toList()), pretty);
                if (this.config.enableToServer()) {
                    this.meterSender.sendReport(this.getMeters());
                }
            }
        }
        finally {
            this.clear();
        }
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    private boolean isSystemMetric(Meter meter) {
        String value = meter.getId().getTag("_system_");
        return !Strings.isNullOrEmpty((String)value);
    }

    private boolean nonSystemMetric(Meter meter) {
        return !this.isSystemMetric(meter);
    }
}

