/*
 * Decompiled with CFR 0.152.
 */
package common.metrics.micrometer.registry;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import common.metrics.micrometer.registry.MetricsMeterFormat;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Timer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class MetricsPoint {
    private String appid;
    private String host;
    private String type;
    private String name;
    private String item;
    private Map<String, String> tags = Maps.newLinkedHashMap();
    private Map<String, String> values = Maps.newLinkedHashMap();

    public String getType() {
        return this.type;
    }

    public MetricsPoint setType(String type) {
        this.type = type;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public MetricsPoint setName(String name) {
        this.name = name;
        return this;
    }

    public String getItem() {
        return this.item;
    }

    public MetricsPoint setItem(String item) {
        this.item = item;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public MetricsPoint setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public MetricsPoint addTag(String key, String value) {
        this.tags.put(key, value);
        return this;
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public MetricsPoint setValues(Map<String, String> values) {
        this.values = values;
        return this;
    }

    public MetricsPoint addValue(String key, String value) {
        this.values.put(key, value);
        return this;
    }

    public String getAppid() {
        return this.appid;
    }

    public MetricsPoint setAppid(String appid) {
        this.appid = appid;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public MetricsPoint setHost(String host) {
        this.host = host;
        return this;
    }

    public String getCount() {
        return this.values.getOrDefault("count", "-");
    }

    public String getMax() {
        return this.values.getOrDefault("max", "-");
    }

    public String getAvg() {
        return this.values.getOrDefault("avg", "-");
    }

    public String getTagsStr() {
        String str = this.formatTags(this.tags);
        if (!Strings.isNullOrEmpty((String)str)) {
            return str;
        }
        return "-";
    }

    public String getValuesStr() {
        String str = this.formatValues(this.values);
        if (!Strings.isNullOrEmpty((String)str)) {
            return str;
        }
        return "-";
    }

    private static String getItem(Meter.Id id) {
        String item = id.getTag("apiName");
        if (Strings.isNullOrEmpty((String)item)) {
            item = id.getTag("item");
        }
        return Strings.nullToEmpty((String)item);
    }

    public static MetricsPoint valueOf(Meter meter) {
        MetricsPoint point = new MetricsPoint();
        point.setAppid(meter.getId().getTag("appId"));
        point.setHost(meter.getId().getTag("host"));
        point.setName(meter.getId().getName());
        point.setType(meter.getId().getType().name());
        point.setItem(MetricsPoint.getItem(meter.getId()));
        meter.getId().getTags().forEach(t -> point.addTag(t.getKey(), t.getValue()));
        if (meter instanceof Timer) {
            Timer timer = (Timer)meter;
            point.addValue("count", MetricsMeterFormat.measureValueToString(timer.count()));
            point.addValue("max", MetricsMeterFormat.measureValueToString(timer.max(TimeUnit.MILLISECONDS)));
            point.addValue("avg", MetricsMeterFormat.measureValueToString(timer.mean(TimeUnit.MILLISECONDS)));
            return point;
        }
        if (meter instanceof LongTaskTimer) {
            LongTaskTimer timer = (LongTaskTimer)meter;
            point.addValue("count", MetricsMeterFormat.measureValueToString(timer.activeTasks()));
            point.addValue("max", MetricsMeterFormat.measureValueToString(timer.max(TimeUnit.MILLISECONDS)));
            point.addValue("avg", MetricsMeterFormat.measureValueToString(timer.mean(TimeUnit.MILLISECONDS)));
            return point;
        }
        if (meter instanceof Gauge) {
            Gauge gauge = (Gauge)meter;
            point.addValue("avg", MetricsMeterFormat.measureValueToString(gauge.value()));
            return point;
        }
        if (meter instanceof Counter) {
            Counter counter = (Counter)meter;
            point.addValue("count", MetricsMeterFormat.measureValueToString(counter.count()));
            return point;
        }
        meter.measure().forEach(e -> point.addValue(e.getStatistic().name(), MetricsMeterFormat.measureValueToString(e.getValue())));
        return point;
    }

    private String formatValues(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey().equalsIgnoreCase("count") || entry.getKey().equalsIgnoreCase("max") || entry.getKey().equalsIgnoreCase("avg")) continue;
            sb.append(entry.getKey()).append(":").append(entry.getValue()).append(" ");
        }
        return sb.toString();
    }

    private String formatTags(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey().equalsIgnoreCase("apiName") || entry.getKey().equalsIgnoreCase("appId") || entry.getKey().equalsIgnoreCase("host") || entry.getKey().equalsIgnoreCase("item")) continue;
            sb.append(entry.getKey()).append(":").append(entry.getValue()).append(" ");
        }
        return sb.toString();
    }

    public Collection<String> getTextAsCollection() {
        return ImmutableList.of((Object)this.getAppid(), (Object)this.getHost(), (Object)this.getType(), (Object)this.getName(), (Object)this.getItem(), (Object)this.getCount(), (Object)this.getAvg(), (Object)this.getMax(), (Object)this.getTagsStr(), (Object)this.getValuesStr());
    }

    public static List<String> getHeaderAsCollection() {
        return ImmutableList.of((Object)"appid", (Object)"host", (Object)"type", (Object)"name", (Object)"item", (Object)"count", (Object)"avg", (Object)"max", (Object)"tags", (Object)"values");
    }
}

