/*
 * Decompiled with CFR 0.152.
 */
package common.metrics.micrometer.registry;

import com.google.common.collect.Maps;
import common.metrics.micrometer.registry.IMetricsMeterRegistryConfig;
import common.metrics.micrometer.registry.MetricsMeterRegistryConfig;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemMetrics {
    private static Logger logger = LoggerFactory.getLogger(SystemMetrics.class);
    private IMetricsMeterRegistryConfig config;
    private Map<String, MeterBinder> binderMap = Maps.newHashMap();
    private long systemLatestReport = 0L;

    public SystemMetrics() {
        this.config = new MetricsMeterRegistryConfig();
        this.addBind("jvm.memory", (MeterBinder)new JvmMemoryMetrics((Iterable)Tags.of((String)"_system_", (String)"jvm.memory")));
        this.addBind("jvm.gc", (MeterBinder)new JvmGcMetrics((Iterable)Tags.of((String)"_system_", (String)"jvm.gc")));
        this.addBind("jvm.thread", (MeterBinder)new JvmThreadMetrics((Iterable)Tags.of((String)"_system_", (String)"jvm.thread")));
        this.addBind("processor", (MeterBinder)new ProcessorMetrics((Iterable)Tags.of((String)"_system_", (String)"cpu.load")));
    }

    public void addBind(String key, MeterBinder binder) {
        if (!this.binderMap.containsKey(key)) {
            this.binderMap.putIfAbsent(key, binder);
            logger.info("Add Metrics bind:[{}]", (Object)key);
        } else {
            logger.info("Metrics bind already exists:[{}]", (Object)key);
        }
    }

    public boolean checkAndSetReportStep() {
        int systemStep = this.config.getInt("metrics.system.report.step", 300);
        long current = System.currentTimeMillis() / 1000L;
        if (current - this.systemLatestReport > (long)systemStep) {
            this.systemLatestReport = current;
            return true;
        }
        return false;
    }

    public void publish(MeterRegistry registry) {
        if (!this.checkAndSetReportStep()) {
            return;
        }
        for (String key : this.binderMap.keySet()) {
            MeterBinder binder;
            String configKey = String.format("%s.enable", key);
            if (!this.config.getBoolean(configKey) || !Objects.nonNull(binder = this.binderMap.get(key))) continue;
            binder.bindTo(registry);
        }
    }

    public static SystemMetrics getInstance() {
        return SystemMetricsHolder.INSTANCE;
    }

    private static class SystemMetricsHolder {
        private static SystemMetrics INSTANCE = new SystemMetrics();

        private SystemMetricsHolder() {
        }
    }
}

