package common.metrics.micrometer.registry;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.MeterFilterReply;


import java.util.List;

public class MetricsMeterFilter implements MeterFilter {
    private final IMetricsMeterRegistryConfig config;

    public MetricsMeterFilter(IMetricsMeterRegistryConfig config) {
        this.config = config;
    }

    @Override
    public MeterFilterReply accept(Meter.Id id) {

        //check name
        int ret = checkName(config.getAllowNames(), id.getName());
        if (ret == -1) {
            return MeterFilterReply.DENY;
        }

        ret = checkName(config.getDenyNames(), id.getName());
        if (ret == 1) {
            return MeterFilterReply.DENY;
        }

        //check tags

        return MeterFilter.super.accept(id);
    }


    /**
     * Check name is accept or not
     *
     * @param valueSet:configuration name set
     * @param value:name
     * @return 0  : Normal  1  : Include -1 : Not include
     */
    public int checkName(String valueSet, String value) {
        if (Strings.isNullOrEmpty(valueSet)) {
            return 0;
        }

        List<String> nameSets = Splitter.on(",").splitToList(valueSet);
        for (String v : nameSets) {
            boolean match = value.matches(v);
            if (match) {
                return 1;
            }
        }
        return -1;

    }

    public int checkTags(String valueSet, List<Tag> tags) {
        return 0;
    }
}
