package common.metrics.model;

/**
 * @author Frank.Huang
 */
public enum ERetCode {
    // Success
    OK(0, "OK"),

    //client cache overflow
    RET_CLIENT_OVERFLOW(1001, "Client queue overflow"),

    //appid not support
    RET_APPID_NOT_SUPPORT(1002, "Appid not support"),

    //Http call field
    RET_HTTP_CALL_FIELD(1003, "Http call field"),

    //HTTP call exception
    RET_HTTP_CALL_EXCEPTION(1004, "Http call exception");

    private ERetCode(int ret, String msg) {
        this.ret = ret;
        this.msg = msg;
    }

    private int ret = 0;
    private String msg = "ok";

    public int getRet() {
        return ret;
    }

    public String getMsg() {
        return msg;
    }

    public boolean isSuccess() {
        return ret == ERetCode.OK.ordinal();
    }

    @Override
    public String toString() {
        return String.format("%d:%s", ret, msg);
    }
}
