package common.metrics.starter.filter;

import com.google.common.base.Strings;
import common.config.tools.config.ConfigTools3;
import common.metrics.micrometer.registry.MetricsMeterRegistry;
import io.micrometer.core.instrument.Timer;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;


/**
 * MetricsFilter: record API time consume
 */
public class MetricsFilter implements Filter {
    private MetricsMeterRegistry registry;

    public MetricsFilter(MetricsMeterRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {

    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {

        Timer.Sample sample = Timer.start();
        try {
            chain.doFilter(request, response);
        } finally {
            HttpServletRequest httpRequest = (HttpServletRequest) request;
            HttpServletResponse httpResponse = (HttpServletResponse) response;

            String apiName = HttpTools.getRequestURI(httpRequest);
            String clientIp = HttpTools.getRemoteHost(httpRequest);
            int status = httpResponse.getStatus();

            Timer.Builder builder = Timer.builder("apiStat")
                    .tag("apiName", apiName)
                    .tag("status", String.valueOf(status));

            if (!Strings.isNullOrEmpty(clientIp)) {
                builder.tag("clientIp", clientIp);
            }

            if (ConfigTools3.getBoolean("metrics.trace.session.enabled", false)) {
                Map<String, String> requestMap = HttpTools.getRequestMap(httpResponse);
                requestMap.forEach((k, v) -> {
                    if (!Strings.isNullOrEmpty(k) && !Strings.isNullOrEmpty(v)) {
                        builder.tag(k, v);
                    }
                });
            }

            sample.stop(builder.register(registry));
        }
    }

    @Override
    public void destroy() {

    }
}
