/*
 * Decompiled with CFR 0.152.
 */
package common.metrics.starter.filter;

import com.google.common.base.Strings;
import common.config.tools.config.ConfigTools3;
import common.metrics.micrometer.registry.MetricsMeterRegistry;
import common.metrics.starter.filter.HttpTools;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MetricsFilter
implements Filter {
    private MetricsMeterRegistry registry;

    public MetricsFilter(MetricsMeterRegistry registry) {
        this.registry = registry;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Timer.Sample sample = Timer.start();
        try {
            chain.doFilter(request, response);
        }
        finally {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String apiName = HttpTools.getRequestURI(httpRequest);
            String clientIp = HttpTools.getRemoteHost(httpRequest);
            int status = httpResponse.getStatus();
            Timer.Builder builder = Timer.builder((String)"apiStat").tag("apiName", apiName).tag("status", String.valueOf(status));
            if (!Strings.isNullOrEmpty((String)clientIp)) {
                builder.tag("clientIp", clientIp);
            }
            if (ConfigTools3.getBoolean((String)"metrics.trace.session.enabled", (boolean)false)) {
                Map<String, String> requestMap = HttpTools.getRequestMap(httpResponse);
                requestMap.forEach((k, v) -> {
                    if (!Strings.isNullOrEmpty((String)k) && !Strings.isNullOrEmpty((String)v)) {
                        builder.tag(k, v);
                    }
                });
            }
            sample.stop(builder.register((MeterRegistry)this.registry));
        }
    }

    public void destroy() {
    }
}

