/*
 * Decompiled with CFR 0.152.
 */
package common.metrics.starter.filter;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import common.config.tools.config.ConfigTools3;
import common.metrics.micrometer.registry.MetricsMeterRegistry;
import common.metrics.starter.filter.HttpTools;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MetricsFilter
implements Filter {
    private MetricsMeterRegistry registry;

    public MetricsFilter(MetricsMeterRegistry registry) {
        this.registry = registry;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Timer.Sample sample = Timer.start();
        try {
            chain.doFilter(request, response);
        }
        catch (Throwable throwable) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String apiName = HttpTools.getRequestURI(httpRequest);
            String clientIp = HttpTools.getRemoteHost(httpRequest);
            int status = httpResponse.getStatus();
            Timer.Builder builder = Timer.builder((String)"apiStat").tag("apiName", apiName).tag("status", String.valueOf(status));
            if (!Strings.isNullOrEmpty((String)clientIp)) {
                builder.tag("clientIp", clientIp);
            }
            if (ConfigTools3.getBoolean((String)"metrics.trace.api.session.enabled", (boolean)false)) {
                Map<String, String> requestMap = HttpTools.getRequestMap(httpResponse);
                requestMap.forEach((k, v) -> {
                    if (!Strings.isNullOrEmpty((String)k) && !Strings.isNullOrEmpty((String)v)) {
                        builder.tag(k, v);
                    }
                });
            }
            if (ConfigTools3.getBoolean((String)"metrics.trace.api.sla.enable", (boolean)true)) {
                ArrayList<Double> slaPercentile;
                builder.maximumExpectedValue(Duration.ofSeconds(15L));
                builder.minimumExpectedValue(Duration.ofMillis(1L));
                ArrayList<Duration> slaLevel = this.getSLALevel();
                if (!slaLevel.isEmpty()) {
                    Duration[] durations = new Duration[slaLevel.size()];
                    builder.serviceLevelObjectives(slaLevel.toArray(durations));
                }
                if ((slaPercentile = this.getSLAPercentiles()).size() == 1) {
                    builder.publishPercentiles(new double[]{slaPercentile.get(0)});
                }
                if (slaPercentile.size() == 2) {
                    builder.publishPercentiles(new double[]{slaPercentile.get(0), slaPercentile.get(1)});
                }
                builder.publishPercentileHistogram(Boolean.valueOf(ConfigTools3.getBoolean((String)"metrics.trace.api.sla.publish.histogram", (boolean)false)));
            }
            long l = sample.stop(builder.register((MeterRegistry)this.registry));
            throw throwable;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String apiName = HttpTools.getRequestURI(httpRequest);
        String clientIp = HttpTools.getRemoteHost(httpRequest);
        int status = httpResponse.getStatus();
        Timer.Builder builder = Timer.builder((String)"apiStat").tag("apiName", apiName).tag("status", String.valueOf(status));
        if (!Strings.isNullOrEmpty((String)clientIp)) {
            builder.tag("clientIp", clientIp);
        }
        if (ConfigTools3.getBoolean((String)"metrics.trace.api.session.enabled", (boolean)false)) {
            Map<String, String> requestMap = HttpTools.getRequestMap(httpResponse);
            requestMap.forEach((k, v) -> {
                if (!Strings.isNullOrEmpty((String)k) && !Strings.isNullOrEmpty((String)v)) {
                    builder.tag(k, v);
                }
            });
        }
        if (ConfigTools3.getBoolean((String)"metrics.trace.api.sla.enable", (boolean)true)) {
            ArrayList<Double> slaPercentile;
            builder.maximumExpectedValue(Duration.ofSeconds(15L));
            builder.minimumExpectedValue(Duration.ofMillis(1L));
            ArrayList<Duration> slaLevel = this.getSLALevel();
            if (!slaLevel.isEmpty()) {
                Duration[] durations = new Duration[slaLevel.size()];
                builder.serviceLevelObjectives(slaLevel.toArray(durations));
            }
            if ((slaPercentile = this.getSLAPercentiles()).size() == 1) {
                builder.publishPercentiles(new double[]{slaPercentile.get(0)});
            }
            if (slaPercentile.size() == 2) {
                builder.publishPercentiles(new double[]{slaPercentile.get(0), slaPercentile.get(1)});
            }
            builder.publishPercentileHistogram(Boolean.valueOf(ConfigTools3.getBoolean((String)"metrics.trace.api.sla.publish.histogram", (boolean)false)));
        }
        long l = sample.stop(builder.register((MeterRegistry)this.registry));
    }

    public void destroy() {
    }

    public ArrayList<Duration> getSLALevel() {
        ArrayList slaDurations = Lists.newArrayList();
        List slas = ConfigTools3.getAsList((String)"metrics.trace.api.sla.threshold");
        if (slas.isEmpty()) {
            return slaDurations;
        }
        for (String sla : slas) {
            try {
                slaDurations.add(Duration.ofMillis(Long.valueOf(sla)));
            }
            catch (Exception exception) {}
        }
        return slaDurations;
    }

    public ArrayList<Double> getSLAPercentiles() {
        ArrayList slaPercentiles = Lists.newArrayList();
        List percentiles = ConfigTools3.getAsList((String)"metrics.trace.api.sla.percentiles");
        if (percentiles.isEmpty()) {
            return slaPercentiles;
        }
        for (String percentile : percentiles) {
            try {
                slaPercentiles.add(Double.valueOf(Double.valueOf(percentile)));
            }
            catch (Exception exception) {}
        }
        return slaPercentiles;
    }
}

