/*
 * Decompiled with CFR 0.152.
 */
package common.metrics.starter;

import common.metrics.micrometer.registry.IMetricsMeterRegistryConfig;
import common.metrics.micrometer.registry.MetricsMeterRegistry;
import common.metrics.micrometer.registry.MetricsMeterRegistryConfig;
import common.metrics.starter.filter.MetricsFilter;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MetricAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MetricAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={MetricsMeterRegistry.class})
    public MetricsMeterRegistry meterRegistry() {
        return new MetricsMeterRegistry((IMetricsMeterRegistryConfig)new MetricsMeterRegistryConfig());
    }

    @Bean
    @ConditionalOnWebApplication
    public FilterRegistrationBean<MetricsFilter> thirdFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new MetricsFilter(this.meterRegistry()));
        filterRegistrationBean.setUrlPatterns(new ArrayList<String>(Arrays.asList("/api/*")));
        filterRegistrationBean.setOrder(Integer.MIN_VALUE);
        logger.info("Add Filter name:[{}] order[{}]", (Object)"MetricsFilter", (Object)filterRegistrationBean.getOrder());
        return filterRegistrationBean;
    }
}

