package common.metrics.starter;

import common.metrics.micrometer.registry.MetricsMeterRegistry;
import common.metrics.micrometer.registry.MetricsMeterRegistryConfig;
import common.metrics.starter.filter.MetricsFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

import java.util.ArrayList;
import java.util.Arrays;

@Configuration
public class MetricAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MetricAutoConfiguration.class);
    @Bean
    @ConditionalOnMissingBean(MetricsMeterRegistry.class)
    public MetricsMeterRegistry meterRegistry() {
        return new MetricsMeterRegistry(new MetricsMeterRegistryConfig());
    }

    @Bean
    @ConditionalOnWebApplication
    public FilterRegistrationBean<MetricsFilter> metricsFilter() {
        FilterRegistrationBean<MetricsFilter> filterRegistrationBean = new FilterRegistrationBean<>();
        filterRegistrationBean.setFilter(new MetricsFilter(meterRegistry()));
        filterRegistrationBean.setUrlPatterns(new ArrayList<>(Arrays.asList("/api/*")));
        filterRegistrationBean.setOrder(Ordered.HIGHEST_PRECEDENCE);

        logger.info("Add Filter name:[{}] order[{}]","MetricsFilter",filterRegistrationBean.getOrder());
        return filterRegistrationBean;
    }

}
