/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.api.impl;

import com.valor.common.search.api.SearchApiConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;

public class DefaultSearchApiConfig {
    public static final SearchApiConfig initFromConfig(String configResource) throws IOException {
        try (InputStream stream = DefaultSearchApiConfig.getConfigStream(configResource);){
            SearchApiConfig searchApiConfig = DefaultSearchApiConfig.initFromConfig(stream);
            return searchApiConfig;
        }
    }

    public static final SearchApiConfig initFromConfig(InputStream stream) throws IOException {
        Properties props = new Properties();
        props.load(stream);
        return DefaultSearchApiConfig.initFromConfig(props);
    }

    private static InputStream getConfigStream(String resource) throws IOException {
        InputStream configStream = DefaultSearchApiConfig.class.getResourceAsStream(resource);
        if (configStream == null) {
            configStream = DefaultSearchApiConfig.class.getClassLoader().getParent().getResourceAsStream(resource);
        }
        if (configStream == null) {
            throw new IOException("Cannot find " + resource + " !!!");
        }
        return configStream;
    }

    private static SearchApiConfig initFromConfig(Properties props) {
        SearchApiConfig settings = new SearchApiConfig();
        settings.setHighLightPostTag(props.getProperty("search.engine.high-light.post-tag", "</em>"));
        settings.setHighLightPreTag(props.getProperty("search.engine.high-light.pre-tag", "<em>"));
        settings.setHost(props.getProperty("search.engine.host", ""));
        settings.setPort(Integer.parseInt(props.getProperty("search.engine.port", "9200")));
        settings.setUsername(props.getProperty("search.engine.username", ""));
        settings.setPassword(props.getProperty("search.engine.password", ""));
        settings.setIndexName(props.getProperty("search.engine.index.name", "search_engine_index"));
        settings.setMatchMainIndexFieldName(props.getProperty("search.engine.index.main-indic-field-name", "mainTitle"));
        settings.setClassifyFieldName(props.getProperty("search.engine.index.classify-field-name", "mark"));
        settings.setScoreExpress(props.getProperty("search.engine.index.score-express", "_score*(Math.pow((doc['weight'].value+100.0)/50,2))"));
        settings.setEnableTimeFilter(Boolean.parseBoolean(props.getProperty("search.engine.enable-time-filter", "false")));
        settings.setWeightFieldName(props.getProperty("search.engine.index.weight-field-name", "weight"));
        settings.setWeightThreshold(Float.parseFloat(props.getProperty("search.engine.weight-threshold", "4.000001")));
        settings.setCelebsWeightThreashold(Float.parseFloat(props.getProperty("search.engine.celebs-weight-threshold", "8.00001")));
        settings.setEnableTunningRankerNewSort(Boolean.parseBoolean(props.getProperty("search.api.enable-tunning-ranker-new-sort", "true")));
        settings.setVideoWeightThreshold(Float.parseFloat(props.getProperty("search.engine.video-weight-threshold", "18.00001")));
        settings.setTimeFilterFieldName(props.getProperty("search.engine.time-filter-field-name", null));
        settings.setDocumentIdentifyFieldName(props.getProperty("search.engine.index.document-identify-field-name", "docId"));
        settings.setOpenHighLight(Boolean.parseBoolean(props.getProperty("search.api.open-high-light", "true")));
        String highLightFieldsName = props.getProperty("search.engine.high-light-fields-name", "title,keywords");
        settings.setHighLightFieldsName(Arrays.asList(highLightFieldsName.split(",")));
        settings.setDocumentIdentifyFieldName(props.getProperty("search.engine.index.document-identify-field-name", "docId"));
        return settings;
    }
}

