/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.api;

import com.valor.common.search.api.SearchApiParams;
import com.valor.common.search.api.impl.DefaultSearchApi;
import com.valor.common.search.api.model.IndexOutData;
import com.valor.common.search.api.utils.SearchApiUtils;
import com.valor.common.search.engine.SearchApiResponse;
import com.valor.common.search.engine.facade.Condition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class SearchApi {
    public SearchApi() {
        DefaultSearchApi.init();
    }

    public SearchApi(String host, int port) {
        DefaultSearchApi.init(host, port);
    }

    public SearchApi(String host, int port, String username, String password) {
        DefaultSearchApi.init(host, port, username, password);
    }

    public SearchApi(String host, int port, String username, String password, String indexName) {
        DefaultSearchApi.init(host, port, username, password);
    }

    public SearchApiResponse<IndexOutData> matchSearch(int pageId, int pageSize, String keyword, List<String> marks, List<Condition> excludeConditions) {
        if (SearchApiUtils.isSearchByContentId(keyword)) {
            return DefaultSearchApi.matchSearchForContentId(keyword, marks, IndexOutData.class, null, excludeConditions);
        }
        return DefaultSearchApi.matchSearch(pageId, pageSize, keyword, marks, IndexOutData.class, null, excludeConditions);
    }

    public SearchApiResponse<IndexOutData> strictMatchSearch(int pageId, int pageSize, String keyword, List<String> marks, SearchApiParams searchApiParams, List<Condition> excludeConditions) {
        if (SearchApiUtils.isSearchByContentId(keyword)) {
            return DefaultSearchApi.matchSearchForContentId(keyword, marks, IndexOutData.class, searchApiParams, excludeConditions);
        }
        return DefaultSearchApi.strictMatchSearch(pageId, pageSize, keyword, marks, IndexOutData.class, searchApiParams, excludeConditions);
    }

    public SearchApiResponse<IndexOutData> matchSearch(int pageId, int pageSize, String keyword, List<String> marks, SearchApiParams searchApiParams, List<Condition> excludeConditions) {
        if (SearchApiUtils.isSearchByContentId(keyword)) {
            return DefaultSearchApi.matchSearchForContentId(keyword, marks, IndexOutData.class, searchApiParams, excludeConditions);
        }
        return DefaultSearchApi.matchSearch(pageId, pageSize, keyword, marks, IndexOutData.class, searchApiParams, excludeConditions);
    }

    public SearchApiResponse<IndexOutData> instantSearch(String keyword, int size, List<Condition> excludeConditions) {
        return DefaultSearchApi.instantSearch(keyword, size, IndexOutData.class, null, excludeConditions);
    }

    public SearchApiResponse<IndexOutData> instantSearch(String keyword, int size, SearchApiParams searchApiParams, List<Condition> excludeConditions) {
        return DefaultSearchApi.instantSearch(keyword, size, IndexOutData.class, searchApiParams, excludeConditions);
    }

    public SearchApiResponse<IndexOutData> strictInstantSearch(String keyword, int size, SearchApiParams searchApiParams, List<Condition> excludeConditions) {
        return DefaultSearchApi.strictInstantSearch(keyword, size, IndexOutData.class, searchApiParams, excludeConditions);
    }

    public Map<String, Long> matchCount(String keyword, List<Condition> excludeConditions) {
        return this.matchCount(keyword, null, excludeConditions);
    }

    public Map<String, Long> matchCount(String keyword, SearchApiParams searchApiParams, List<Condition> excludeConditions) {
        Map<String, Long> matchCountResponse = DefaultSearchApi.matchCount(keyword, searchApiParams, excludeConditions);
        if (SearchApiUtils.isSearchByContentId(keyword)) {
            String[] DEFAULT_MARKS;
            for (String mark : DEFAULT_MARKS = new String[]{"movies", "series", "celebs", "user", "video", "article"}) {
                ArrayList<String> tmpMarks = new ArrayList<String>();
                tmpMarks.add(mark);
                SearchApiResponse<IndexOutData> responseData = DefaultSearchApi.matchSearchForContentId(keyword, tmpMarks, IndexOutData.class, searchApiParams, excludeConditions);
                matchCountResponse.put(mark, responseData.getHitTotal());
            }
        }
        return matchCountResponse;
    }

    public Map<String, Long> strictMatchCount(String keyword, SearchApiParams searchApiParams, List<Condition> excludeConditions) {
        Map<String, Long> matchCountResponse = DefaultSearchApi.strictMatchCount(keyword, searchApiParams, excludeConditions);
        if (SearchApiUtils.isSearchByContentId(keyword)) {
            String[] DEFAULT_MARKS;
            for (String mark : DEFAULT_MARKS = new String[]{"movies", "series", "celebs", "user", "video", "article"}) {
                ArrayList<String> tmpMarks = new ArrayList<String>();
                tmpMarks.add(mark);
                SearchApiResponse<IndexOutData> responseData = DefaultSearchApi.matchSearchForContentId(keyword, tmpMarks, IndexOutData.class, searchApiParams, excludeConditions);
                matchCountResponse.put(mark, responseData.getHitTotal());
            }
        }
        return matchCountResponse;
    }
}

