/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.api.impl;

import com.alibaba.fastjson.JSONObject;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.Signer;
import com.valor.common.search.api.SearchApiConfig;
import com.valor.common.search.api.SearchApiParams;
import com.valor.common.search.api.impl.AWSRequestSigningApacheInterceptor;
import com.valor.common.search.api.impl.DefaultSearchApiConfig;
import com.valor.common.search.engine.SearchApiException;
import com.valor.common.search.engine.SearchApiResponse;
import com.valor.common.search.engine.facade.Condition;
import com.valor.common.search.engine.facade.PeliplatBizFacade;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSearchApi {
    public static final String DEFAULT_B_TYPE = "peliplat";
    private static final String CONFIG_FILE = "/search-api.properties";
    private static Logger logger = LoggerFactory.getLogger(DefaultSearchApi.class);
    private static RestHighLevelClient elasticSearchClient;
    private static SearchApiConfig defaultSearchApiConfig;

    public static void init() {
        DefaultSearchApi.initInternal(defaultSearchApiConfig);
    }

    public static void init(String host, int port) {
        DefaultSearchApi.init(host, port, null, null);
    }

    public static void init(String host, int port, String username, String password) {
        defaultSearchApiConfig.setHost(host);
        defaultSearchApiConfig.setPort(port);
        defaultSearchApiConfig.setUsername(username);
        defaultSearchApiConfig.setPassword(password);
        DefaultSearchApi.initInternal(defaultSearchApiConfig);
    }

    public static void init(String host, int port, String username, String password, String indexName) {
        defaultSearchApiConfig.setHost(host);
        defaultSearchApiConfig.setPort(port);
        defaultSearchApiConfig.setUsername(username);
        defaultSearchApiConfig.setPassword(password);
        defaultSearchApiConfig.setIndexName(indexName);
        DefaultSearchApi.initInternal(defaultSearchApiConfig);
    }

    private static void initInternal(SearchApiConfig searchApiConfig) {
        RestClientBuilder clientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(searchApiConfig.getHost(), searchApiConfig.getPort(), "http")});
        if (!StringUtils.isEmpty((Object)searchApiConfig.getUsername()) && !StringUtils.isEmpty((Object)searchApiConfig.getPassword())) {
            AWS4Signer signer = new AWS4Signer();
            signer.setServiceName("es");
            signer.setRegionName("us-east-2");
            BasicAWSCredentials awsCreds = new BasicAWSCredentials(searchApiConfig.getUsername(), searchApiConfig.getPassword());
            AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCreds);
            AWSRequestSigningApacheInterceptor interceptor = new AWSRequestSigningApacheInterceptor("es", (Signer)signer, (AWSCredentialsProvider)awsCredentialsProvider);
            clientBuilder.setHttpClientConfigCallback(f -> {
                f.addInterceptorLast(interceptor);
                f.setMaxConnTotal(1000);
                f.setKeepAliveStrategy((ConnectionKeepAliveStrategy)DefaultConnectionKeepAliveStrategy.INSTANCE);
                return f;
            });
        } else {
            clientBuilder.setHttpClientConfigCallback(f -> {
                f.setMaxConnTotal(1000);
                f.setKeepAliveStrategy((ConnectionKeepAliveStrategy)DefaultConnectionKeepAliveStrategy.INSTANCE);
                return f;
            });
        }
        clientBuilder.setRequestConfigCallback(f -> {
            f.setSocketTimeout(60000);
            f.setContentCompressionEnabled(true);
            return f;
        });
        elasticSearchClient = new RestHighLevelClient(clientBuilder);
    }

    public static <T> SearchApiResponse<T> matchSearch(int pageId, int pageSize, String keyword, List<String> marks, Class<T> indexDataClazz, SearchApiParams searchApiParams, List<Condition> excludeConditions) throws SearchApiException {
        if (StringUtils.isEmpty((Object)keyword)) {
            return new SearchApiResponse();
        }
        if (CollectionUtils.isEmpty(marks)) {
            marks = new ArrayList<String>();
        }
        SearchApiConfig searchApiConfig = DefaultSearchApi.prepareSearchApiConfig(searchApiParams);
        Map bizSysConfig = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)searchApiConfig), Map.class);
        PeliplatBizFacade peliplatAppFacade = new PeliplatBizFacade(elasticSearchClient);
        SearchApiResponse bizResponse = null;
        try {
            bizResponse = peliplatAppFacade.matchSearch(pageId, pageSize, keyword, marks, indexDataClazz, bizSysConfig, excludeConditions);
        }
        catch (Exception e) {
            logger.error("Invoke matchSearch failed: keyword:" + keyword + " marks:" + Arrays.toString(marks.toArray()) + " pageId:" + pageId + " pageSize:" + pageSize);
            throw new SearchApiException(e);
        }
        return bizResponse;
    }

    public static <T> SearchApiResponse<T> strictMatchSearch(int pageId, int pageSize, String keyword, List<String> marks, Class<T> indexDataClazz, SearchApiParams searchApiParams, List<Condition> excludeConditions) throws SearchApiException {
        if (StringUtils.isEmpty((Object)keyword)) {
            return new SearchApiResponse();
        }
        if (CollectionUtils.isEmpty(marks)) {
            marks = new ArrayList<String>();
        }
        SearchApiConfig searchApiConfig = DefaultSearchApi.prepareSearchApiConfig(searchApiParams);
        Map bizSysConfig = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)searchApiConfig), Map.class);
        PeliplatBizFacade peliplatAppFacade = new PeliplatBizFacade(elasticSearchClient);
        SearchApiResponse bizResponse = peliplatAppFacade.strictMatchSearch(pageId, pageSize, keyword, marks, indexDataClazz, bizSysConfig, excludeConditions);
        return bizResponse;
    }

    public static <T> SearchApiResponse<T> matchSearchForContentId(String keyword, List<String> marks, Class<T> indexDataClazz, SearchApiParams searchApiParams, List<Condition> excludeConditions) throws SearchApiException {
        if (StringUtils.isEmpty((Object)keyword)) {
            return new SearchApiResponse();
        }
        SearchApiConfig searchApiConfig = DefaultSearchApi.prepareSearchApiConfig(searchApiParams);
        Map bizSysConfig = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)searchApiConfig), Map.class);
        PeliplatBizFacade peliplatAppFacade = new PeliplatBizFacade(elasticSearchClient);
        SearchApiResponse bizResponse = peliplatAppFacade.matchSearchForContentId(keyword, marks, indexDataClazz, bizSysConfig, excludeConditions);
        return bizResponse;
    }

    public static <T> SearchApiResponse<T> instantSearch(String keyword, int size, Class<T> indexDataClazz, SearchApiParams searchApiParams, List<Condition> excludeConditions) throws SearchApiException {
        if (StringUtils.isEmpty((Object)keyword)) {
            return new SearchApiResponse();
        }
        SearchApiConfig searchApiConfig = DefaultSearchApi.prepareSearchApiConfig(searchApiParams);
        Map bizSysConfig = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)searchApiConfig), Map.class);
        PeliplatBizFacade peliplatAppFacade = new PeliplatBizFacade(elasticSearchClient);
        SearchApiResponse bizResponse = peliplatAppFacade.instanceSearch(size, keyword, null, indexDataClazz, bizSysConfig, excludeConditions);
        return bizResponse;
    }

    public static <T> SearchApiResponse<T> strictInstantSearch(String keyword, int size, Class<T> indexDataClazz, SearchApiParams searchApiParams, List<Condition> excludeConditions) throws SearchApiException {
        if (StringUtils.isEmpty((Object)keyword)) {
            return new SearchApiResponse();
        }
        SearchApiConfig searchApiConfig = DefaultSearchApi.prepareSearchApiConfig(searchApiParams);
        Map bizSysConfig = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)searchApiConfig), Map.class);
        PeliplatBizFacade peliplatAppFacade = new PeliplatBizFacade(elasticSearchClient);
        SearchApiResponse bizResponse = peliplatAppFacade.strictInstanceSearch(size, keyword, null, indexDataClazz, bizSysConfig, excludeConditions);
        return bizResponse;
    }

    public static Map<String, Long> matchCount(String keyword, SearchApiParams searchApiParams, List<Condition> excludeConditions) throws SearchApiException {
        if (StringUtils.isEmpty((Object)keyword)) {
            return new HashMap<String, Long>();
        }
        SearchApiConfig searchApiConfig = DefaultSearchApi.prepareSearchApiConfig(searchApiParams);
        Map appSysConfig = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)searchApiConfig), Map.class);
        PeliplatBizFacade peliplatAppFacade = new PeliplatBizFacade(elasticSearchClient);
        try {
            return peliplatAppFacade.matchCount(keyword, appSysConfig, excludeConditions);
        }
        catch (Exception e) {
            throw new SearchApiException(e);
        }
    }

    private static SearchApiConfig prepareSearchApiConfig(SearchApiParams searchApiParams) {
        SearchApiConfig searchApiConfig = null;
        try {
            searchApiConfig = (SearchApiConfig)defaultSearchApiConfig.clone();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (searchApiParams == null) {
            return searchApiConfig;
        }
        if (searchApiParams.getOpenHiddenContent() != null) {
            searchApiConfig.setOpenHiddenContent(searchApiParams.getOpenHiddenContent());
        }
        if (searchApiParams.getOpenHighlight() != null) {
            searchApiConfig.setOpenHighlight(searchApiParams.getOpenHighlight());
        }
        if (!StringUtils.isEmpty((Object)searchApiParams.getHighlightPostTag())) {
            searchApiConfig.setHighlightPostTag(searchApiParams.getHighlightPostTag());
        }
        if (!StringUtils.isEmpty((Object)searchApiParams.getHighlightPreTag())) {
            searchApiConfig.setHighlightPreTag(searchApiParams.getHighlightPreTag());
        }
        if (!StringUtils.isEmpty((Object)searchApiParams.getIndexName())) {
            searchApiConfig.setIndexName(searchApiParams.getIndexName());
        }
        if (!CollectionUtils.isEmpty(searchApiParams.getBizParams())) {
            searchApiConfig.setBizParams(new HashMap<String, Number>(searchApiParams.getBizParams()));
        }
        searchApiConfig.setMatcherFuzzyTermLetterLimit(searchApiParams.getFuzzyTermLetterLimit());
        searchApiConfig.setMatcherSentenceLetterLimit(searchApiParams.getSentenceLetterLimit());
        return searchApiConfig;
    }

    public static Map<String, Long> strictMatchCount(String keyword, SearchApiParams searchApiParams, List<Condition> excludeConditions) throws SearchApiException {
        if (StringUtils.isEmpty((Object)keyword)) {
            return new HashMap<String, Long>();
        }
        SearchApiConfig searchApiConfig = DefaultSearchApi.prepareSearchApiConfig(searchApiParams);
        Map appSysConfig = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)searchApiConfig), Map.class);
        PeliplatBizFacade peliplatAppFacade = new PeliplatBizFacade(elasticSearchClient);
        try {
            return peliplatAppFacade.strictMatchCount(keyword, appSysConfig, excludeConditions);
        }
        catch (Exception e) {
            throw new SearchApiException(e);
        }
    }

    static {
        try {
            defaultSearchApiConfig = DefaultSearchApiConfig.initFromConfig(CONFIG_FILE);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load search-api configuration /search-api.properties", e);
        }
    }
}

