/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.api.ranker;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.ranker.AbstractPostScoreRanker;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.SearchUtils;
import com.valor.common.search.engine.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunningAllMatchRanker
extends AbstractPostScoreRanker {
    public static final String DEFAULT_THRESHOLD_TYPE_NAME = "default";
    public static final String KEY_ENABLE_TUNNING_RANKER_NEW_SORT = "enable-tunning-ranker-new-sort";
    private static Logger logger = LoggerFactory.getLogger(TunningAllMatchRanker.class);
    private RequestContext context;
    private String searchName;
    private List<String> sortFieldNames = new ArrayList<String>();
    private String thresholdFieldName = "weight";
    private Map<String, Float> thresholdTypeValueMap = new HashMap<String, Float>();
    private String thresholdTypeFieldName = "mark";

    public TunningAllMatchRanker(RequestContext context, String searchName, String sortFieldNames) {
        this.context = context;
        this.searchName = searchName;
        this.sortFieldNames.add(sortFieldNames);
    }

    public TunningAllMatchRanker(RequestContext context) {
        this.context = context;
        this.searchName = "EntiretyMatcher";
        this.sortFieldNames.add(context.getAttribure("normal_full_text_field"));
    }

    public TunningAllMatchRanker(RequestContext context, String ... sortFieldNames) {
        this.context = context;
        this.searchName = "EntiretyMatcher";
        this.sortFieldNames.addAll(Arrays.asList(sortFieldNames));
    }

    public String getThresholdTypeFieldName() {
        return this.thresholdTypeFieldName;
    }

    public Map<String, Float> getThresholdTypeValueMap() {
        return this.thresholdTypeValueMap;
    }

    public TunningAllMatchRanker appendThresholdTypeValueMap(String thresholdTypeName, float thresholdTypeValue) {
        this.thresholdTypeValueMap.put(thresholdTypeName, Float.valueOf(thresholdTypeValue));
        return this;
    }

    public TunningAllMatchRanker thresholdTypeFieldName(String thresholdTypeFieldName) {
        this.thresholdTypeFieldName = thresholdTypeFieldName;
        return this;
    }

    public void execute() throws RuntimeException {
        SearchResponse response = this.context.getResponse();
        SearchHits hits = response.getHits();
        SearchHit[] hitDocs = hits.getHits();
        ArrayList<SearchHit> otherMatchHitList = new ArrayList<SearchHit>();
        ArrayList<Object> finalHits = new ArrayList<Object>();
        ArrayList finalHitsSameWordsAndPos = new ArrayList();
        ArrayList finalHitsSameWordOnly = new ArrayList();
        ArrayList<SearchHit> willSortingDataList = new ArrayList<SearchHit>();
        String q = this.context.getQ().toLowerCase();
        SearchHit topHit = null;
        for (SearchHit hit : hitDocs) {
            if (this.hasAllMatchQuery(hit.getMatchedQueries())) {
                willSortingDataList.add(hit);
                continue;
            }
            otherMatchHitList.add(hit);
        }
        ArrayList<SearchHit> notSortDataList = new ArrayList<SearchHit>();
        for (String sortingFieldName : this.sortFieldNames) {
            ArrayList<SearchHit> hasSameWordAndPosList = new ArrayList<SearchHit>();
            ArrayList<SearchHit> hasSameWordList = new ArrayList<SearchHit>();
            ArrayList<SearchHit> extraAllMatchHitList = new ArrayList<SearchHit>();
            for (SearchHit hit : willSortingDataList) {
                Object obj = hit.getSourceAsMap().get(sortingFieldName);
                if (obj == null) continue;
                ArrayList<String> titleList = null;
                if (obj instanceof String) {
                    titleList = new ArrayList<String>();
                    titleList.add(obj.toString());
                } else {
                    titleList = (ArrayList<String>)obj;
                }
                boolean isExtraAllMatch = false;
                boolean isHasSameWordandPos = false;
                String extraAliasQ = this.context.getAttribure("execute_extraword_alis_query");
                if (!StringUtils.isEmpty((Object)extraAliasQ)) {
                    extraAliasQ = extraAliasQ.toLowerCase(Locale.ROOT).trim();
                }
                for (String s : titleList) {
                    if ((s = s.toLowerCase().trim()).equals(q)) {
                        isExtraAllMatch = true;
                        continue;
                    }
                    if (isExtraAllMatch || s.indexOf(q) < 0 && (StringUtils.isEmpty((Object)extraAliasQ) || s.indexOf(extraAliasQ) < 0)) continue;
                    isHasSameWordandPos = true;
                }
                if (isExtraAllMatch) {
                    if (this.canApplyThreshold(hit)) {
                        extraAllMatchHitList.add(hit);
                        continue;
                    }
                    notSortDataList.add(hit);
                    continue;
                }
                if (isHasSameWordandPos) {
                    if (!this.canApplyThreshold(hit)) {
                        notSortDataList.add(hit);
                        continue;
                    }
                    hasSameWordAndPosList.add(hit);
                    continue;
                }
                if (this.canApplyThreshold(hit)) {
                    hasSameWordList.add(hit);
                    continue;
                }
                notSortDataList.add(hit);
            }
            ArrayList<SearchHit> cutoffList = new ArrayList<SearchHit>();
            ArrayList<SearchHit> sameWordSortedList = new ArrayList<SearchHit>();
            sameWordSortedList.addAll(extraAllMatchHitList);
            sameWordSortedList.addAll(hasSameWordAndPosList);
            sameWordSortedList.sort(new ScoreDescComparator());
            this.filterHitsforSortByWeight(sameWordSortedList, cutoffList);
            for (SearchHit hit : cutoffList) {
                hit.getSourceAsMap().put("weight", Float.valueOf(Float.parseFloat(hit.getSourceAsMap().get("weight").toString()) * 2.0f));
            }
            notSortDataList.addAll(cutoffList);
            if (topHit == null) {
                topHit = !CollectionUtils.isEmpty(extraAllMatchHitList) && !((SearchHit)extraAllMatchHitList.get(0)).equals(sameWordSortedList.get(0)) ? (SearchHit)extraAllMatchHitList.get(0) : this.getTopHitDoc(willSortingDataList, q, sortingFieldName);
            }
            willSortingDataList.clear();
            willSortingDataList.addAll(notSortDataList);
            notSortDataList.clear();
            if (this.context.getAttribure(KEY_ENABLE_TUNNING_RANKER_NEW_SORT).equalsIgnoreCase("true")) {
                if (this.context.getMarks().size() == 1 && (((String)this.context.getMarks().get(0)).equalsIgnoreCase("movies") || ((String)this.context.getMarks().get(0)).equalsIgnoreCase("series"))) {
                    sameWordSortedList.sort(new MovieSeriesNewComparator());
                    hasSameWordList.sort(new MovieSeriesNewComparator());
                } else if (this.context.getMarks().size() == 1 && ((String)this.context.getMarks().get(0)).equalsIgnoreCase("celebs")) {
                    sameWordSortedList.sort(new CelebsNewComparator());
                    hasSameWordList.sort(new CelebsNewComparator());
                } else {
                    sameWordSortedList.sort(new WeightScoreDescComparator());
                    hasSameWordList.sort(new WeightScoreDescComparator());
                }
            } else {
                sameWordSortedList.sort(new WeightScoreDescComparator());
                hasSameWordList.sort(new WeightScoreDescComparator());
            }
            finalHits.addAll(sameWordSortedList);
            finalHits.addAll(hasSameWordList);
        }
        otherMatchHitList.addAll(willSortingDataList);
        otherMatchHitList.sort(new ScoreDescComparator());
        if (logger.isDebugEnabled()) {
            for (Object obj : finalHits.toArray()) {
                SearchHit hit = (SearchHit)obj;
                System.out.println("publicationYear," + hit.getSourceAsMap().get("publicationYear") + ",weight," + hit.getSourceAsMap().get("weight") + ",popularity," + hit.getSourceAsMap().get("popularity") + ",new score," + hit.getSourceAsMap().get("newScore") + ",hot," + hit.getSourceAsMap().get("hot"));
            }
        }
        finalHits.addAll(otherMatchHitList);
        if (this.context.getAttribure(KEY_ENABLE_TUNNING_RANKER_NEW_SORT).equalsIgnoreCase("false") && topHit != null) {
            finalHits.remove(topHit);
            finalHits.add(0, topHit);
        }
        try {
            SearchUtils.replaceHits((SearchHits)hits, (Object[])finalHits.toArray());
        }
        catch (Exception e) {
            logger.error("Error while repalce hits into response. Exception:", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void filterHitsforSortByWeight(List<SearchHit> sourceList, List<SearchHit> cutoffList) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return;
        }
        SearchHit topScoreHit = sourceList.get(0);
        ArrayList<SearchHit> weightSortList = new ArrayList<SearchHit>();
        for (SearchHit hit : sourceList) {
            if ((double)hit.getScore() > (double)topScoreHit.getScore() * 0.1) {
                weightSortList.add(hit);
                continue;
            }
            cutoffList.add(hit);
        }
        sourceList.clear();
        sourceList.addAll(weightSortList);
    }

    private boolean canApplyThreshold(SearchHit hit) {
        String thresholdType = hit.getSourceAsMap().get(this.thresholdTypeFieldName).toString();
        if (StringUtils.isEmpty((Object)thresholdType) || this.thresholdTypeValueMap.get(thresholdType) == null && this.thresholdTypeValueMap.get(DEFAULT_THRESHOLD_TYPE_NAME) == null || StringUtils.isEmpty((Object)this.thresholdFieldName)) {
            return true;
        }
        float f = Float.parseFloat(hit.getSourceAsMap().get(this.thresholdFieldName).toString());
        return !(this.thresholdTypeValueMap.get(thresholdType) != null && f < this.thresholdTypeValueMap.get(thresholdType).floatValue()) && (this.thresholdTypeValueMap.get(DEFAULT_THRESHOLD_TYPE_NAME) == null || !(f < this.thresholdTypeValueMap.get(DEFAULT_THRESHOLD_TYPE_NAME).floatValue()));
    }

    private float getCurrentScore(SearchHit hit) {
        return 1.0f;
    }

    private SearchHit getTopHitDoc(List<SearchHit> soureHitsList, String qStr, String sourceFieldName) {
        boolean isExtraAllMatch = false;
        float maxScore = -10.0f;
        SearchHit topHit = null;
        block0: for (SearchHit hit : soureHitsList) {
            Object obj = hit.getSourceAsMap().get(sourceFieldName);
            if (obj == null) continue;
            ArrayList<String> titleList = null;
            if (obj instanceof String) {
                titleList = new ArrayList<String>();
                titleList.add(obj.toString());
            } else {
                titleList = (ArrayList<String>)obj;
            }
            for (String s : titleList) {
                if (!(s = s.toLowerCase()).trim().equals(qStr)) continue;
                if (maxScore < hit.getScore()) {
                    topHit = hit;
                    maxScore = hit.getScore();
                }
                if (this.canApplyThreshold(hit)) continue block0;
                topHit = null;
            }
        }
        return topHit;
    }

    public List<String> sortFieldNames() {
        return this.sortFieldNames;
    }

    private boolean hasAllMatchQuery(String[] matchQueries) {
        boolean retVal = false;
        for (String str : matchQueries) {
            if (str.indexOf(this.searchName) == -1) continue;
            return true;
        }
        return retVal;
    }

    private static class WeightScoreDescComparator
    implements Comparator<SearchHit> {
        private WeightScoreDescComparator() {
        }

        @Override
        public int compare(SearchHit o1, SearchHit o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1 == o2) {
                return 0;
            }
            float o1Weight = Float.parseFloat(o1.getSourceAsMap().get("weight").toString());
            float o2Weight = Float.parseFloat(o2.getSourceAsMap().get("weight").toString());
            double _score1 = (double)(o1.getScore() * 75.0f) / (100.0 + (double)o1Weight * 1.5);
            double _score2 = (double)(o2.getScore() * 75.0f) / (100.0 + (double)o2Weight * 1.5);
            double newScore1 = _score1 * (double)o1Weight;
            double newScore2 = _score2 * (double)o2Weight;
            if (o1Weight > o2Weight) {
                return -1;
            }
            if (o1Weight == o2Weight) {
                if (newScore1 > newScore2) {
                    return -1;
                }
                if (newScore1 < newScore2) {
                    return 1;
                }
                return 0;
            }
            return 1;
        }
    }

    private static class ScoreDescComparator
    implements Comparator<SearchHit> {
        private ScoreDescComparator() {
        }

        @Override
        public int compare(SearchHit o1, SearchHit o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1 == o2) {
                return 0;
            }
            if (o1.getScore() == o2.getScore()) {
                float o2Weight;
                float o1Weight = Float.parseFloat(o1.getSourceAsMap().get("weight").toString());
                if (o1Weight > (o2Weight = Float.parseFloat(o2.getSourceAsMap().get("weight").toString()))) {
                    return -1;
                }
                if (o1Weight < o2Weight) {
                    return 1;
                }
                return 0;
            }
            if (o1.getScore() > o2.getScore()) {
                return -1;
            }
            return 1;
        }
    }

    private static class CelebsNewComparator
    implements Comparator<SearchHit> {
        private CelebsNewComparator() {
        }

        @Override
        public int compare(SearchHit o1, SearchHit o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1 == o2) {
                return 0;
            }
            if (o1.getSourceAsMap().get("hot") == null && o2.getSourceAsMap().get("hot") == null) {
                return 0;
            }
            if (o1.getSourceAsMap().get("hot") == null) {
                return -1;
            }
            if (o2.getSourceAsMap().get("hot") == null) {
                return 1;
            }
            double item1Hot = Double.parseDouble(o1.getSourceAsMap().get("hot").toString());
            item1Hot = item1Hot <= 0.0 ? 0.0 : item1Hot;
            double item1weight = Double.parseDouble(o1.getSourceAsMap().get("weight").toString());
            double item1newScore = item1Hot / 2000.0 * 0.7 + item1weight / 3.0 * 0.3;
            double item2Hot = Double.parseDouble(o2.getSourceAsMap().get("hot").toString());
            item2Hot = item2Hot <= 0.0 ? 0.0 : item2Hot;
            double item2weight = Double.parseDouble(o2.getSourceAsMap().get("weight").toString());
            double item2newScore = item2Hot / 2000.0 * 0.7 + item2weight / 3.0 * 0.3;
            o1.getSourceAsMap().put("newScore", item1newScore);
            o2.getSourceAsMap().put("newScore", item2newScore);
            if (item1Hot > 0.0 && item2Hot <= 0.0) {
                return -1;
            }
            if (item2Hot > 0.0 && item1Hot <= 0.0) {
                return 1;
            }
            if (item1newScore == item2newScore) {
                return 0;
            }
            if (item1newScore > item2newScore) {
                return -1;
            }
            return 1;
        }
    }

    private static class MovieSeriesNewComparator
    implements Comparator<SearchHit> {
        private MovieSeriesNewComparator() {
        }

        @Override
        public int compare(SearchHit o1, SearchHit o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1 == o2) {
                return 0;
            }
            if (o1.getSourceAsMap().get("publicationYear") == null && o2.getSourceAsMap().get("publicationYear") == null) {
                return 0;
            }
            if (o1.getSourceAsMap().get("publicationYear") == null) {
                return -1;
            }
            if (o2.getSourceAsMap().get("publicationYear") == null) {
                return 1;
            }
            int item1year = Integer.parseInt(o1.getSourceAsMap().get("publicationYear").toString());
            double item1popularity = Double.parseDouble(o1.getSourceAsMap().get("popularity").toString());
            double item1weight = Double.parseDouble(o1.getSourceAsMap().get("weight").toString());
            double item1newScore = (double)(item1year - 1900) / 10.0 * 0.4 + item1popularity / 100000.0 * 0.3 + item1weight / 12.0 * 0.3;
            int item2year = Integer.parseInt(o2.getSourceAsMap().get("publicationYear").toString());
            double item2popularity = Double.parseDouble(o2.getSourceAsMap().get("popularity").toString());
            double item2weight = Double.parseDouble(o2.getSourceAsMap().get("weight").toString());
            double item2newScore = (double)(item2year - 1900) / 10.0 * 0.4 + item2popularity / 100000.0 * 0.3 + item2weight / 12.0 * 0.3;
            o1.getSourceAsMap().put("newScore", item1newScore);
            o2.getSourceAsMap().put("newScore", item2newScore);
            if (item1newScore == item2newScore) {
                return 0;
            }
            if (item1newScore > item2newScore) {
                return -1;
            }
            return 1;
        }
    }
}

