/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.api;

import com.valor.common.search.api.SearchApiParams;
import com.valor.common.search.api.impl.DefaultSearchApi;
import com.valor.common.search.api.model.IndexOutData;
import com.valor.common.search.api.utils.SearchApiUtils;
import com.valor.common.search.engine.SearchApiResponse;
import com.valor.common.search.engine.SearchEngineConfig;
import com.valor.common.search.engine.facade.Condition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SearchApi {
    public SearchEngineConfig getDefaultConfig() {
        return DefaultSearchApi.getDefaultConfig();
    }

    public SearchApi(String host, int port, String username, String password) {
        DefaultSearchApi.init(host, port, username, password);
    }

    public SearchApiResponse<IndexOutData> instantSearch(String keyword, int size, List<Condition> excludeConditions) {
        return this.instantSearch(keyword, size, null, excludeConditions);
    }

    public SearchApiResponse<IndexOutData> instantSearch(String keyword, int size, SearchApiParams extraParams, List<Condition> excludeConditions) {
        return DefaultSearchApi.instantSearch(keyword, size, IndexOutData.class, extraParams, excludeConditions);
    }

    public SearchApiResponse<IndexOutData> matchSearch(int pageId, int pageSize, String keyword, List<String> marks, List<Condition> excludeConditions) {
        return this.matchSearch(pageId, pageSize, keyword, marks, null, excludeConditions);
    }

    public SearchApiResponse<IndexOutData> matchSearch(int pageId, int pageSize, String keyword, List<String> marks, SearchApiParams extraParams, List<Condition> excludeConditions) {
        if (SearchApiUtils.isSearchByContentId(keyword)) {
            return DefaultSearchApi.matchSearchForContentId(keyword, marks, IndexOutData.class, extraParams, excludeConditions);
        }
        return DefaultSearchApi.matchSearch(pageId, pageSize, keyword, marks, IndexOutData.class, extraParams, excludeConditions);
    }

    public Map<String, Long> matchCount(String keyword, List<Condition> excludeConditions) {
        return this.matchCount(keyword, null, excludeConditions);
    }

    public Map<String, Long> matchCount(String keyword, SearchApiParams extraParams, List<Condition> excludeConditions) {
        if (SearchApiUtils.isSearchByContentId(keyword)) {
            String[] DEFAULT_MARKS;
            HashMap<String, Long> matchCountResponse = new HashMap<String, Long>();
            for (String mark : DEFAULT_MARKS = new String[]{"movies", "series", "celebs", "user", "video", "article"}) {
                ArrayList<String> tmpMarks = new ArrayList<String>();
                tmpMarks.add(mark);
                SearchApiResponse<IndexOutData> responseData = DefaultSearchApi.matchSearchForContentId(keyword, tmpMarks, IndexOutData.class, extraParams, excludeConditions);
                matchCountResponse.put(mark, responseData.getHitTotal());
            }
            return matchCountResponse;
        }
        return DefaultSearchApi.matchCount(keyword, extraParams, excludeConditions);
    }

    public SearchApiResponse<IndexOutData> strictInstantSearch(String keyword, int size, SearchApiParams extraParams, List<Condition> excludeConditions) {
        return DefaultSearchApi.strictInstantSearch(keyword, size, IndexOutData.class, extraParams, excludeConditions);
    }

    public SearchApiResponse<IndexOutData> strictMatchSearch(int pageId, int pageSize, String keyword, List<String> marks, SearchApiParams extraParams, List<Condition> excludeConditions) {
        if (SearchApiUtils.isSearchByContentId(keyword)) {
            return DefaultSearchApi.matchSearchForContentId(keyword, marks, IndexOutData.class, extraParams, excludeConditions);
        }
        return DefaultSearchApi.strictMatchSearch(pageId, pageSize, keyword, marks, IndexOutData.class, extraParams, excludeConditions);
    }

    public Map<String, Long> strictMatchCount(String keyword, SearchApiParams extraParams, List<Condition> excludeConditions) {
        if (SearchApiUtils.isSearchByContentId(keyword)) {
            String[] DEFAULT_MARKS;
            HashMap<String, Long> matchCountResponse = new HashMap<String, Long>();
            for (String mark : DEFAULT_MARKS = new String[]{"movies", "series", "celebs", "user", "video", "article"}) {
                ArrayList<String> tmpMarks = new ArrayList<String>();
                tmpMarks.add(mark);
                SearchApiResponse<IndexOutData> responseData = DefaultSearchApi.matchSearchForContentId(keyword, tmpMarks, IndexOutData.class, extraParams, excludeConditions);
                matchCountResponse.put(mark, responseData.getHitTotal());
            }
            return matchCountResponse;
        }
        return DefaultSearchApi.strictMatchCount(keyword, extraParams, excludeConditions);
    }
}

