/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.api.impl;

import com.valor.common.search.engine.SearchApiResponse;
import com.valor.common.search.engine.SearchEngineConfig;
import com.valor.common.search.engine.facade.Condition;
import com.valor.common.search.engine.facade.PeliplatBizFacade;
import com.valor.common.search.engine.util.SearchUtils;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;

public class PeliplatReorderUGCAll {
    private static ExecutorService allSearchExecPool = null;
    private final PeliplatBizFacade peliplatBizFacade;

    public PeliplatReorderUGCAll(PeliplatBizFacade peliplatBizFacade) {
        this.peliplatBizFacade = peliplatBizFacade;
    }

    public <T> SearchApiResponse<T> matchSearchForUGCALL(int pageId, int pageSize, String keyword, List<String> marks, Class<T> indexDataClazz, SearchEngineConfig config, List<Condition> excludeConditions) throws ExecutionException, InterruptedException, NoSuchFieldException {
        SearchWork<T> metaSearchWork = new SearchWork<T>(1, 100, keyword, "meta", indexDataClazz, config, excludeConditions);
        SearchWork<T> articleSearchWork = new SearchWork<T>(1, 30, keyword, "article", indexDataClazz, config, excludeConditions);
        SearchWork<T> videoSearchWork = new SearchWork<T>(1, 30, keyword, "video", indexDataClazz, config, excludeConditions);
        SearchWork<T> userSearchWork = new SearchWork<T>(1, 30, keyword, "user", indexDataClazz, config, excludeConditions);
        Future<T> meaSearchWorkFuture = allSearchExecPool.submit(metaSearchWork);
        Future<T> articleSearchWorkFuture = allSearchExecPool.submit(articleSearchWork);
        Future<T> videoSearchWorkFuture = allSearchExecPool.submit(videoSearchWork);
        Future<T> userSearchWorkFuture = allSearchExecPool.submit(userSearchWork);
        SearchApiResponse metaResult = (SearchApiResponse)meaSearchWorkFuture.get();
        SearchApiResponse articleResult = (SearchApiResponse)articleSearchWorkFuture.get();
        SearchApiResponse videoResult = (SearchApiResponse)videoSearchWorkFuture.get();
        SearchApiResponse userResult = (SearchApiResponse)userSearchWorkFuture.get();
        List<WrapResponseItem<T>> metaList = this.wrap(metaResult);
        List<WrapResponseItem<T>> ugcList = this.reSortList(articleResult, videoResult, userResult);
        List<WrapResponseItem<T>> articleList = this.reSortList(articleResult);
        ArrayList finalList = new ArrayList();
        ArrayList<WrapResponseItem<T>> top3ArticleList = new ArrayList<WrapResponseItem<T>>();
        ArrayList<WrapResponseItem<T>> top7MetaList = new ArrayList<WrapResponseItem<T>>();
        ArrayList<WrapResponseItem<T>> top5UgcList = new ArrayList<WrapResponseItem<T>>();
        ArrayList<WrapResponseItem<T>> tailList = new ArrayList<WrapResponseItem<T>>();
        for (int pageIndex = 0; pageIndex < pageId; ++pageIndex) {
            int i;
            int i2;
            top3ArticleList = new ArrayList();
            for (i2 = 0; i2 < 3 && i2 < articleList.size(); ++i2) {
                top3ArticleList.add(articleList.get(i2));
            }
            articleList.removeAll(top3ArticleList);
            ugcList.removeAll(top3ArticleList);
            top7MetaList = new ArrayList();
            for (i2 = 0; i2 < 7 && i2 < metaList.size(); ++i2) {
                top7MetaList.add(metaList.get(i2));
            }
            metaList.removeAll(top7MetaList);
            top5UgcList = new ArrayList();
            for (i2 = 0; i2 < 5 && i2 < ugcList.size(); ++i2) {
                top5UgcList.add(ugcList.get(i2));
            }
            ugcList.removeAll(top5UgcList);
            articleList.removeAll(top5UgcList);
            tailList = new ArrayList();
            for (i2 = 0; i2 < 5 && i2 < metaList.size(); ++i2) {
                tailList.add(metaList.get(i2));
            }
            metaList.removeAll(tailList);
            int tailSize = pageSize - top7MetaList.size() - top3ArticleList.size() - top5UgcList.size() - tailList.size();
            for (i = 0; i < tailSize && i < metaList.size(); ++i) {
                tailList.add(metaList.get(i));
            }
            metaList.removeAll(tailList);
            tailSize = pageSize - top7MetaList.size() - top3ArticleList.size() - top5UgcList.size() - tailList.size();
            for (i = 0; i < tailSize && i < ugcList.size(); ++i) {
                tailList.add(ugcList.get(i));
            }
            articleList.removeAll(tailList);
            ugcList.removeAll(tailList);
        }
        finalList.addAll(top7MetaList);
        finalList.addAll(top3ArticleList);
        finalList.addAll(top5UgcList);
        finalList.addAll(tailList);
        SearchApiResponse searchApiResponse = new SearchApiResponse();
        searchApiResponse.setHitCount((long)finalList.size());
        LinkedHashSet finalSourceSet = new LinkedHashSet();
        for (WrapResponseItem item : finalList) {
            finalSourceSet.add(item.getObj());
        }
        searchApiResponse.setSource(finalSourceSet);
        searchApiResponse.setHitTotal(metaResult.getHitTotal() + articleResult.getHitTotal() + videoResult.getHitTotal() + userResult.getHitTotal());
        long tookTime = 0L;
        tookTime = Math.max(metaResult.getTookTime(), tookTime);
        tookTime = articleResult.getTookTime() > tookTime ? metaResult.getTookTime() : tookTime;
        tookTime = videoResult.getTookTime() > tookTime ? metaResult.getTookTime() : tookTime;
        tookTime = userResult.getTookTime() > tookTime ? metaResult.getTookTime() : tookTime;
        searchApiResponse.setTookTime(tookTime);
        return searchApiResponse;
    }

    private <T> List<WrapResponseItem<T>> wrap(SearchApiResponse<T> targetSets) throws NoSuchFieldException {
        ArrayList sameWordRankedList = new ArrayList();
        ArrayList sameWordLowCreditRankedList = new ArrayList();
        ArrayList otherRankedList = new ArrayList();
        for (Object obj : targetSets.getSource()) {
            Object objRankerType = SearchUtils.getObject(obj, (String)"rankerType");
            Object objNewScore = SearchUtils.getObject(obj, (String)"newScore");
            String rankerType = objRankerType == null ? "other" : (String)objRankerType;
            float newScore = 0.0f;
            if (objNewScore != null && !"".equalsIgnoreCase((String)objNewScore)) {
                newScore = Float.parseFloat((String)objNewScore);
            }
            if (rankerType.equalsIgnoreCase("sameWord")) {
                sameWordRankedList.add(new WrapResponseItem(obj, newScore, rankerType));
                continue;
            }
            if (rankerType.equalsIgnoreCase("lowCreditSameWord")) {
                sameWordLowCreditRankedList.add(new WrapResponseItem(obj, newScore, rankerType));
                continue;
            }
            otherRankedList.add(new WrapResponseItem(obj, newScore, rankerType));
        }
        ArrayList<WrapResponseItem<T>> sortedItemList = new ArrayList<WrapResponseItem<T>>();
        sortedItemList.addAll(sameWordRankedList);
        sortedItemList.addAll(sameWordLowCreditRankedList);
        sortedItemList.addAll(otherRankedList);
        return sortedItemList;
    }

    @SafeVarargs
    private final <T> List<WrapResponseItem<T>> reSortList(SearchApiResponse<T> ... targetSets) throws NoSuchFieldException {
        ArrayList sameWordRankedList = new ArrayList();
        ArrayList sameWordLowCreditRankedList = new ArrayList();
        ArrayList otherRankedList = new ArrayList();
        for (SearchApiResponse<T> set : targetSets) {
            for (Object obj : set.getSource()) {
                Object objRankerType = SearchUtils.getObject(obj, (String)"rankerType");
                Object objNewScore = SearchUtils.getObject(obj, (String)"newScore");
                String rankerType = objRankerType == null ? "other" : (String)objRankerType;
                float newScore = 0.0f;
                if (objNewScore != null && !"".equalsIgnoreCase((String)objNewScore)) {
                    newScore = Float.parseFloat((String)objNewScore);
                }
                if ("sameWord".equalsIgnoreCase(rankerType)) {
                    sameWordRankedList.add(new WrapResponseItem(obj, newScore, rankerType));
                    continue;
                }
                if ("lowCreditSameWord".equalsIgnoreCase(rankerType)) {
                    sameWordLowCreditRankedList.add(new WrapResponseItem(obj, newScore, rankerType));
                    continue;
                }
                otherRankedList.add(new WrapResponseItem(obj, newScore, rankerType));
            }
        }
        sameWordRankedList.sort((a, b) -> Float.compare(b.getNewScore(), a.getNewScore()));
        sameWordLowCreditRankedList.sort((a, b) -> Float.compare(b.getNewScore(), a.getNewScore()));
        otherRankedList.sort((a, b) -> Float.compare(b.getNewScore(), a.getNewScore()));
        ArrayList<WrapResponseItem<T>> sortedItemList = new ArrayList<WrapResponseItem<T>>();
        sortedItemList.addAll(sameWordRankedList);
        sortedItemList.addAll(sameWordLowCreditRankedList);
        sortedItemList.addAll(otherRankedList);
        return sortedItemList;
    }

    static {
        BasicThreadFactory namedThreadFactory = new BasicThreadFactory.Builder().namingPattern("ALL-Search-").build();
        allSearchExecPool = new ThreadPoolExecutor(5, 200, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), (ThreadFactory)namedThreadFactory, new ThreadPoolExecutor.AbortPolicy());
    }

    private static class WrapResponseItem<T> {
        private T obj;
        private float newScore;
        private String rankerType;

        public WrapResponseItem(T obj, float newScore, String rankerType) {
            this.obj = obj;
            this.newScore = newScore;
            this.rankerType = rankerType;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof WrapResponseItem)) {
                return false;
            }
            WrapResponseItem targetItem = (WrapResponseItem)o;
            return targetItem.getObj().equals(this.obj);
        }

        public int hasCode() {
            return this.obj.hashCode();
        }

        public T getObj() {
            return this.obj;
        }

        public float getNewScore() {
            return this.newScore;
        }

        public String getRankerType() {
            return this.rankerType;
        }

        public void setObj(T obj) {
            this.obj = obj;
        }

        public void setNewScore(float newScore) {
            this.newScore = newScore;
        }

        public void setRankerType(String rankerType) {
            this.rankerType = rankerType;
        }

        public String toString() {
            return "PeliplatReorderUGCAll.WrapResponseItem(obj=" + this.getObj() + ", newScore=" + this.getNewScore() + ", rankerType=" + this.getRankerType() + ")";
        }
    }

    private class SearchWork<T>
    implements Callable<SearchApiResponse<T>> {
        private final String keyword;
        private final int pageSize;
        private final String mark;
        private final int pageId;
        private final Class<T> indexDataClazz;
        private final SearchEngineConfig config;
        private final List<Condition> excludeConditions;

        public SearchWork(int pageId, int pageSize, String keyword, String mark, Class<T> indexDataClazz, SearchEngineConfig config, List<Condition> excludeConditions) {
            this.pageSize = pageSize;
            this.keyword = keyword;
            this.mark = mark;
            this.pageId = pageId;
            this.config = config;
            this.excludeConditions = excludeConditions;
            this.indexDataClazz = indexDataClazz;
        }

        @Override
        public SearchApiResponse<T> call() {
            ArrayList<String> marks = new ArrayList<String>();
            marks.add(this.mark);
            return PeliplatReorderUGCAll.this.peliplatBizFacade.matchSearch(this.pageId, this.pageSize, this.keyword, marks, this.indexDataClazz, this.config, this.excludeConditions);
        }
    }
}

