/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.api.impl;

import com.valor.common.search.engine.SearchEngineConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;

public class DefaultSearchConfig {
    public static SearchEngineConfig initFromConfig(String configResource) throws IOException {
        try (InputStream stream = DefaultSearchConfig.getConfigStream(configResource);){
            SearchEngineConfig searchEngineConfig = DefaultSearchConfig.initFromConfig(stream);
            return searchEngineConfig;
        }
    }

    public static SearchEngineConfig initFromConfig(InputStream stream) throws IOException {
        Properties props = new Properties();
        props.load(stream);
        return DefaultSearchConfig.initFromConfig(props);
    }

    private static InputStream getConfigStream(String resource) throws IOException {
        InputStream configStream = DefaultSearchConfig.class.getResourceAsStream(resource);
        if (configStream == null) {
            configStream = DefaultSearchConfig.class.getClassLoader().getParent().getResourceAsStream(resource);
        }
        if (configStream == null) {
            throw new IOException("Cannot find " + resource + " !!!");
        }
        return configStream;
    }

    private static SearchEngineConfig initFromConfig(Properties props) {
        SearchEngineConfig settings = new SearchEngineConfig();
        settings.setHighlightPostTag(props.getProperty("search.engine.highlight.post-tag", "</em>"));
        settings.setHighlightPreTag(props.getProperty("search.engine.highlight.pre-tag", "<em>"));
        settings.setIndexName(props.getProperty("search.engine.index.name", "search_engine_index"));
        settings.setMatchMainIndexFieldName(props.getProperty("search.engine.index.main-indic-field-name", "mainTitle"));
        settings.setClassifyFieldName(props.getProperty("search.engine.index.classify-field-name", "mark"));
        settings.setScoreExpress(props.getProperty("search.engine.index.score-express", "_score*(Math.pow((doc['weight'].value+100.0)/50,2))"));
        settings.setEnableTimeFilter(Boolean.parseBoolean(props.getProperty("search.engine.enable-time-filter", "false")));
        settings.setWeightFieldName(props.getProperty("search.engine.index.weight-field-name", "weight"));
        settings.setWeightThreshold(Float.parseFloat(props.getProperty("search.engine.weight-threshold", "4.000001")));
        settings.setCelebsWeightThreshold(Float.parseFloat(props.getProperty("search.engine.celebs-weight-threshold", "8.00001")));
        settings.setEnableTurningRankerNewSort(Boolean.parseBoolean(props.getProperty("search.api.enable-tunning-ranker-new-sort", "true")));
        settings.setVideoWeightThreshold(Float.parseFloat(props.getProperty("search.engine.video-weight-threshold", "18.00001")));
        settings.setTimeFilterFieldName(props.getProperty("search.engine.time-filter-field-name", null));
        settings.setDocumentIdentifyFieldName(props.getProperty("search.engine.index.document-identify-field-name", "docId"));
        settings.setOpenHighlight(Boolean.parseBoolean(props.getProperty("search.api.open-highlight", "true")));
        String highlightFieldsName = props.getProperty("search.engine.highlight-fields-name", "title,keywords");
        settings.setHighlightFieldsName(Arrays.asList(highlightFieldsName.split(",")));
        settings.setDocumentIdentifyFieldName(props.getProperty("search.engine.index.document-identify-field-name", "docId"));
        settings.setOpenHiddenContent(Boolean.parseBoolean(props.getProperty("search.api.open-hidden-content", "true")));
        settings.setMatcherFuzzyTermLetterLimit(Integer.parseInt(props.getProperty("search.engine.matcher-fuzzy-term-letter-limit", "20")));
        settings.setMatcherSentenceLetterLimit(Integer.parseInt(props.getProperty("search.engine.matcher-sentence-letter-limit", "512")));
        return settings;
    }
}

