/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.api.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.valor.common.search.engine.zpredict.PredictionBuilder;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class EsScrollQuery {
    public static void importWordsFromEsAsync(String host, int port, String indexName, int batchSize, Logger logger) {
        new Thread(() -> {
            block4: {
                try {
                    if (logger != null) {
                        logger.info("importWordsFromEsAsync start ...");
                    }
                    long t1 = System.currentTimeMillis();
                    long totalCount = EsScrollQuery.importWordsFromEs(host, port, indexName, batchSize, logger);
                    long tt = System.currentTimeMillis() - t1;
                    if (logger != null) {
                        logger.info("importWordsFromEsAsync finished. wordsCount={} time={}", (Object)totalCount, (Object)tt);
                    }
                }
                catch (Exception e) {
                    if (logger == null) break block4;
                    logger.error("importWordsFromEsAsync ERROR: ", (Throwable)e);
                }
            }
        }).start();
    }

    public static long importWordsFromEs(String host, int port, String indexName, int batchSize, Logger logger) throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        String[] includes = new String[]{"mark", "title", "keywords"};
        AtomicInteger atomicCount = new AtomicInteger(0);
        AtomicLong atomicTotalCount = new AtomicLong();
        return EsScrollQuery.scrollQuery(host, port, indexName, includes, batchSize, hitsList -> {
            hitsList.forEach(jsonObject -> {
                JSONArray keywordsObj;
                JSONObject source = jsonObject.getJSONObject("_source");
                JSONArray titleObj = source.getJSONArray("title");
                if (titleObj != null) {
                    PredictionBuilder.batchAddSentence((List)titleObj.toJavaList(String.class));
                }
                if ((keywordsObj = source.getJSONArray("keywords")) != null) {
                    PredictionBuilder.batchAddSentence((List)keywordsObj.toJavaList(String.class));
                }
            });
            if (logger != null) {
                long totalCount = atomicTotalCount.addAndGet(hitsList.size());
                int count = atomicCount.addAndGet(hitsList.size());
                if (count >= 10 * batchSize || hitsList.size() < batchSize) {
                    logger.info("importWordsFromEs scrollQuery got {} totalCount={}", (Object)count, (Object)totalCount);
                    atomicCount.set(0);
                }
            }
        });
    }

    public static long scrollQuery(String host, int port, String indexName, String[] includes, int batchSize, Consumer<List<JSONObject>> consumer) throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        RestTemplate restTemplate = EsScrollQuery.restTemplate();
        String hostUrl = "http://" + host + ":" + port;
        String apiUrl = hostUrl + "/" + indexName + "/" + indexName + "/_search?scroll=1m";
        JSONObject matchAllObj = new JSONObject();
        matchAllObj.put("match_all", new Object());
        JSONObject jsonSearchBody = new JSONObject();
        jsonSearchBody.put("query", (Object)matchAllObj);
        jsonSearchBody.put("_source", (Object)includes);
        jsonSearchBody.put("sort", (Object)new String[]{"_doc"});
        jsonSearchBody.put("size", (Object)batchSize);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        String bodyStr = jsonSearchBody.toJSONString();
        HttpEntity httpEntity = new HttpEntity((Object)bodyStr, (MultiValueMap)headers);
        ResponseEntity responseEntity = restTemplate.postForEntity(apiUrl, (Object)httpEntity, String.class, new Object[0]);
        JSONObject object = JSON.parseObject((String)((String)responseEntity.getBody()));
        String scroll_id = object.getString("_scroll_id");
        JSONObject hits = object.getJSONObject("hits");
        JSONArray hitsArray = hits.getJSONArray("hits");
        List hitsList = hitsArray.toJavaList(JSONObject.class);
        JSONObject scroll = new JSONObject();
        scroll.put("scroll_id", (Object)scroll_id);
        scroll.put("scroll", (Object)"1m");
        long totalCount = 0L;
        while (!hitsList.isEmpty()) {
            totalCount += (long)hitsList.size();
            consumer.accept(hitsList);
            httpEntity = new HttpEntity((Object)scroll.toJSONString(), (MultiValueMap)headers);
            responseEntity = restTemplate.postForEntity(hostUrl + "/_search/scroll", (Object)httpEntity, String.class, new Object[0]);
            object = JSON.parseObject((String)((String)responseEntity.getBody()));
            hits = object.getJSONObject("hits");
            hitsArray = hits.getJSONArray("hits");
            hitsList = hitsArray.toJavaList(JSONObject.class);
        }
        try {
            JSONObject clearScroll = new JSONObject();
            clearScroll.put("scroll_id", (Object)scroll_id);
            httpEntity = new HttpEntity((Object)clearScroll.toJSONString(), (MultiValueMap)headers);
            restTemplate.exchange(hostUrl + "/_search/scroll", HttpMethod.DELETE, httpEntity, String.class, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return totalCount;
    }

    public static RestTemplate restTemplate() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        TrustStrategy acceptingTrustStrategy = (chain, authType) -> true;
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, acceptingTrustStrategy).build();
        SSLConnectionSocketFactory csf = new SSLConnectionSocketFactory(sslContext);
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)csf).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setHttpClient((HttpClient)httpClient);
        return new RestTemplate((ClientHttpRequestFactory)requestFactory);
    }
}

