/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.api.impl;

import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.Signer;
import com.valor.common.search.api.SearchApiParams;
import com.valor.common.search.api.impl.AWSRequestSigningApacheInterceptor;
import com.valor.common.search.api.impl.DefaultSearchConfig;
import com.valor.common.search.api.impl.PeliplatReorderUGCAll;
import com.valor.common.search.engine.RequestParams;
import com.valor.common.search.engine.SearchApiException;
import com.valor.common.search.engine.SearchApiResponse;
import com.valor.common.search.engine.SearchEngineConfig;
import com.valor.common.search.engine.facade.PeliplatBizFacade;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSearchApi {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSearchApi.class);
    public static final String DEFAULT_B_TYPE = "peliplat";
    private static final String CONFIG_FILE = "/search-api.properties";
    private static RestHighLevelClient elasticSearchClient;
    private static final SearchEngineConfig defaultSearchEngineConfig;

    public static SearchEngineConfig getDefaultConfig() {
        return defaultSearchEngineConfig;
    }

    public static void init(String esHost, int esPort) {
        DefaultSearchApi.init(esHost, esPort, null, null);
    }

    public static void init(String esHost, int esPort, String esUsername, String esPassword) {
        DefaultSearchApi.initInternal(esHost, esPort, esUsername, esPassword);
    }

    private static void initInternal(String esHost, int esPort, String esUsername, String esPassword) {
        RestClientBuilder clientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(esHost, esPort, "http")});
        if (!StringUtils.isEmpty((Object)esUsername) && !StringUtils.isEmpty((Object)esPassword)) {
            AWS4Signer signer = new AWS4Signer();
            signer.setServiceName("es");
            signer.setRegionName("us-east-2");
            BasicAWSCredentials awsCredentials = new BasicAWSCredentials(esUsername, esPassword);
            AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
            AWSRequestSigningApacheInterceptor interceptor = new AWSRequestSigningApacheInterceptor("es", (Signer)signer, (AWSCredentialsProvider)awsCredentialsProvider);
            clientBuilder.setHttpClientConfigCallback(requestConfigBuilder -> {
                requestConfigBuilder.addInterceptorLast(interceptor);
                requestConfigBuilder.setMaxConnTotal(1000);
                requestConfigBuilder.setKeepAliveStrategy((ConnectionKeepAliveStrategy)DefaultConnectionKeepAliveStrategy.INSTANCE);
                return requestConfigBuilder;
            });
        } else {
            clientBuilder.setHttpClientConfigCallback(requestConfigBuilder -> {
                requestConfigBuilder.setMaxConnTotal(1000);
                requestConfigBuilder.setKeepAliveStrategy((ConnectionKeepAliveStrategy)DefaultConnectionKeepAliveStrategy.INSTANCE);
                return requestConfigBuilder;
            });
        }
        clientBuilder.setRequestConfigCallback(requestConfigBuilder -> {
            requestConfigBuilder.setSocketTimeout(60000);
            requestConfigBuilder.setContentCompressionEnabled(true);
            return requestConfigBuilder;
        });
        elasticSearchClient = new RestHighLevelClient(clientBuilder);
    }

    public static <T> SearchApiResponse<T> instantSearch(String keyword, int size, Class<T> indexDataClazz, SearchApiParams searchApiParams) throws SearchApiException {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)keyword)) {
            return new SearchApiResponse();
        }
        SearchEngineConfig searchEngineConfig = DefaultSearchApi.prepareSearchApiConfig(searchApiParams);
        RequestParams requestParams = new RequestParams();
        if (!CollectionUtils.isEmpty(searchApiParams.getExcludeConditions())) {
            requestParams.setExcludeConditions(searchApiParams.getExcludeConditions());
        }
        if (!CollectionUtils.isEmpty(searchApiParams.getIncludeConditions())) {
            requestParams.setIncludeConditions(searchApiParams.getIncludeConditions());
        }
        PeliplatBizFacade peliplatAppFacade = new PeliplatBizFacade(elasticSearchClient);
        return peliplatAppFacade.instanceSearch(size, keyword, null, indexDataClazz, searchEngineConfig, requestParams);
    }

    public static <T> SearchApiResponse<T> matchSearch(int pageId, int pageSize, String keyword, List<String> marks, Class<T> indexDataClazz, SearchApiParams searchApiParams) throws SearchApiException {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)keyword)) {
            return new SearchApiResponse();
        }
        if (CollectionUtils.isEmpty(marks)) {
            marks = new ArrayList<String>();
        }
        SearchEngineConfig searchEngineConfig = DefaultSearchApi.prepareSearchApiConfig(searchApiParams);
        PeliplatBizFacade peliplatAppFacade = new PeliplatBizFacade(elasticSearchClient);
        RequestParams requestParams = new RequestParams();
        if (!CollectionUtils.isEmpty(searchApiParams.getExcludeConditions())) {
            requestParams.setExcludeConditions(searchApiParams.getExcludeConditions());
        }
        if (!CollectionUtils.isEmpty(searchApiParams.getIncludeConditions())) {
            requestParams.setIncludeConditions(searchApiParams.getIncludeConditions());
        }
        if (marks.isEmpty() || marks.contains("all")) {
            try {
                if (pageId * pageSize > 100) {
                    return new SearchApiResponse();
                }
                PeliplatReorderUGCAll reorderUGCAll = new PeliplatReorderUGCAll(peliplatAppFacade);
                return reorderUGCAll.matchSearchForUGCALL(pageId, pageSize, keyword, marks, indexDataClazz, searchEngineConfig, requestParams);
            }
            catch (Exception e) {
                logger.error("Search params: pageId={} pageSize={} keyword={} marks={} ERROR:", new Object[]{pageId, pageSize, keyword, marks, e});
                throw new SearchApiException(e);
            }
        }
        try {
            return peliplatAppFacade.matchSearch(pageId, pageSize, keyword, marks, indexDataClazz, searchEngineConfig, requestParams);
        }
        catch (Exception e) {
            logger.error("Invoke matchSearch failed: keyword:" + keyword + " marks:" + Arrays.toString(marks.toArray()) + " pageId:" + pageId + " pageSize:" + pageSize);
            throw new SearchApiException(e);
        }
    }

    public static <T> SearchApiResponse<T> matchSearchForContentId(String keyword, List<String> marks, Class<T> indexDataClazz, SearchApiParams searchApiParams) throws SearchApiException {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)keyword)) {
            return new SearchApiResponse();
        }
        SearchEngineConfig searchEngineConfig = DefaultSearchApi.prepareSearchApiConfig(searchApiParams);
        RequestParams requestParams = new RequestParams();
        if (!CollectionUtils.isEmpty(searchApiParams.getExcludeConditions())) {
            requestParams.setExcludeConditions(searchApiParams.getExcludeConditions());
        }
        if (!CollectionUtils.isEmpty(searchApiParams.getIncludeConditions())) {
            requestParams.setIncludeConditions(searchApiParams.getIncludeConditions());
        }
        PeliplatBizFacade peliplatAppFacade = new PeliplatBizFacade(elasticSearchClient);
        return peliplatAppFacade.matchSearchForContentId(keyword, marks, indexDataClazz, searchEngineConfig, requestParams);
    }

    public static Map<String, Long> matchCount(String keyword, SearchApiParams searchApiParams) throws SearchApiException {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)keyword)) {
            return new HashMap<String, Long>();
        }
        SearchEngineConfig searchEngineConfig = DefaultSearchApi.prepareSearchApiConfig(searchApiParams);
        PeliplatBizFacade peliplatAppFacade = new PeliplatBizFacade(elasticSearchClient);
        try {
            RequestParams requestParams = new RequestParams();
            if (!CollectionUtils.isEmpty(searchApiParams.getExcludeConditions())) {
                requestParams.setExcludeConditions(searchApiParams.getExcludeConditions());
            }
            if (!CollectionUtils.isEmpty(searchApiParams.getIncludeConditions())) {
                requestParams.setIncludeConditions(searchApiParams.getIncludeConditions());
            }
            return peliplatAppFacade.matchCount(keyword, searchEngineConfig, requestParams);
        }
        catch (Exception e) {
            throw new SearchApiException(e);
        }
    }

    public static <T> SearchApiResponse<T> strictMatchSearch(int pageId, int pageSize, String keyword, List<String> marks, Class<T> indexDataClazz, SearchApiParams searchApiParams) throws SearchApiException {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)keyword)) {
            return new SearchApiResponse();
        }
        if (CollectionUtils.isEmpty(marks)) {
            marks = new ArrayList<String>();
        }
        SearchEngineConfig searchEngineConfig = DefaultSearchApi.prepareSearchApiConfig(searchApiParams);
        PeliplatBizFacade peliplatAppFacade = new PeliplatBizFacade(elasticSearchClient);
        RequestParams requestParams = new RequestParams();
        if (!CollectionUtils.isEmpty(searchApiParams.getExcludeConditions())) {
            requestParams.setExcludeConditions(searchApiParams.getExcludeConditions());
        }
        if (!CollectionUtils.isEmpty(searchApiParams.getIncludeConditions())) {
            requestParams.setIncludeConditions(searchApiParams.getIncludeConditions());
        }
        return peliplatAppFacade.strictMatchSearch(pageId, pageSize, keyword, marks, indexDataClazz, searchEngineConfig, requestParams);
    }

    public static <T> SearchApiResponse<T> strictInstantSearch(String keyword, int size, Class<T> indexDataClazz, SearchApiParams searchApiParams) throws SearchApiException {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)keyword)) {
            return new SearchApiResponse();
        }
        SearchEngineConfig searchEngineConfig = DefaultSearchApi.prepareSearchApiConfig(searchApiParams);
        PeliplatBizFacade peliplatAppFacade = new PeliplatBizFacade(elasticSearchClient);
        RequestParams requestParams = new RequestParams();
        if (!CollectionUtils.isEmpty(searchApiParams.getExcludeConditions())) {
            requestParams.setExcludeConditions(searchApiParams.getExcludeConditions());
        }
        if (!CollectionUtils.isEmpty(searchApiParams.getIncludeConditions())) {
            requestParams.setIncludeConditions(searchApiParams.getIncludeConditions());
        }
        return peliplatAppFacade.strictInstanceSearch(size, keyword, null, indexDataClazz, searchEngineConfig, requestParams);
    }

    public static Map<String, Long> strictMatchCount(String keyword, SearchApiParams searchApiParams) throws SearchApiException {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)keyword)) {
            return new HashMap<String, Long>();
        }
        SearchEngineConfig searchEngineConfig = DefaultSearchApi.prepareSearchApiConfig(searchApiParams);
        PeliplatBizFacade peliplatAppFacade = new PeliplatBizFacade(elasticSearchClient);
        RequestParams requestParams = new RequestParams();
        if (!CollectionUtils.isEmpty(searchApiParams.getExcludeConditions())) {
            requestParams.setExcludeConditions(searchApiParams.getExcludeConditions());
        }
        if (!CollectionUtils.isEmpty(searchApiParams.getIncludeConditions())) {
            requestParams.setIncludeConditions(searchApiParams.getIncludeConditions());
        }
        try {
            return peliplatAppFacade.strictMatchCount(keyword, searchEngineConfig, requestParams);
        }
        catch (Exception e) {
            throw new SearchApiException(e);
        }
    }

    private static SearchEngineConfig prepareSearchApiConfig(SearchApiParams params) {
        SearchEngineConfig engineConfig = new SearchEngineConfig(defaultSearchEngineConfig);
        if (params == null) {
            return engineConfig;
        }
        if (params.getOpenHiddenContent() != null) {
            engineConfig.setOpenHiddenContent(params.getOpenHiddenContent().booleanValue());
        }
        if (params.getOpenHighlight() != null) {
            engineConfig.setOpenHighlight(params.getOpenHighlight().booleanValue());
        }
        if (!StringUtils.isEmpty((Object)params.getHighlightPostTag())) {
            engineConfig.setHighlightPostTag(params.getHighlightPostTag());
        }
        if (!StringUtils.isEmpty((Object)params.getHighlightPreTag())) {
            engineConfig.setHighlightPreTag(params.getHighlightPreTag());
        }
        if (!StringUtils.isEmpty((Object)params.getIndexName())) {
            engineConfig.setIndexName(params.getIndexName());
        }
        if (!CollectionUtils.isEmpty(params.getBizParams())) {
            engineConfig.setBizParams(new HashMap<String, Number>(params.getBizParams()));
        }
        if (params.getMatcherFuzzyTermLetterLimit() != null) {
            engineConfig.setMatcherFuzzyTermLetterLimit(params.getMatcherFuzzyTermLetterLimit().intValue());
        }
        if (params.getMatcherSentenceLetterLimit() != null) {
            engineConfig.setMatcherSentenceLetterLimit(params.getMatcherSentenceLetterLimit().intValue());
        }
        if (params.getFuzzinessQueryMode() != null) {
            engineConfig.setFuzzinessQueryMode(params.getFuzzinessQueryMode());
        }
        if (params.getPredictParams() != null) {
            engineConfig.setPredictParams(params.getPredictParams());
        }
        if (params.getMatchingTitleVerbosity() != null) {
            engineConfig.setMatchingTitleVerbosity(params.getMatchingTitleVerbosity());
        }
        if (params.getMatchingTitleExpectExts() != null) {
            engineConfig.setMatchingTitleExpectExts(params.getMatchingTitleExpectExts());
        }
        return engineConfig;
    }

    static {
        try {
            defaultSearchEngineConfig = DefaultSearchConfig.initFromConfig(CONFIG_FILE);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load search-api configuration /search-api.properties", e);
        }
    }
}

