/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine;

import com.valor.common.search.engine.facade.config.HighlightConfig;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.SearchUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;

public class RequestContext
implements Serializable,
Cloneable {
    public static final String KEY_MAIN_INDEX_FIELD = "normal_full_text_field";
    public static final String KEY_FUZZY_SUBINDEX_FIELD = "fuzzy_full_text_field";
    public static final String FUZZY_SUBINDEX_FIELD_SHORT_NAME = "word_letters";
    public static final String KEY_MININUM_SUBINDEX_FIELD = "mininum_full_text_field";
    public static final String MININUM_SUBINDEX_FIELD_SHORT_NAME = "all_letters";
    public static final String KEY_WORD_SUBINDEX_FIELD = "word_full_text_field";
    public static final String WORD_SUBINDEX_FIELD_SHORT_NAME = "cut_word";
    public static final String KEY_WORD_ANALYZER_NAME = "word_analyzer_name";
    public static final String KEY_HIGHT_LIGHT_START_TAG = "<h1>";
    public static final String KEY_HIGHT_LIGHT_END_TAG = "</h1>";
    public static final String KEY_INVALID_DOC_COUNT = "invalid_doc_count";
    public static final String KEY_EXECUT_PARTIALWORD_QUERY = "execute_partiword_query";
    public static final String KEY_EXECUT_PARTIALWORD_ALIAS_QUERY = "execute_partiword_alis_query";
    public static final String KEY_EXECUT_EXTRAWORD_ALIAS_QUERY = "execute_extraword_alis_query";
    public static final String KEY_EXECUT_EXTRAWORD_MISS_ALIAS_QUERY = "execute_extraword_alis_query";
    public static final String KEY_CLASSIFY_FIELD_NAME = "classifyFieldName";
    public static final String KEY_MATCHER_FUZZY_TERM_LETTER_LIMIT = "matcher_fuzzy_term_letter_limit";
    public static final String KEY_MATCHER_WORD_TERM_LETTER_LIMIT = "matcher_word_term_letter_limit";
    public static final String KEY_MATCHER_SENTENCE_LETTER_LIMIT = "matcher_sentence_letter_limit";
    private String q;
    private String originalQ;
    private SearchResponse response;
    private String indexName;
    private RestHighLevelClient restHighLevelClient;
    private int fromIndex = 0;
    private int size = 200;
    private List<String> marks = new ArrayList<String>();
    private String highlightPostTag = "</em>";
    private String highlightPreTag = "<em>";
    private String mainIndexFieldName = "title";
    private final Map<String, String> attributeMap = new ConcurrentHashMap<String, String>();
    private final Map<String, Number> numberAttributeMap = new ConcurrentHashMap<String, Number>();
    private final Map<String, String> machterMatcheFieldNameMap = new HashMap<String, String>();
    private final Map<String, List<String>> machterMultiMatcheFieldNameMap = new HashMap<String, List<String>>();
    private final Map<String, List<String>> queryMatcherMatchedFieldNameMap = new HashMap<String, List<String>>();
    private final Map<String, Set<String>> querySentenceMatchedFieldNamesMap = new HashMap<String, Set<String>>();
    private List<HighlightConfig.HighlightItemConfig> highlightItemConfigList;
    private String defaultHighlightType = "unified";
    private String highlightExtFieldNameSuffix;
    private Map<String, Object> bizSysConfig = new HashMap<String, Object>();

    @PostConstruct
    private void postConstruct() {
        this.attributeMap.put(KEY_MAIN_INDEX_FIELD, this.mainIndexFieldName);
        this.attributeMap.put(KEY_FUZZY_SUBINDEX_FIELD, this.mainIndexFieldName + "." + FUZZY_SUBINDEX_FIELD_SHORT_NAME);
        this.attributeMap.put(KEY_MININUM_SUBINDEX_FIELD, this.mainIndexFieldName + "." + MININUM_SUBINDEX_FIELD_SHORT_NAME);
        this.attributeMap.put(KEY_WORD_SUBINDEX_FIELD, this.mainIndexFieldName + "." + WORD_SUBINDEX_FIELD_SHORT_NAME);
        this.attributeMap.put(KEY_WORD_ANALYZER_NAME, "cutsomeword");
        this.numberAttributeMap.put(KEY_INVALID_DOC_COUNT, 0);
    }

    public Map<String, Set<String>> getQuerySentenceMatchedFieldNamesMap() {
        return this.querySentenceMatchedFieldNamesMap;
    }

    public void putQuerySentenceMatchedFieldNamesMap(String querySentenceName, Set<String> matchedFieldNames) {
        this.querySentenceMatchedFieldNamesMap.put(querySentenceName, matchedFieldNames);
    }

    public String getDefaultHighlightType() {
        return this.defaultHighlightType;
    }

    public void setDefaultHighlightType(String defaultHighlightType) {
        this.defaultHighlightType = defaultHighlightType;
    }

    public String getHighlightPostTag() {
        return this.highlightPostTag;
    }

    public void setHighlightPostTag(String highlightPostTag) {
        this.highlightPostTag = highlightPostTag;
    }

    public String getHighlightPreTag() {
        return this.highlightPreTag;
    }

    public void setHighlightPreTag(String highlightPreTag) {
        this.highlightPreTag = highlightPreTag;
    }

    public void putAttribute(String key, String value) {
        this.attributeMap.put(key, value);
    }

    public void putNumAttr(String key, Number num) {
        this.numberAttributeMap.put(key, num);
    }

    public Number getNumAttr(String key) {
        return this.numberAttributeMap.get(key);
    }

    public String getAttribure(String key) {
        return this.attributeMap.get(key);
    }

    public Map<String, List<String>> getQueryMatcherMatchedFieldNameMap() {
        return this.queryMatcherMatchedFieldNameMap;
    }

    public void putQueryMatcherMatchedFieldNameMap(String matcherName, List<String> matchedFieldNameList) {
        this.queryMatcherMatchedFieldNameMap.put(matcherName, matchedFieldNameList);
    }

    public RequestContext(String q, String indexName, RestHighLevelClient client) {
        this.originalQ = q;
        this.q = SearchUtils.rebuildQ(q);
        this.indexName = indexName;
        this.restHighLevelClient = client;
        this.postConstruct();
    }

    public RequestContext(String q, String indexName, RestHighLevelClient client, int fromIndex, int size) {
        if (fromIndex + size > 10000) {
            throw new RuntimeException("ResultSet are too large  ");
        }
        this.originalQ = q;
        this.q = SearchUtils.rebuildQ(q);
        this.indexName = indexName;
        this.restHighLevelClient = client;
        this.fromIndex = fromIndex;
        this.size = size;
        this.postConstruct();
    }

    public RequestContext(String q, String indexName, String mainIndexFieldName, RestHighLevelClient client) {
        this.originalQ = q;
        this.q = SearchUtils.rebuildQ(q);
        this.indexName = indexName;
        this.restHighLevelClient = client;
        this.mainIndexFieldName = mainIndexFieldName;
        this.postConstruct();
    }

    public RequestContext(String q, String indexName, String mainIndexFieldName, RestHighLevelClient client, int fromIndex, int size) {
        if (fromIndex + size > 10000) {
            throw new RuntimeException("ResultSet are too large  ");
        }
        this.originalQ = q;
        this.q = SearchUtils.rebuildQ(q);
        this.indexName = indexName;
        this.restHighLevelClient = client;
        this.mainIndexFieldName = mainIndexFieldName;
        this.fromIndex = fromIndex;
        this.size = size;
        this.postConstruct();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public RestHighLevelClient getRestHighLevelClient() {
        return this.restHighLevelClient;
    }

    public String getQ() {
        return this.q;
    }

    public int fromIndex() {
        return this.fromIndex;
    }

    public int size() {
        return this.size;
    }

    public void saveResponse(SearchResponse response) {
        this.response = response;
    }

    public SearchResponse getResponse() {
        return this.response;
    }

    public void saveMatcheNameandMatcheFieldNamePair(String matcheName, String matcheFieldName) {
        this.machterMatcheFieldNameMap.put(matcheName, matcheFieldName);
    }

    public void saveMultiMatcheNameandMatcheFieldNamePair(String matcheName, List<String> matcheFieldName) {
        if (!CollectionUtils.isEmpty((Collection)this.machterMultiMatcheFieldNameMap.get(matcheName))) {
            List<String> list = this.machterMultiMatcheFieldNameMap.get(matcheName);
            list.addAll(matcheFieldName);
            this.machterMultiMatcheFieldNameMap.put(matcheName, list);
        } else {
            this.machterMultiMatcheFieldNameMap.put(matcheName, matcheFieldName);
        }
    }

    public String getMatcheFieldName(String matcheName) {
        return this.machterMatcheFieldNameMap.get(matcheName);
    }

    public Map<String, String> getmachterMatcheFieldNameMap() {
        return this.machterMatcheFieldNameMap;
    }

    public Map<String, List<String>> getMachterMultiMatcheFieldNameMap() {
        return this.machterMultiMatcheFieldNameMap;
    }

    public List<String> getMachterMultiMatcheFieldNameMap(String matcheName) {
        return this.machterMultiMatcheFieldNameMap.get(matcheName);
    }

    public List<String> getMarks() {
        return this.marks;
    }

    public void putMarks(List<String> marks) {
        this.marks.addAll(marks);
    }

    public Map<String, Object> getBizSysConfig() {
        return this.bizSysConfig;
    }

    public void setBizSysConfig(Map<String, Object> bizSysConfig) {
        this.bizSysConfig = bizSysConfig;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public List<HighlightConfig.HighlightItemConfig> getHighLightItemConfigList() {
        return this.highlightItemConfigList;
    }

    public void setHighLightItemConfigList(List<HighlightConfig.HighlightItemConfig> highLightItemConfigList) {
        this.highlightItemConfigList = highLightItemConfigList;
    }

    public String getHighlightExtFieldNameSuffix() {
        return this.highlightExtFieldNameSuffix;
    }

    public void setHighlightExtFieldNameSuffix(String highlightExtFieldNameSuffix) {
        this.highlightExtFieldNameSuffix = highlightExtFieldNameSuffix;
    }
}

