/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.compensator;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.compensator.Compensator;
import com.valor.common.search.engine.facade.config.CompensatorConfig;
import com.valor.common.search.engine.filter.PostFilter;
import com.valor.common.search.engine.ranker.AbstractInlineScoreRanker;
import com.valor.common.search.engine.ranker.AbstractPostScoreRanker;
import com.valor.common.search.engine.ranker.ScoreRanker;
import com.valor.common.search.engine.util.CollectionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.keyvalue.DefaultKeyValue;

public abstract class AbstractCompensator
implements Compensator {
    protected String compensateName = "";
    protected String matchFieldName;
    protected RequestContext context;
    protected boolean inited = false;
    protected String q;
    protected CompensatorConfig compensaterConfig;
    protected List<PostFilter> postFilterList = new ArrayList<PostFilter>();
    protected List<AbstractPostScoreRanker> postRankerList = new ArrayList<AbstractPostScoreRanker>();
    protected List<AbstractInlineScoreRanker> inLineRankList = new ArrayList<AbstractInlineScoreRanker>();
    protected List<DefaultKeyValue> querySentenceMatchedFieldNamePairsList = new ArrayList<DefaultKeyValue>();

    @Override
    public Compensator name(String name) {
        this.compensateName = name;
        return this;
    }

    public void prepareByConfig(CompensatorConfig config) {
    }

    public void setContext(RequestContext context) {
        if (this.inited) {
            return;
        }
        if (this.context == null) {
            this.context = context;
            this.q = context.getQ().trim();
        }
    }

    @Override
    public String getName() {
        return this.compensateName;
    }

    protected void saveQuerySentenceMatchedFieldNameMapToContext() {
        HashMap<String, Set> querySentenceMatchedFieldNameMap = new HashMap<String, Set>();
        for (DefaultKeyValue defaultKeyValue : this.querySentenceMatchedFieldNamePairsList) {
            String matchedName = defaultKeyValue.getKey().toString();
            Set matchedFieldNameList = (Set)defaultKeyValue.getValue();
            Set savedMatchedFieldName = (Set)querySentenceMatchedFieldNameMap.get(matchedName);
            if (savedMatchedFieldName != null) {
                savedMatchedFieldName.addAll(matchedFieldNameList);
                continue;
            }
            querySentenceMatchedFieldNameMap.put(matchedName, matchedFieldNameList);
        }
        for (Map.Entry entry : querySentenceMatchedFieldNameMap.entrySet()) {
            this.context.putQuerySentenceMatchedFieldNamesMap((String)entry.getKey(), (Set)entry.getValue());
        }
    }

    protected void saveSentenceMatchFieldName(String sentenceMatchName, String ... fieldNames) {
        DefaultKeyValue defaultKeyValue = new DefaultKeyValue((Object)sentenceMatchName, new HashSet(CollectionUtils.arrayToList(fieldNames)));
        this.querySentenceMatchedFieldNamePairsList.add(defaultKeyValue);
    }

    @Override
    public Compensator ranker(ScoreRanker ranker) {
        if (ranker instanceof AbstractInlineScoreRanker) {
            this.inLineRankList.add((AbstractInlineScoreRanker)ranker);
        } else if (ranker instanceof AbstractPostScoreRanker) {
            this.postRankerList.add((AbstractPostScoreRanker)ranker);
        }
        return this;
    }
}

