/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.facade;

import com.valor.common.search.engine.DefaultSearcher;
import com.valor.common.search.engine.facade.BizContainerBuilder;
import com.valor.common.search.engine.filter.GeneralFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import org.apache.http.HttpHost;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;

public class BizsBuilderExample {
    public static void main(String[] args) throws IOException {
        BizContainerBuilder customBizBuilder = null;
        String bizBuilderConfig = BizsBuilderExample.readAllLines("F:\\workspace\\searchengine-core\\doc\\appConfig\\search-engint-app-config.json");
        HashMap<String, Object> appConfig = new HashMap<String, Object>();
        appConfig.put("indexName", "search_engine_index_dev_01");
        appConfig.put("matchMainIndexFieldName", "mainTitle");
        customBizBuilder = BizContainerBuilder.newInstance(bizBuilderConfig, appConfig, BizsBuilderExample.initEsClient());
        DefaultSearcher defaultSearcher = customBizBuilder.build("peliplat-search", "EL camino", 0, 100);
        defaultSearcher.fillter(new GeneralFilter("mark", new String[]{"movies"}));
        System.out.println(defaultSearcher.execute());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readAllLines(String fullFileName) {
        try (FileReader fileReader = new FileReader(fullFileName);){
            int readCount = 0;
            char[] buffer = new char[1024];
            StringBuffer stringBuffer = new StringBuffer();
            while ((readCount = fileReader.read(buffer, 0, 1024)) != -1) {
                stringBuffer.append(buffer, 0, readCount);
            }
            String string = stringBuffer.toString();
            return string;
        }
        catch (Exception e) {
            return "";
        }
    }

    private static RestHighLevelClient initEsClient() {
        RestClientBuilder clientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost("localhost", 9200, "http")});
        clientBuilder.setHttpClientConfigCallback(f -> {
            f.setMaxConnTotal(1000);
            f.setKeepAliveStrategy((ConnectionKeepAliveStrategy)DefaultConnectionKeepAliveStrategy.INSTANCE);
            return f;
        });
        clientBuilder.setRequestConfigCallback(f -> {
            f.setSocketTimeout(60000);
            f.setContentCompressionEnabled(true);
            return f;
        });
        return new RestHighLevelClient(clientBuilder);
    }
}

