/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.filter;

import com.alibaba.fastjson.JSONArray;
import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.facade.config.InlineFilterConfig;
import com.valor.common.search.engine.filter.FilterFuncEnum;
import com.valor.common.search.engine.filter.GeneralFilterBase;
import com.valor.common.search.engine.filter.InlineFilter;
import com.valor.common.search.engine.filter.InlineFilterBase;
import com.valor.common.search.engine.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class GeneralFilter
extends GeneralFilterBase
implements InlineFilter {
    private Func func = Func.OR;

    public GeneralFilter() {
    }

    public GeneralFilter(String filterFieldName, String filterValue, FilterFuncEnum filterType, RequestContext context) {
        super(filterFieldName, filterValue, filterType, context);
    }

    public GeneralFilter(String filterFieldName, String filterValue, FilterFuncEnum filterType) {
        super(filterFieldName, filterValue, filterType);
    }

    public GeneralFilter(String filterFieldName, String topValue, String buttomValue, RequestContext context) {
        super(filterFieldName, topValue, buttomValue, context);
    }

    public GeneralFilter(String filterFieldName, String topValue, String buttomValue) {
        super(filterFieldName, topValue, buttomValue);
    }

    public GeneralFilter(String filterFieldName, String[] values) {
        super(filterFieldName, values);
    }

    public GeneralFilter(String filterFieldName, String[] values, FilterFuncEnum filterType) {
        super(filterFieldName, values, filterType);
    }

    public static GeneralFilter from(InlineFilterBase inlineFilterBase) {
        GeneralFilterBase base = (GeneralFilterBase)inlineFilterBase;
        GeneralFilter generalFilter = new GeneralFilter();
        generalFilter.filterName = base.getFilterName();
        generalFilter.filterConditionList.addAll(base.getFilterConditionList());
        generalFilter.inLintFilterConfig = base.getInLintFilterConfig();
        generalFilter.mainFilterFieldName = base.getMainFilterFieldName();
        generalFilter.context = base.getContext();
        return generalFilter;
    }

    @Override
    public GeneralFilter append(String value, FilterFuncEnum filterType) {
        super.append(value, filterType);
        return this;
    }

    @Override
    public GeneralFilter append(String[] values) {
        super.append(values);
        return this;
    }

    @Override
    public GeneralFilter appendRange(String topValue, String buttomValue) {
        super.appendRange(topValue, buttomValue);
        return this;
    }

    @Override
    public GeneralFilter append(String filterFieldName, String value, FilterFuncEnum filterType) {
        super.append(filterFieldName, value, filterType);
        return this;
    }

    @Override
    public GeneralFilter append(String filterFieldName, String[] values) {
        super.append(filterFieldName, values);
        return this;
    }

    @Override
    public GeneralFilter appendRange(String filterFieldName, String topValue, String buttomValue) {
        super.appendRange(filterFieldName, topValue, buttomValue);
        return this;
    }

    @Override
    public QueryBuilder build(QueryBuilder targetQueryBuilder) {
        if (this.filterConditionList.size() == 0 || ((GeneralFilterBase.FilterCondition)this.filterConditionList.get((int)0)).filterType == null) {
            return targetQueryBuilder;
        }
        QueryBuilder filter = this.build();
        if (filter != null) {
            return QueryBuilders.boolQuery().must(targetQueryBuilder).filter(filter);
        }
        return targetQueryBuilder;
    }

    @Override
    public QueryBuilder build() {
        if (this.filterConditionList.size() == 1) {
            return this.internalBuild((GeneralFilterBase.FilterCondition)this.filterConditionList.get(0));
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (this.func.equals((Object)Func.OR)) {
            for (GeneralFilterBase.FilterCondition condition : this.filterConditionList) {
                boolQueryBuilder.should(this.internalBuild(condition));
            }
            return boolQueryBuilder.minimumShouldMatch(0);
        }
        for (GeneralFilterBase.FilterCondition condition : this.filterConditionList) {
            boolQueryBuilder.must(this.internalBuild(condition));
        }
        return boolQueryBuilder;
    }

    private QueryBuilder internalBuild(GeneralFilterBase.FilterCondition condition) {
        Object filter = null;
        if (StringUtils.isEmpty(condition.filterFieldName)) {
            throw new RuntimeException("Filter fieldName must not null");
        }
        if (condition.filterType == FilterFuncEnum.RANGE) {
            if (StringUtils.isEmpty(condition.topValue) || StringUtils.isEmpty(condition.buttomValue)) {
                throw new RuntimeException("Filter value must not null");
            }
        } else if (!condition.multiValueFilter) {
            if (StringUtils.isEmpty(condition.filterValue)) {
                throw new RuntimeException("Filter value must not null");
            }
        } else if (condition.values == null || condition.values.length == 0) {
            throw new RuntimeException("Filter values must not null or empty");
        }
        if (condition.filterType == FilterFuncEnum.EQUAL) {
            filter = condition.multiValueFilter ? QueryBuilders.termsQuery((String)condition.filterFieldName, (String[])condition.values) : QueryBuilders.termQuery((String)condition.filterFieldName, (String)condition.filterValue);
        } else if (condition.filterType == FilterFuncEnum.LT) {
            filter = QueryBuilders.rangeQuery((String)condition.filterFieldName).lt((Object)condition.filterValue);
        } else if (condition.filterType == FilterFuncEnum.GT) {
            filter = QueryBuilders.rangeQuery((String)condition.filterFieldName).gt((Object)condition.filterValue);
        } else if (condition.filterType == FilterFuncEnum.GTE) {
            filter = QueryBuilders.rangeQuery((String)condition.filterFieldName).gte((Object)condition.filterValue);
        } else if (condition.filterType == FilterFuncEnum.LTE) {
            filter = QueryBuilders.rangeQuery((String)condition.filterFieldName).lte((Object)condition.filterValue);
        } else if (condition.filterType == FilterFuncEnum.RANGE) {
            filter = QueryBuilders.rangeQuery((String)condition.filterFieldName).lte((Object)condition.topValue).gte((Object)condition.buttomValue);
        } else if (condition.filterType == FilterFuncEnum.NOTEQUAL) {
            filter = condition.multiValueFilter ? QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)condition.filterFieldName, (String[])condition.values)) : QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)condition.filterFieldName, (String)condition.filterValue));
        }
        return filter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void prepareByConfig(InlineFilterConfig config) {
        this.context = config.getContext();
        if (!StringUtils.isEmpty(config.getOpFunc())) {
            this.func = Func.valueOf(config.getOpFunc());
        }
        this.inLintFilterConfig = config;
        try {
            this.filterName = config.getIdName();
            Map mainParams = (Map)config.getParams().get("mainParams");
            String filterFieldName = mainParams.get("filterFieldName").toString();
            Object objFilterValue = mainParams.get("filterValue");
            List values = new ArrayList<String>();
            if (objFilterValue instanceof String) {
                values.add(objFilterValue.toString());
            } else {
                values = (List)mainParams.get("filterValue");
            }
            String filterType = mainParams.get("filterType").toString();
            this.mainFilterFieldName = filterFieldName;
            this.filterConditionList.add(new GeneralFilterBase.FilterCondition(filterFieldName, (String[])values.stream().map(a -> this.getFilterValueFromContext((String)a)).toArray(String[]::new), FilterFuncEnum.valueOf(filterType)));
            if (!(config.getParams().get("appendParams") instanceof List)) {
                return;
            }
            List appendParams = (List)config.getParams().get("appendParams");
            for (Map paramItem : appendParams) {
                String methodName = paramItem.get("method").toString();
                Map appendMethodParams = (Map)paramItem.get("params");
                Object filterFieldName1 = appendMethodParams.get("filterFieldName");
                Object filterValue = appendMethodParams.get("filterValue");
                if ("append".equals(methodName)) {
                    String strFilterValue;
                    String filterType1;
                    if (StringUtils.isEmpty(filterFieldName1)) {
                        if (filterValue instanceof JSONArray) {
                            if (!StringUtils.isEmpty(appendMethodParams.get("filterType"))) throw new RuntimeException(this.getFilterName() + "appendParams  error");
                            this.append((String[])((JSONArray)filterValue).stream().map(a -> this.getFilterValueFromContext(a.toString())).toArray(String[]::new));
                            continue;
                        }
                        if (filterValue == null) throw new RuntimeException(this.getFilterName() + "appendParams error");
                        filterType1 = appendMethodParams.get("filterType").toString();
                        strFilterValue = filterValue.toString();
                        if (strFilterValue.startsWith("$")) {
                            strFilterValue = this.getFilterValueFromContext(strFilterValue);
                        }
                        this.append(strFilterValue, FilterFuncEnum.valueOf(filterType1));
                        continue;
                    }
                    if (filterValue instanceof JSONArray) {
                        if (!StringUtils.isEmpty(appendMethodParams.get("filterType"))) throw new RuntimeException(this.getFilterName() + "appendParams  error");
                        this.append(filterFieldName1.toString(), (String[])((JSONArray)filterValue).stream().map(a -> this.getFilterValueFromContext(a.toString())).toArray(String[]::new));
                        continue;
                    }
                    if (!(filterValue instanceof String)) throw new RuntimeException(this.getFilterName() + "appendParams error");
                    filterType1 = appendMethodParams.get("filterType");
                    if (StringUtils.isEmpty(filterType1)) throw new RuntimeException(this.getFilterName() + "appendParams  error");
                    strFilterValue = this.getFilterValueFromContext(filterValue.toString());
                    this.append(filterFieldName1.toString(), strFilterValue, FilterFuncEnum.valueOf(filterType1.toString()));
                    continue;
                }
                if (!"appendRange".equalsIgnoreCase(methodName)) continue;
                try {
                    String strButtomValue;
                    String strTopValue;
                    if (!StringUtils.isEmpty(appendMethodParams.get("filterType"))) {
                        throw new RuntimeException(this.getFilterName() + "appendParams  filterType must empty in appendRange ");
                    }
                    Object topValue = appendMethodParams.get("topValue");
                    Object buttomValue = appendMethodParams.get("buttomValue");
                    if (StringUtils.isEmpty(filterFieldName1)) {
                        if (StringUtils.isEmpty(topValue) || StringUtils.isEmpty(buttomValue)) throw new RuntimeException(this.getFilterName() + "appendParams error");
                        strTopValue = this.getFilterValueFromContext(topValue.toString());
                        strButtomValue = this.getFilterValueFromContext(buttomValue.toString());
                        this.appendRange(strTopValue, strButtomValue);
                        continue;
                    }
                    if (StringUtils.isEmpty(topValue) || StringUtils.isEmpty(buttomValue)) throw new RuntimeException(this.getFilterName() + "appendParams error");
                    strTopValue = this.getFilterValueFromContext(topValue.toString());
                    strButtomValue = this.getFilterValueFromContext(buttomValue.toString());
                    this.appendRange(filterFieldName1.toString(), strTopValue, strButtomValue);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getFilterValueFromContext(String strFilterValue) {
        if (!strFilterValue.startsWith("$")) {
            return strFilterValue;
        }
        if (this.context == null) {
            throw new RuntimeException(strFilterValue + " filterValue is error");
        }
        if ("$q".equalsIgnoreCase(strFilterValue)) {
            strFilterValue = this.context.getQ();
        } else {
            strFilterValue = strFilterValue.replaceAll("$", "");
            strFilterValue = this.context.getAttribure(strFilterValue).toLowerCase();
        }
        return strFilterValue;
    }

    @Override
    public String getFilterName() {
        return this.filterName;
    }

    @Override
    public int getFilterType() {
        return super.getFilterType();
    }

    @Override
    public String getInlineFilterClassName() {
        return this.getClass().getName();
    }

    public static enum Func {
        OR(1, "\u6216"),
        AND(2, "\u5e76\u4e14");

        private int value;
        private String desc;

        private Func(int index, String desc) {
            this.value = index;
            this.desc = desc;
        }
    }
}

