/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.matcher;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.facade.config.ClosableCombinedFilterConfig;
import com.valor.common.search.engine.facade.config.CombinedFilterConfig;
import com.valor.common.search.engine.facade.config.InlineFilterConfig;
import com.valor.common.search.engine.facade.config.MatcherConfig;
import com.valor.common.search.engine.facade.config.MatcherParams;
import com.valor.common.search.engine.filter.CompositeFilter;
import com.valor.common.search.engine.filter.InlineFilter;
import com.valor.common.search.engine.matcher.Matcher;
import com.valor.common.search.engine.ranker.AbstractInlineScoreRanker;
import com.valor.common.search.engine.ranker.FunctionScoreRanker;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.keyvalue.DefaultKeyValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public abstract class AbstractMatcher
implements Matcher {
    public static final float DEFAULT_GLOBAL_BOOST = 1.0f;
    public static final float DEFAULT_BOOST = 1.0f;
    protected int MATCHER_FUZZY_TERM_LETTER_LIMIT = 20;
    protected int MATCHER_WORD_TERM_LETTER_LIMIT = 30;
    protected int MATCHER_SENTENCE_LETTER_LIMIT = 512;
    protected RequestContext context;
    protected Set<Matcher> excludeMatchList = new HashSet<Matcher>();
    protected Set<InlineFilter> filterList = new HashSet<InlineFilter>();
    protected AbstractInlineScoreRanker scoreRanker = null;
    protected String matchName = "";
    protected String q;
    protected String analyzerName = "";
    protected String matchFieldName = "";
    protected float boost = 1.0f;
    protected float globalBoost = 1.0f;
    protected boolean inited = false;
    protected MatcherConfig matcherConfig = null;
    protected List<DefaultKeyValue> querySentenceMatchedFieldNamePairsList = new ArrayList<DefaultKeyValue>();

    @Override
    public String getMatchFieldName() {
        return this.matchFieldName;
    }

    @Override
    public Matcher name(String matchName) {
        this.matchName = matchName;
        return this;
    }

    @Override
    public String getMatchName() {
        return this.matchName;
    }

    @Override
    public Matcher exclude(Matcher matcher) {
        this.excludeMatchList.add(matcher);
        return this;
    }

    @Override
    public Matcher filter(InlineFilter filter) {
        this.filterList.add(filter);
        return this;
    }

    @Override
    public Matcher scoreRanker(AbstractInlineScoreRanker ranker) {
        this.scoreRanker = ranker;
        return this;
    }

    @Override
    public QueryBuilder buildAll() {
        QueryBuilder query = this.buildWith(Matcher.BUILD_MODE.WITH_EXCLUDE, Matcher.BUILD_MODE.WITH_FILTER, Matcher.BUILD_MODE.WITH_RANKER);
        if (query == null) {
            return null;
        }
        query.queryName(this.matchName).boost(this.globalBoost);
        return query;
    }

    @Override
    public QueryBuilder buildBaseWidthFilter() {
        QueryBuilder baseQuery = this.buildBase();
        if (baseQuery == null) {
            return null;
        }
        BoolQueryBuilder matcherQueryBuilder = null;
        if (baseQuery instanceof BoolQueryBuilder) {
            matcherQueryBuilder = (BoolQueryBuilder)baseQuery;
            for (InlineFilter filter : this.filterList) {
                matcherQueryBuilder.filter(filter.build());
            }
        } else {
            matcherQueryBuilder = QueryBuilders.boolQuery();
            matcherQueryBuilder.must(baseQuery);
            for (InlineFilter filter : this.filterList) {
                matcherQueryBuilder.filter(filter.build());
            }
        }
        return matcherQueryBuilder;
    }

    @Override
    public QueryBuilder buildWith(Matcher.BUILD_MODE ... buildModes) {
        boolean hasRankerBuild = false;
        QueryBuilder baseQuery = this.buildBase();
        if (baseQuery == null) {
            return null;
        }
        Object retQuery = null;
        BoolQueryBuilder matcherQueryBuilder = QueryBuilders.boolQuery();
        matcherQueryBuilder.must(baseQuery);
        for (Matcher.BUILD_MODE mode : buildModes) {
            if (mode.equals((Object)Matcher.BUILD_MODE.WITH_EXCLUDE)) {
                for (Matcher matcher : this.excludeMatchList) {
                    QueryBuilder tempBaseQuery = matcher.buildBaseWidthFilter();
                    if (tempBaseQuery == null) continue;
                    matcherQueryBuilder.mustNot(tempBaseQuery);
                }
            }
            if (mode.equals((Object)Matcher.BUILD_MODE.WITH_FILTER)) {
                for (InlineFilter filter : this.filterList) {
                    matcherQueryBuilder.filter(filter.build());
                }
            }
            if (!mode.equals((Object)Matcher.BUILD_MODE.WITH_RANKER) || this.scoreRanker == null) continue;
            hasRankerBuild = true;
        }
        retQuery = hasRankerBuild ? this.scoreRanker.build((QueryBuilder)matcherQueryBuilder) : matcherQueryBuilder;
        return retQuery;
    }

    @Override
    public String getQ() {
        return this.q;
    }

    @Override
    public AbstractMatcher boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    public AbstractMatcher globalBoost(float boost) {
        this.globalBoost = boost;
        return this;
    }

    public void prepareByConfig(MatcherConfig matcherConfig) {
        Object compositeFilter;
        InlineFilter inlineFilter;
        Class<?> clz;
        ArrayList<InlineFilter> combinedInlineFilterList;
        CombinedFilterConfig combinedFilterConfig;
        MatcherParams matcherParams;
        if (!StringUtils.isEmpty(matcherConfig.getIdName())) {
            this.matchName = matcherConfig.getIdName();
        }
        if (!StringUtils.isEmpty((matcherParams = matcherConfig.getMatcherParams()).getScoreExpress())) {
            FunctionScoreRanker scoreRanker = new FunctionScoreRanker(this.context);
            scoreRanker.expression(matcherParams.getScoreExpress());
            this.scoreRanker = scoreRanker;
        }
        if (!CollectionUtils.isEmpty(matcherConfig.getFilters())) {
            for (InlineFilterConfig inlineFilterConfig : matcherConfig.getFilters()) {
                try {
                    Class<?> clz2 = Class.forName(inlineFilterConfig.getFullClassName());
                    InlineFilter inlineFilter2 = (InlineFilter)clz2.newInstance();
                    inlineFilter2.prepareByConfig(inlineFilterConfig);
                    this.filterList.add(inlineFilter2);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (matcherConfig.getCombinedFilter() != null) {
            combinedFilterConfig = matcherConfig.getCombinedFilter();
            combinedInlineFilterList = new ArrayList<InlineFilter>();
            if (!CollectionUtils.isEmpty(combinedFilterConfig.getFilters())) {
                for (InlineFilterConfig inlineFilterConfig : combinedFilterConfig.getFilters()) {
                    try {
                        clz = Class.forName(inlineFilterConfig.getFullClassName());
                        inlineFilter = (InlineFilter)clz.newInstance();
                        if (inlineFilterConfig.isNeedContext()) {
                            inlineFilterConfig.setContext(this.context);
                        }
                        inlineFilter.prepareByConfig(inlineFilterConfig);
                        combinedInlineFilterList.add(inlineFilter);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (combinedInlineFilterList.size() == 1) {
                this.filterList.add((InlineFilter)combinedInlineFilterList.get(0));
            } else if (combinedInlineFilterList.size() > 1) {
                compositeFilter = new CompositeFilter(CompositeFilter.Func.valueOf(combinedFilterConfig.getOpFunc()), combinedInlineFilterList);
                this.filterList.add((InlineFilter)compositeFilter);
            }
        }
        if (matcherConfig.getClosableCombinedFilter() != null && !StringUtils.isEmpty(((ClosableCombinedFilterConfig)(combinedFilterConfig = matcherConfig.getClosableCombinedFilter())).getConditionParamName()) && Boolean.valueOf(this.context.getBizSysConfig().getOrDefault(((ClosableCombinedFilterConfig)combinedFilterConfig).getConditionParamName(), "false").toString()).booleanValue()) {
            combinedInlineFilterList = new ArrayList();
            if (!CollectionUtils.isEmpty(combinedFilterConfig.getFilters())) {
                for (InlineFilterConfig inlineFilterConfig : combinedFilterConfig.getFilters()) {
                    try {
                        clz = Class.forName(inlineFilterConfig.getFullClassName());
                        inlineFilter = (InlineFilter)clz.newInstance();
                        if (inlineFilterConfig.isNeedContext()) {
                            inlineFilterConfig.setContext(this.context);
                        }
                        inlineFilter.prepareByConfig(inlineFilterConfig);
                        combinedInlineFilterList.add(inlineFilter);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (combinedInlineFilterList.size() == 1) {
                this.filterList.add((InlineFilter)combinedInlineFilterList.get(0));
            } else if (combinedInlineFilterList.size() > 1) {
                compositeFilter = new CompositeFilter(CompositeFilter.Func.valueOf(combinedFilterConfig.getOpFunc()), combinedInlineFilterList);
                this.filterList.add((InlineFilter)compositeFilter);
            }
        }
    }

    public MatcherConfig getMatcherConfig() {
        return this.matcherConfig;
    }

    public void setContext(RequestContext context) {
        if (this.inited) {
            return;
        }
        if (this.context == null) {
            this.context = context;
            this.q = context.getQ().trim();
        }
    }

    protected String getExtParamsValue(String paramName) {
        Object paramValue = this.matcherConfig.getMatcherParams().getExtParams().get(paramName);
        if (paramValue != null && !StringUtils.isEmpty(paramValue.toString())) {
            return paramValue.toString();
        }
        return null;
    }

    protected void saveQuerySentenceMatchedFieldNameMapToContext() {
        HashMap<String, Set> querySentenceMatchedFieldNameMap = new HashMap<String, Set>();
        for (DefaultKeyValue defaultKeyValue : this.querySentenceMatchedFieldNamePairsList) {
            String matchedName = defaultKeyValue.getKey().toString();
            Set matchedFieldNameList = (Set)defaultKeyValue.getValue();
            Set savedMatchedFieldName = (Set)querySentenceMatchedFieldNameMap.get(matchedName);
            if (savedMatchedFieldName != null) {
                savedMatchedFieldName.addAll(matchedFieldNameList);
                continue;
            }
            querySentenceMatchedFieldNameMap.put(matchedName, matchedFieldNameList);
        }
        for (Map.Entry entry : querySentenceMatchedFieldNameMap.entrySet()) {
            this.context.putQuerySentenceMatchedFieldNamesMap((String)entry.getKey(), (Set)entry.getValue());
        }
    }

    protected void saveSentenceMatchFieldName(String sentenceMatchName, List<String> fieldNames) {
        DefaultKeyValue defaultKeyValue = new DefaultKeyValue((Object)sentenceMatchName, new HashSet<String>(fieldNames));
        this.querySentenceMatchedFieldNamePairsList.add(defaultKeyValue);
    }

    protected void saveSentenceMatchFieldName(String sentenceMatchName, String ... fieldNames) {
        DefaultKeyValue defaultKeyValue = new DefaultKeyValue((Object)sentenceMatchName, new HashSet(CollectionUtils.arrayToList(fieldNames)));
        this.querySentenceMatchedFieldNamePairsList.add(defaultKeyValue);
    }

    public void setMatcherFuzzyTermLetterLimit(int matcherFuzzyTermLetterLimit) {
        this.MATCHER_FUZZY_TERM_LETTER_LIMIT = matcherFuzzyTermLetterLimit;
    }

    public void setMatcherWordTermLetterLimit(int matcherWordTermLetterLimit) {
        this.MATCHER_WORD_TERM_LETTER_LIMIT = matcherWordTermLetterLimit;
    }

    public void setMatcherSentenceLetterLimit(int matcherSentenceLetterLimit) {
        this.MATCHER_SENTENCE_LETTER_LIMIT = matcherSentenceLetterLimit;
    }
}

