/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.matcher;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.facade.config.MatcherConfig;
import com.valor.common.search.engine.facade.config.MatcherParams;
import com.valor.common.search.engine.hunspell.EngineHunspell;
import com.valor.common.search.engine.matcher.AbstractFuzzyMatcher;
import com.valor.common.search.engine.matcher.Matcher;
import com.valor.common.search.engine.matcher.Term;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.SearchUtils;
import com.valor.common.search.engine.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.keyvalue.DefaultKeyValue;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.DisMaxQueryBuilder;
import org.elasticsearch.index.query.MatchPhrasePrefixQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RegexpQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;

public class GeneralFuzzyMatcher
extends AbstractFuzzyMatcher {
    public static final String DEFAULT_MATCH_NAME = "GeneralFuzzyMatcher";
    private final int fuzzyWordMinLength = 3;
    private final int compositeWordMinLength = 6;
    private final int prefixWordMinLength = 3;
    private final int SUGGEST_WORD_TERM_LIMIT = 5;
    Set<String> queryUsedFieldNameSet = new LinkedHashSet<String>();
    private List<Term> termList = new ArrayList<Term>();
    private List<Term> yearTermList = new ArrayList<Term>();
    private List<Term> aliasTermList = new ArrayList<Term>();
    private DISTANCE_TYPE distanceType = DISTANCE_TYPE.BY_WORD;
    private int distance = 1;
    private String wildCardMatchFieldName = "";
    private List<String> fuzzyMatchFieldNames = new ArrayList<String>();
    private String wordLettersMatchFieldName = "";
    private String allLettersMatchFieldName = "";
    private List<String> prefixMatchFieldName = new ArrayList<String>();
    private String fuzzyAnalyzer;
    private AtomicInteger matchsentenceCount = new AtomicInteger(0);
    private EngineHunspell engineHunspell;

    public GeneralFuzzyMatcher() {
        this.matchName = DEFAULT_MATCH_NAME;
    }

    public GeneralFuzzyMatcher(RequestContext context) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.q = context.getQ().trim();
        this.context = context;
        this.matchFieldName = context.getAttribure("fuzzy_full_text_field");
        this.init();
    }

    public GeneralFuzzyMatcher(RequestContext context, String matchFieldName) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.q = context.getQ().trim();
        this.context = context;
        this.matchFieldName = matchFieldName;
        this.init();
    }

    public GeneralFuzzyMatcher(RequestContext context, int distance, DISTANCE_TYPE distanceType) {
        this.matchName = DEFAULT_MATCH_NAME;
        if (distance < 0 || distance > 2) {
            throw new RuntimeException("Distance mut be 0,1,2");
        }
        this.q = context.getQ().trim();
        this.context = context;
        this.matchFieldName = context.getAttribure("fuzzy_full_text_field");
        this.distance = distance;
        this.distanceType = distanceType;
        this.init();
    }

    public GeneralFuzzyMatcher(RequestContext context, int distance, DISTANCE_TYPE distanceType, String matchFieldName) {
        this.matchName = DEFAULT_MATCH_NAME;
        if (distance < 0 || distance > 2) {
            throw new RuntimeException("Distance mut be 0,1,2");
        }
        this.q = context.getQ().trim();
        this.context = context;
        this.matchFieldName = matchFieldName;
        this.distance = distance;
        this.distanceType = distanceType;
        this.init();
    }

    public GeneralFuzzyMatcher(RequestContext context, int distance, DISTANCE_TYPE distanceType, String matchFieldName, String analyerName) {
        this.matchName = DEFAULT_MATCH_NAME;
        if (distance < 0 || distance > 2) {
            throw new RuntimeException("Distance mut be 0,1,2");
        }
        this.q = context.getQ().trim();
        this.context = context;
        this.matchFieldName = matchFieldName;
        this.distance = distance;
        this.distanceType = distanceType;
        this.analyzerName = analyerName;
        this.init();
    }

    private void init() {
        this.context.saveMatcheNameandMatcheFieldNamePair(this.matchName, this.matchFieldName);
        this.engineHunspell = new EngineHunspell();
        this.engineHunspell.init();
    }

    @Override
    public Matcher.MATCHER_TYPE getMatcherType() {
        return Matcher.MATCHER_TYPE.GENERAL_FUZZY;
    }

    @Override
    public GeneralFuzzyMatcher assembly() {
        this.termList.clear();
        this.q = this.context.getQ().trim().replaceAll("-", " ");
        if (this.distanceType.equals((Object)DISTANCE_TYPE.BY_WORD)) {
            String strQ;
            String aliasQ;
            Map<String, List<String>> yearTermMap;
            String[] newQs;
            for (String str : newQs = this.q.trim().split("([\\s\\p{Zs}])+")) {
                this.assemblyInternal(str);
            }
            if (this.matcherConfig.getYearFlag().booleanValue() && !CollectionUtils.isEmpty(yearTermMap = SearchUtils.splitByYear(this.q.trim())) && !CollectionUtils.isEmpty((Collection)yearTermMap.get("keywords")) && !CollectionUtils.isEmpty((Collection)yearTermMap.get("years"))) {
                String[] newQs4Year;
                List<String> keywords = yearTermMap.get("keywords");
                List<String> yearList = yearTermMap.get("years");
                String queryWordForYear = keywords.get(0);
                for (String str : newQs4Year = queryWordForYear.trim().split("([\\s\\p{Zs}])+")) {
                    Term yearTerm = this.assemblyInternalForYear(str);
                    yearTerm.setYearList(yearList);
                    this.yearTermList.add(yearTerm);
                }
            }
            if (this.yearTermList.size() <= 0 && newQs.length > 3 && !StringUtils.isEmpty(aliasQ = SearchUtils.delNumStr(strQ = SearchUtils.tryToMissWordByLooseRule(this.q), 3))) {
                String[] aliasQSplit = aliasQ.split("([\\s\\p{Zs}])+");
                if (!StringUtils.isEmpty(aliasQ) && aliasQSplit.length < this.q.split("([\\s\\p{Zs}])+").length) {
                    this.context.putAttribute("execute_partiword_alis_query", aliasQ);
                    for (String str : aliasQSplit) {
                        Term term = new Term(SearchUtils.takeStrByPrefixLimit(str, this.MATCHER_WORD_TERM_LETTER_LIMIT));
                        term.setFuzzyDistance(this.distance);
                        term.setMatchedFieldName(this.matchFieldName);
                        if (!StringUtils.isEmpty(this.analyzerName)) {
                            term.setAnalyzer(this.analyzerName);
                        }
                        this.aliasTermList.add(term);
                    }
                }
            }
        } else {
            this.assemblyInternal(this.q);
        }
        return this;
    }

    private Term assemblyInternalForYear(String str) {
        Term term = new Term(SearchUtils.takeStrByPrefixLimit(str, this.MATCHER_WORD_TERM_LETTER_LIMIT));
        term.setFuzzyDistance(this.distance);
        term.setMatchedFieldName(this.matchFieldName);
        if (!StringUtils.isEmpty(this.analyzerName)) {
            term.setAnalyzer(this.analyzerName);
        }
        return term;
    }

    private void assemblyInternal(String str) {
        Term term = new Term(SearchUtils.takeStrByPrefixLimit(str, this.MATCHER_WORD_TERM_LETTER_LIMIT));
        term.setFuzzyDistance(this.distance);
        term.setMatchedFieldName(this.matchFieldName);
        if (!StringUtils.isEmpty(this.analyzerName)) {
            term.setAnalyzer(this.analyzerName);
        }
        this.termList.add(term);
    }

    private void assemblyInternalBySentence(String str) {
        Term term = new Term(SearchUtils.takeStrByPrefixLimit(str, this.MATCHER_SENTENCE_LETTER_LIMIT));
        term.setFuzzyDistance(this.distance);
        term.setMatchedFieldName(this.matchFieldName);
        if (!StringUtils.isEmpty(this.analyzerName)) {
            term.setAnalyzer(this.analyzerName);
        }
        this.termList.add(term);
    }

    @Override
    public QueryBuilder buildBase() {
        this.matchsentenceCount = new AtomicInteger(0);
        String[] qs = this.q.replaceAll("-", " ").trim().split("([\\s\\p{Zs}])+");
        if (qs.length >= 6) {
            return null;
        }
        Object retVal = null;
        if (this.termList.size() > 3 && this.aliasTermList.size() > 3) {
            return null;
        }
        if (!SearchUtils.isLatin(this.q)) {
            return QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)this.matchFieldName, (Object)this.q).operator(Operator.OR).queryName("check_other_not_latin"));
        }
        if (this.distanceType == DISTANCE_TYPE.BY_WORD) {
            String[] newQs;
            ArrayList<Term> workTermList = new ArrayList<Term>(this.termList);
            this.sortTermListByKeywordLength(workTermList);
            this.sortTermListByKeywordLength(this.yearTermList);
            Object sentencePrefixQuery = null;
            this.getClass();
            BoolQueryBuilder fuzzyQueryBuilder = this.buildFuzzyQuery(workTermList, 3, this.fuzzyMatchFieldNames, this.matchFieldName, null);
            BoolQueryBuilder allLetterBuilder = this.buildCompositeKeywordFuzzyQuery(workTermList, 3, this.wordLettersMatchFieldName, this.matchFieldName);
            this.getClass();
            BoolQueryBuilder prefixQueryBuilder = this.buildPrefixFuzzyQuery(workTermList, 3, this.prefixMatchFieldName, this.matchFieldName);
            BoolQueryBuilder compositeTermToWordBuilder = this.buildCompositeToWordFuzzyQuery(workTermList, this.wordLettersMatchFieldName, this.matchFieldName);
            BoolQueryBuilder termInOtherWordBuilder = this.buildTermInOtherWordFuzzyQuery(workTermList, 4, this.wordLettersMatchFieldName, this.matchFieldName);
            this.getClass();
            BoolQueryBuilder fuzzyQueryBuilderForYear = this.buildFuzzyQuery(this.yearTermList, 3, this.fuzzyMatchFieldNames, this.matchFieldName, null);
            BoolQueryBuilder allLetterBuilderForYear = this.buildCompositeKeywordFuzzyQuery(this.yearTermList, 3, this.wordLettersMatchFieldName, this.matchFieldName);
            this.getClass();
            BoolQueryBuilder prefixQueryBuilderForYear = this.buildPrefixFuzzyQuery(this.yearTermList, 3, this.prefixMatchFieldName, this.matchFieldName);
            BoolQueryBuilder compositeTermToWordBuilderForYear = this.buildCompositeToWordFuzzyQuery(this.yearTermList, this.wordLettersMatchFieldName, this.matchFieldName);
            BoolQueryBuilder termInOtherWordBuilderForYear = this.buildTermInOtherWordFuzzyQuery(this.yearTermList, 4, this.wordLettersMatchFieldName, this.matchFieldName);
            BoolQueryBuilder compositeTermToWordBuilder4Alias = this.buildCompositeToWordFuzzyQuery(this.aliasTermList, this.wordLettersMatchFieldName, this.matchFieldName);
            this.getClass();
            BoolQueryBuilder fuzzyQueryBuilder4Alias = this.buildFuzzyQuery(this.aliasTermList, 3, this.fuzzyMatchFieldNames, this.matchFieldName, null);
            BoolQueryBuilder queryWordCompositeQuery = null;
            BoolQueryBuilder queryWordCompositeQueryForYear = null;
            BoolQueryBuilder finalQuery = QueryBuilders.boolQuery();
            BoolQueryBuilder finalQuery4Year = QueryBuilders.boolQuery();
            BoolQueryBuilder missWordFuzzyQueryBuilder = null;
            BoolQueryBuilder missWordFuzzyQueryBuilderForYear = null;
            if (SearchUtils.isLatin(this.q) && (newQs = SearchUtils.tryToMissWord(this.q).trim().split("([\\s\\p{Zs}])+")).length < workTermList.size()) {
                ArrayList<Term> missWordTermList = new ArrayList<Term>();
                for (String q : newQs) {
                    missWordTermList.add(new Term(q));
                }
                this.getClass();
                missWordFuzzyQueryBuilder = this.buildFuzzyQuery(missWordTermList, 3, this.fuzzyMatchFieldNames, this.matchFieldName, null);
                this.getClass();
                missWordFuzzyQueryBuilderForYear = this.buildFuzzyQuery(this.yearTermList, 3, this.fuzzyMatchFieldNames, this.matchFieldName, null);
            }
            queryWordCompositeQuery = this.buildQueryWordIsComposite(workTermList, this.fuzzyMatchFieldNames, this.matchFieldName, this.wordLettersMatchFieldName);
            queryWordCompositeQueryForYear = this.buildQueryWordIsComposite(this.yearTermList, this.fuzzyMatchFieldNames, this.matchFieldName, this.wordLettersMatchFieldName);
            HashSet<String> uniqueYearSet = new HashSet<String>();
            for (Term term : this.yearTermList) {
                uniqueYearSet.addAll(term.getYearList());
            }
            if (uniqueYearSet.size() > 0) {
                if (fuzzyQueryBuilderForYear != null) {
                    fuzzyQueryBuilderForYear = this.appendFilter2QueryBuilder(fuzzyQueryBuilderForYear, uniqueYearSet);
                }
                if (allLetterBuilderForYear != null) {
                    allLetterBuilderForYear = this.appendFilter2QueryBuilder(allLetterBuilderForYear, uniqueYearSet);
                }
                if (prefixQueryBuilderForYear != null) {
                    prefixQueryBuilderForYear = this.appendFilter2QueryBuilder(prefixQueryBuilderForYear, uniqueYearSet);
                }
                if (compositeTermToWordBuilderForYear != null) {
                    compositeTermToWordBuilderForYear = this.appendFilter2QueryBuilder(compositeTermToWordBuilderForYear, uniqueYearSet);
                }
                if (termInOtherWordBuilderForYear != null) {
                    termInOtherWordBuilderForYear = this.appendFilter2QueryBuilder(termInOtherWordBuilderForYear, uniqueYearSet);
                }
                if (missWordFuzzyQueryBuilderForYear != null) {
                    missWordFuzzyQueryBuilderForYear = this.appendFilter2QueryBuilder(missWordFuzzyQueryBuilderForYear, uniqueYearSet);
                }
                if (queryWordCompositeQueryForYear != null) {
                    queryWordCompositeQueryForYear = this.appendFilter2QueryBuilder(queryWordCompositeQueryForYear, uniqueYearSet);
                }
            }
            if (null != sentencePrefixQuery) {
                finalQuery.should((QueryBuilder)sentencePrefixQuery.boost(this.boost));
            }
            if (compositeTermToWordBuilder4Alias != null) {
                finalQuery.should((QueryBuilder)compositeTermToWordBuilder4Alias.boost(this.boost * 2.0f));
            }
            if (fuzzyQueryBuilder4Alias != null) {
                finalQuery.should((QueryBuilder)fuzzyQueryBuilder4Alias.boost(this.boost * 2.0f));
            }
            if (queryWordCompositeQuery != null) {
                finalQuery.should((QueryBuilder)queryWordCompositeQuery.boost(this.boost * 2.0f));
            }
            if (queryWordCompositeQueryForYear != null) {
                finalQuery.should((QueryBuilder)queryWordCompositeQueryForYear.boost(this.boost * 2.0f));
            }
            if (termInOtherWordBuilder != null) {
                termInOtherWordBuilder.boost(this.boost * 2.0f);
                finalQuery.should((QueryBuilder)termInOtherWordBuilder);
            }
            if (termInOtherWordBuilderForYear != null) {
                termInOtherWordBuilderForYear.boost(this.boost * 2.0f);
                finalQuery4Year.should((QueryBuilder)termInOtherWordBuilderForYear);
            }
            if (compositeTermToWordBuilder != null) {
                compositeTermToWordBuilder.boost(this.boost * 3.0f);
                finalQuery.should((QueryBuilder)compositeTermToWordBuilder);
            }
            if (compositeTermToWordBuilderForYear != null) {
                compositeTermToWordBuilderForYear.boost(this.boost * 3.0f);
                finalQuery4Year.should((QueryBuilder)compositeTermToWordBuilderForYear);
            }
            if (fuzzyQueryBuilder != null) {
                fuzzyQueryBuilder.boost(this.boost * 2.0f);
                finalQuery.should((QueryBuilder)fuzzyQueryBuilder);
            }
            if (fuzzyQueryBuilderForYear != null) {
                fuzzyQueryBuilderForYear.boost(this.boost * 2.0f);
                finalQuery4Year.should((QueryBuilder)fuzzyQueryBuilderForYear);
            }
            if (missWordFuzzyQueryBuilder != null) {
                missWordFuzzyQueryBuilder.boost(this.boost * 2.0f);
                finalQuery.should((QueryBuilder)missWordFuzzyQueryBuilder);
            }
            if (missWordFuzzyQueryBuilderForYear != null) {
                missWordFuzzyQueryBuilderForYear.boost(this.boost * 2.0f);
                finalQuery4Year.should((QueryBuilder)termInOtherWordBuilderForYear);
            }
            if (allLetterBuilder != null) {
                allLetterBuilder.boost(this.boost);
                finalQuery.should((QueryBuilder)allLetterBuilder);
            }
            if (allLetterBuilderForYear != null) {
                allLetterBuilderForYear.boost(this.boost);
                finalQuery4Year.should((QueryBuilder)allLetterBuilderForYear);
            }
            if (prefixQueryBuilder != null) {
                prefixQueryBuilder.boost(this.boost * 5.0f);
                finalQuery.should((QueryBuilder)prefixQueryBuilder);
            }
            if (prefixQueryBuilderForYear != null) {
                prefixQueryBuilderForYear.boost(this.boost * 5.0f);
                finalQuery4Year.should((QueryBuilder)prefixQueryBuilderForYear);
            }
            retVal = finalQuery.should().size() == 0 && finalQuery4Year.should().size() == 0 ? QueryBuilders.matchPhraseQuery((String)this.matchFieldName, (Object)SearchUtils.takeStrByPrefixLimit(((Term)workTermList.get(0)).getTermStr(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT)) : (finalQuery.should().size() == 0 ? finalQuery4Year : (finalQuery4Year.should().size() == 0 ? finalQuery : QueryBuilders.boolQuery().should((QueryBuilder)finalQuery).should((QueryBuilder)finalQuery4Year)));
        } else {
            MatchQueryBuilder query = null;
            String termStr = SearchUtils.takeStrByPrefixLimit(this.termList.get(0).getTermStr(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT);
            query = QueryBuilders.matchQuery((String)this.termList.get(0).getMatchedFieldName(), (Object)termStr).fuzziness((Object)Fuzziness.fromEdits((int)this.distance));
            if (!StringUtils.isEmpty(this.termList.get(0).getAnalyzer())) {
                query.analyzer(this.termList.get(0).getAnalyzer());
            }
            if (!StringUtils.isEmpty(this.wordLettersMatchFieldName)) {
                BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)this.wordLettersMatchFieldName, (Object)termStr).analyzer(this.getFuzzyAnalyzerName(termStr.length()))).should((QueryBuilder)query).boost(this.boost);
                retVal = boolQueryBuilder;
                this.queryUsedFieldNameSet.add(this.wordLettersMatchFieldName);
            } else {
                retVal = query;
            }
            this.queryUsedFieldNameSet.add(this.termList.get(0).getMatchedFieldName());
        }
        this.saveQuerySentenceMatchedFieldNameMapToContext();
        this.context.putQueryMatcherMatchedFieldNameMap(this.matchName, CollectionUtils.arrayToList(this.queryUsedFieldNameSet.toArray()));
        return retVal.boost(this.globalBoost);
    }

    private BoolQueryBuilder appendFilter2QueryBuilder(BoolQueryBuilder queryBuilder, Collection<String> yearList) {
        ArrayList<TermQueryBuilder> filterQueryBuilderList = new ArrayList<TermQueryBuilder>();
        BoolQueryBuilder finalQueryBuilder = null;
        for (String string : yearList) {
            filterQueryBuilderList.add(QueryBuilders.termQuery((String)this.matcherConfig.getYearFieldName(), (String)string));
        }
        if (filterQueryBuilderList.size() > 1) {
            BoolQueryBuilder filterQueryBuilder = QueryBuilders.boolQuery();
            for (QueryBuilder queryBuilder2 : filterQueryBuilderList) {
                filterQueryBuilder.should(queryBuilder2);
            }
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.filter((QueryBuilder)filterQueryBuilder).must((QueryBuilder)queryBuilder.minimumShouldMatch(1));
            finalQueryBuilder = boolQueryBuilder;
        } else {
            BoolQueryBuilder mainQueruBuilder = QueryBuilders.boolQuery();
            mainQueruBuilder.filter((QueryBuilder)filterQueryBuilderList.get(0)).must((QueryBuilder)queryBuilder.minimumShouldMatch(1));
            finalQueryBuilder = mainQueruBuilder;
        }
        return finalQueryBuilder;
    }

    private void sortTermListByKeywordLength(List<Term> workTermList) {
        workTermList.sort((a, b) -> {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            if (a.getTermStr().length() == b.getTermStr().length()) {
                return 0;
            }
            if (a.getTermStr().length() > b.getTermStr().length()) {
                return -1;
            }
            return 1;
        });
    }

    /*
     * WARNING - void declaration
     */
    private BoolQueryBuilder buildQueryWordIsComposite(List<Term> workTermList, List<String> fuzzyMatchFieldName, String normalMatchFieldName, String wordLettersMatchFieldName) {
        if (CollectionUtils.isEmpty(workTermList)) {
            return null;
        }
        if (!SearchUtils.isLatin(this.q)) {
            return null;
        }
        BoolQueryBuilder oneWordCompositeQuery = null;
        if (workTermList.size() == 1) {
            if (workTermList.get(0).getTermStr().length() < 6) {
                return null;
            }
            List<BoolQueryBuilder> oneWordCompositeQueryList = this.buildForOneWordCompositeImpl(workTermList.get(0).getTermStr(), this.fuzzyMatchFieldNames, this.matchFieldName, this.wordLettersMatchFieldName);
            if (!CollectionUtils.isEmpty(oneWordCompositeQueryList)) {
                oneWordCompositeQuery = QueryBuilders.boolQuery();
                for (BoolQueryBuilder queryBuilder : oneWordCompositeQueryList) {
                    oneWordCompositeQuery.should((QueryBuilder)queryBuilder);
                }
                ((BoolQueryBuilder)oneWordCompositeQuery.boost(this.boost * 5.0f)).queryName("check_QueryWordIsComposite");
                LinkedHashSet<String> querySentenceMatchedFieldNames = new LinkedHashSet<String>();
                querySentenceMatchedFieldNames.addAll(fuzzyMatchFieldName);
                querySentenceMatchedFieldNames.add(normalMatchFieldName);
                querySentenceMatchedFieldNames.add(wordLettersMatchFieldName);
                DefaultKeyValue querySentenceAndMatchFieldNamePair = new DefaultKeyValue((Object)"check_QueryWordIsComposite", querySentenceMatchedFieldNames);
                this.querySentenceMatchedFieldNamePairsList.add(querySentenceAndMatchFieldNamePair);
            }
        }
        if (workTermList.size() == 2 || workTermList.size() == 3) {
            int maxLenTermIndex = -1;
            int termLen = 6;
            for (int i = 0; i < workTermList.size(); ++i) {
                if (workTermList.get(i).getTermStr().length() < termLen) continue;
                termLen = workTermList.get(i).getTermStr().length();
                maxLenTermIndex = i;
            }
            String termStr = "";
            ArrayList<String> helpTermStrList = new ArrayList<String>();
            for (int i = 0; i < workTermList.size(); ++i) {
                if (i == maxLenTermIndex || workTermList.get(i).getTermStr().length() <= 2) continue;
                helpTermStrList.add(workTermList.get(i).getTermStr().toLowerCase());
            }
            if (maxLenTermIndex < 0) {
                return null;
            }
            if (!SearchUtils.isLatin(workTermList.get(maxLenTermIndex).getTermStr())) {
                return null;
            }
            List<BoolQueryBuilder> oneWordCompositeQueryList = this.buildForOneWordCompositeImpl(workTermList.get(maxLenTermIndex).getTermStr(), this.fuzzyMatchFieldNames, this.matchFieldName, this.wordLettersMatchFieldName);
            if (!CollectionUtils.isEmpty(oneWordCompositeQueryList)) {
                oneWordCompositeQuery = QueryBuilders.boolQuery();
                for (BoolQueryBuilder queryBuilder : oneWordCompositeQueryList) {
                    oneWordCompositeQuery.should((QueryBuilder)queryBuilder);
                }
                oneWordCompositeQuery.boost(this.boost * 5.0f);
                LinkedHashSet<String> querySentenceMatchedFieldNames = new LinkedHashSet<String>();
                ArrayList<void> helpTermQueryList = new ArrayList<void>();
                if (!CollectionUtils.isEmpty(helpTermStrList)) {
                    for (String helpTermStr : helpTermStrList) {
                        void var15_20;
                        Object var15_21 = null;
                        if (helpTermStr.length() < 6) {
                            MatchPhraseQueryBuilder matchPhraseQueryBuilder = QueryBuilders.matchPhraseQuery((String)this.matchFieldName, (Object)helpTermStr);
                        } else {
                            MatchQueryBuilder matchQueryBuilder = QueryBuilders.matchQuery((String)this.matchFieldName, (Object)SearchUtils.takeStrByPrefixLimit(helpTermStr, this.MATCHER_FUZZY_TERM_LETTER_LIMIT)).fuzziness((Object)"auto");
                        }
                        helpTermQueryList.add(var15_20);
                        querySentenceMatchedFieldNames.add(this.matchFieldName);
                    }
                    if (helpTermQueryList.size() == 0) {
                        oneWordCompositeQuery = QueryBuilders.boolQuery().must((QueryBuilder)oneWordCompositeQuery).must((QueryBuilder)helpTermQueryList.get(0));
                    } else if (helpTermQueryList.size() > 0) {
                        BoolQueryBuilder multiHelpTermQueryList = QueryBuilders.boolQuery();
                        for (QueryBuilder queryBuilder : helpTermQueryList) {
                            multiHelpTermQueryList.should(queryBuilder).minimumShouldMatch(1);
                        }
                        oneWordCompositeQuery = QueryBuilders.boolQuery().must((QueryBuilder)oneWordCompositeQuery).must((QueryBuilder)multiHelpTermQueryList);
                    }
                }
                querySentenceMatchedFieldNames.addAll(fuzzyMatchFieldName);
                querySentenceMatchedFieldNames.add(normalMatchFieldName);
                querySentenceMatchedFieldNames.add(wordLettersMatchFieldName);
                oneWordCompositeQuery.queryName("check_QueryWordIsComposite");
                DefaultKeyValue querySentenceAndMatchFieldNamePair = new DefaultKeyValue((Object)"check_QueryWordIsComposite", querySentenceMatchedFieldNames);
                this.querySentenceMatchedFieldNamePairsList.add(querySentenceAndMatchFieldNamePair);
            }
        }
        return oneWordCompositeQuery;
    }

    private List<BoolQueryBuilder> buildForOneWordCompositeImpl(String word, List<String> fuzzyMatchFieldName, String normalMatchFieldName, String wordLettersMatchFieldName) {
        if (!SearchUtils.isLatin(word)) {
            return null;
        }
        List<List<String>> suggestWords = this.engineHunspell.suggestByForceSplit(SearchUtils.takeStrByPrefixLimit(word, this.MATCHER_FUZZY_TERM_LETTER_LIMIT));
        if (!CollectionUtils.isEmpty(suggestWords) && suggestWords.size() > 5) {
            suggestWords = suggestWords.subList(0, 5);
        }
        if (CollectionUtils.isEmpty(suggestWords)) {
            return null;
        }
        ArrayList<BoolQueryBuilder> preparedQueryBuilderList = new ArrayList<BoolQueryBuilder>();
        int c = 0;
        for (List<String> splitWords : suggestWords) {
            if (splitWords.isEmpty()) continue;
            BoolQueryBuilder firstWordQuery = this.prepareOneWordQuery(splitWords.get(0), fuzzyMatchFieldName, normalMatchFieldName, wordLettersMatchFieldName);
            BoolQueryBuilder secondWordQuery = this.prepareOneWordQuery(splitWords.get(1), fuzzyMatchFieldName, normalMatchFieldName, wordLettersMatchFieldName);
            if (firstWordQuery == null || secondWordQuery == null) continue;
            BoolQueryBuilder curWordQueryBuilder = QueryBuilders.boolQuery();
            curWordQueryBuilder.must((QueryBuilder)firstWordQuery).must((QueryBuilder)secondWordQuery).queryName("fh_" + c);
            LinkedHashSet<String> querySentenceMatchedFieldNames = new LinkedHashSet<String>();
            querySentenceMatchedFieldNames.addAll(fuzzyMatchFieldName);
            querySentenceMatchedFieldNames.add(normalMatchFieldName);
            querySentenceMatchedFieldNames.add(wordLettersMatchFieldName);
            ++c;
            preparedQueryBuilderList.add(curWordQueryBuilder);
        }
        return preparedQueryBuilderList;
    }

    private BoolQueryBuilder prepareOneWordQuery(String word, List<String> fuzzyMatchFieldName, String normalMatchFieldName, String wordLettersMatchFieldName) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        boolean canFuzzy = false;
        if (word.length() < 2) {
            return null;
        }
        if (word.length() > 3) {
            canFuzzy = true;
        }
        this.queryUsedFieldNameSet.add(normalMatchFieldName);
        queryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)normalMatchFieldName, (Object)word));
        queryBuilder.should((QueryBuilder)QueryBuilders.prefixQuery((String)normalMatchFieldName, (String)word));
        queryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)wordLettersMatchFieldName, (Object)word).analyzer("whitespace"));
        this.queryUsedFieldNameSet.add(wordLettersMatchFieldName);
        if (canFuzzy) {
            for (String fieldName : fuzzyMatchFieldName) {
                queryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)fieldName, (Object)word));
                this.queryUsedFieldNameSet.add(fieldName);
            }
        }
        return queryBuilder;
    }

    /*
     * WARNING - void declaration
     */
    private BoolQueryBuilder buildFuzzyQuery(List<Term> workTermList, int wordLengthLimit, List<String> fuzzyMatchFieldName, String normalMatchFieldName, String curAnalyzerName) {
        BoolQueryBuilder mainQueryBuilder = null;
        if (CollectionUtils.isEmpty(workTermList)) {
            return null;
        }
        if (!SearchUtils.isLatin(this.q)) {
            return QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)this.matchFieldName, (Object)this.q).operator(Operator.OR).queryName("check_other_not_latin"));
        }
        for (int i = 0; i < Math.min(3, workTermList.size()); ++i) {
            void var13_18;
            Term fuzzyTerm = workTermList.get(i);
            if (workTermList.size() > 1 && workTermList.get(i).getTermStr().trim().length() <= wordLengthLimit || workTermList.size() == 1 && workTermList.get(i).getTermStr().trim().length() < 5) continue;
            BoolQueryBuilder subFuzzyQuery = QueryBuilders.boolQuery();
            MatchQueryBuilder queryItem = null;
            ArrayList<MatchQueryBuilder> queryBuilderList = new ArrayList<MatchQueryBuilder>();
            for (String string : fuzzyMatchFieldName) {
                String fuzzyTermStr = SearchUtils.takeStrByPrefixLimit(fuzzyTerm.getTermStr(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT);
                queryItem = (MatchQueryBuilder)((MatchQueryBuilder)QueryBuilders.matchQuery((String)string, (Object)fuzzyTermStr).fuzziness((Object)Fuzziness.fromEdits((int)this.distance)).boost(this.boost * 2.0f)).queryName("fuzzy_1");
                if (!StringUtils.isEmpty(curAnalyzerName)) {
                    queryItem.analyzer(curAnalyzerName);
                }
                queryBuilderList.add(queryItem);
                if (fuzzyTerm.getTermStr().length() >= 7) {
                    queryItem = (MatchQueryBuilder)((MatchQueryBuilder)QueryBuilders.matchQuery((String)string, (Object)fuzzyTermStr).fuzziness((Object)Fuzziness.fromEdits((int)(this.distance + 1))).prefixLength(1).boost(this.boost)).queryName("fuzzy_prefix_2");
                    queryItem.analyzer("whitespace");
                    queryBuilderList.add(queryItem);
                } else {
                    queryItem = (MatchQueryBuilder)((MatchQueryBuilder)QueryBuilders.matchQuery((String)string, (Object)fuzzyTermStr).fuzziness((Object)1).prefixLength(1).boost(this.boost * 3.0f)).queryName("fuzzy_prefix_1_");
                    queryItem.analyzer("whitespace");
                    queryBuilderList.add(queryItem);
                }
                if (fuzzyTerm.getTermStr().length() < 7) continue;
                queryItem = (MatchQueryBuilder)((MatchQueryBuilder)QueryBuilders.matchQuery((String)string, (Object)fuzzyTermStr).fuzziness((Object)Fuzziness.fromEdits((int)(this.distance + 1))).boost(this.boost * 0.5f)).queryName("fuzzy_2");
                if (!StringUtils.isEmpty(curAnalyzerName)) {
                    queryItem.analyzer(curAnalyzerName);
                }
                queryBuilderList.add(queryItem);
            }
            DisMaxQueryBuilder fuzzyQueryMatch = null;
            for (QueryBuilder queryBuilder : queryBuilderList) {
                if (queryBuilder == null) continue;
                if (fuzzyQueryMatch == null) {
                    fuzzyQueryMatch = QueryBuilders.disMaxQuery();
                }
                fuzzyQueryMatch.add(queryBuilder);
            }
            this.queryUsedFieldNameSet.addAll(fuzzyMatchFieldName);
            subFuzzyQuery.must(fuzzyQueryMatch);
            boolean bl = false;
            while (var13_18 < workTermList.size()) {
                Term term = workTermList.get((int)var13_18);
                if (!term.equals(fuzzyTerm)) {
                    MatchQueryBuilder normalQueryItem = QueryBuilders.matchQuery((String)normalMatchFieldName, (Object)term.getTermStr());
                    if (!StringUtils.isEmpty(curAnalyzerName)) {
                        queryItem.analyzer(curAnalyzerName);
                    }
                    subFuzzyQuery.must((QueryBuilder)normalQueryItem);
                    this.queryUsedFieldNameSet.add(normalMatchFieldName);
                }
                ++var13_18;
            }
            if (mainQueryBuilder == null) {
                mainQueryBuilder = QueryBuilders.boolQuery();
            }
            String string = "check_fuzzy_query_" + this.matchsentenceCount.incrementAndGet();
            mainQueryBuilder.should((QueryBuilder)subFuzzyQuery.queryName(string)).queryName("fuzzy_query");
            LinkedHashSet<String> querySentenceMatchedFieldNames = new LinkedHashSet<String>();
            querySentenceMatchedFieldNames.addAll(fuzzyMatchFieldName);
            querySentenceMatchedFieldNames.add(normalMatchFieldName);
            DefaultKeyValue querySentenceAndMatchFieldNamePair = new DefaultKeyValue((Object)string, querySentenceMatchedFieldNames);
            this.querySentenceMatchedFieldNamePairsList.add(querySentenceAndMatchFieldNamePair);
        }
        return mainQueryBuilder;
    }

    private BoolQueryBuilder buildCompositeKeywordFuzzyQuery(List<Term> workTermList, int wordLengthLimit, String fuzzyMatchFieldName, String normalMatchFieldName) {
        if (CollectionUtils.isEmpty(workTermList)) {
            return null;
        }
        if (!SearchUtils.isLatin(this.q)) {
            return null;
        }
        BoolQueryBuilder mainQueryBuilder = null;
        for (int i = 0; i < Math.min(3, workTermList.size()); ++i) {
            Term fuzzyTerm = workTermList.get(i);
            if (workTermList.get(i).getTermStr().trim().length() < wordLengthLimit) continue;
            if (!SearchUtils.isLatin(fuzzyTerm.getTermStr())) {
                return null;
            }
            BoolQueryBuilder subFuzzyQuery = QueryBuilders.boolQuery();
            MatchQueryBuilder queryItem = QueryBuilders.matchQuery((String)fuzzyMatchFieldName, (Object)SearchUtils.takeStrByPrefixLimit(fuzzyTerm.getTermStr(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT));
            queryItem.operator(Operator.AND);
            this.queryUsedFieldNameSet.add(fuzzyMatchFieldName);
            subFuzzyQuery.must((QueryBuilder)queryItem);
            for (int j = 0; j < workTermList.size(); ++j) {
                Term term = workTermList.get(j);
                if (term.equals(fuzzyTerm)) continue;
                MatchQueryBuilder normalQueryItem = QueryBuilders.matchQuery((String)normalMatchFieldName, (Object)term.getTermStr()).analyzer("whitespace");
                subFuzzyQuery.must((QueryBuilder)normalQueryItem);
                this.queryUsedFieldNameSet.add(normalMatchFieldName);
            }
            if (mainQueryBuilder == null) {
                mainQueryBuilder = QueryBuilders.boolQuery();
            }
            mainQueryBuilder.should((QueryBuilder)subFuzzyQuery.queryName("check_composite_fuzzy")).queryName("composite_fuzzy");
        }
        LinkedHashSet<String> querySentenceMatchedFieldNames = new LinkedHashSet<String>();
        querySentenceMatchedFieldNames.add(fuzzyMatchFieldName);
        querySentenceMatchedFieldNames.add(normalMatchFieldName);
        DefaultKeyValue querySentenceAndMatchFieldNamePair = new DefaultKeyValue((Object)"check_composite_fuzzy", querySentenceMatchedFieldNames);
        this.querySentenceMatchedFieldNamePairsList.add(querySentenceAndMatchFieldNamePair);
        return mainQueryBuilder;
    }

    private BoolQueryBuilder buildTermInOtherWordFuzzyQuery(List<Term> workTermList, int wordLengthLimit, String fuzzyMatchFieldName, String normalMatchFieldName) {
        if (CollectionUtils.isEmpty(workTermList)) {
            return null;
        }
        if (!SearchUtils.isLatin(this.q)) {
            return null;
        }
        BoolQueryBuilder mainQueryBuilder = null;
        for (int i = 0; i < Math.min(3, workTermList.size()); ++i) {
            Term fuzzyTerm = workTermList.get(i);
            if (workTermList.get(i).getTermStr().trim().length() < wordLengthLimit) continue;
            if (!SearchUtils.isLatin(fuzzyTerm.getTermStr())) {
                return null;
            }
            BoolQueryBuilder subFuzzyQuery = QueryBuilders.boolQuery();
            MatchQueryBuilder queryItem = QueryBuilders.matchQuery((String)fuzzyMatchFieldName, (Object)SearchUtils.takeStrByPrefixLimit(fuzzyTerm.getTermStr(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT));
            queryItem.operator(Operator.AND);
            this.queryUsedFieldNameSet.add(fuzzyMatchFieldName);
            subFuzzyQuery.must((QueryBuilder)queryItem);
            for (int j = 0; j < workTermList.size(); ++j) {
                Term term = workTermList.get(j);
                if (term.equals(fuzzyTerm)) continue;
                MatchQueryBuilder normalQueryItem = QueryBuilders.matchQuery((String)normalMatchFieldName, (Object)SearchUtils.takeStrByPrefixLimit(term.getTermStr(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT)).analyzer("whitespace");
                subFuzzyQuery.must((QueryBuilder)normalQueryItem);
                this.queryUsedFieldNameSet.add(normalMatchFieldName);
            }
            if (mainQueryBuilder == null) {
                mainQueryBuilder = QueryBuilders.boolQuery();
            }
            mainQueryBuilder.should((QueryBuilder)subFuzzyQuery.queryName("check_TermInOtherWord_fuzzy")).queryName("TermInOtherWord_fuzzy");
        }
        LinkedHashSet<String> querySentenceMatchedFieldNames = new LinkedHashSet<String>();
        querySentenceMatchedFieldNames.add(fuzzyMatchFieldName);
        querySentenceMatchedFieldNames.add(normalMatchFieldName);
        DefaultKeyValue querySentenceAndMatchFieldNamePair = new DefaultKeyValue((Object)"check_TermInOtherWord_fuzzy", querySentenceMatchedFieldNames);
        this.querySentenceMatchedFieldNamePairsList.add(querySentenceAndMatchFieldNamePair);
        return mainQueryBuilder;
    }

    private List<Map<String, List<Term>>> genCompositedWordTerm(List<Term> workTermList) {
        ArrayList<Term> helpTermList = new ArrayList<Term>();
        for (int i = 0; i < Math.min(3, workTermList.size()); ++i) {
            helpTermList.add(workTermList.get(i));
        }
        ArrayList<Map<String, List<Term>>> sortedTermMapList = new ArrayList<Map<String, List<Term>>>();
        if (helpTermList.size() == 3) {
            for (int index = 0; index < 3; ++index) {
                Term mainTerm = (Term)helpTermList.get(index);
                ArrayList<Term> mainTermList = new ArrayList<Term>();
                mainTermList.add(mainTerm);
                ArrayList otherTermList = new ArrayList();
                for (int i = 0; i < helpTermList.size(); ++i) {
                    if (i == index) continue;
                    otherTermList.add(helpTermList.get(i));
                }
                ArrayList<Term> fuzzyTermList = new ArrayList<Term>();
                fuzzyTermList.add(new Term(((Term)otherTermList.get(0)).getTermStr() + ((Term)otherTermList.get(1)).getTermStr()));
                fuzzyTermList.add(new Term(((Term)otherTermList.get(1)).getTermStr() + ((Term)otherTermList.get(0)).getTermStr()));
                HashMap<String, ArrayList<Term>> workTermMap = new HashMap<String, ArrayList<Term>>();
                workTermMap.put("mainTerm", mainTermList);
                workTermMap.put("fuzzyTerm", fuzzyTermList);
                sortedTermMapList.add(workTermMap);
            }
        } else if (helpTermList.size() == 2) {
            ArrayList<Term> fuzzyTermList = new ArrayList<Term>();
            fuzzyTermList.add(new Term(((Term)helpTermList.get(0)).getTermStr() + ((Term)helpTermList.get(1)).getTermStr()));
            fuzzyTermList.add(new Term(((Term)helpTermList.get(1)).getTermStr() + ((Term)helpTermList.get(0)).getTermStr()));
            HashMap<String, ArrayList<Term>> workTermMap = new HashMap<String, ArrayList<Term>>();
            workTermMap.put("fuzzyTerm", fuzzyTermList);
            sortedTermMapList.add(workTermMap);
        }
        return sortedTermMapList;
    }

    private List<Map<String, List<Term>>> tryMoreCompositedWordTerm(List<Term> workTermList) {
        ArrayList<Term> helpTermList = new ArrayList<Term>();
        for (int i = 0; i < Math.min(3, workTermList.size()); ++i) {
            helpTermList.add(workTermList.get(i));
        }
        ArrayList<Map<String, List<Term>>> sortedTermMapList = new ArrayList<Map<String, List<Term>>>();
        if (helpTermList.size() == 3) {
            ArrayList mainTermList;
            HashMap workTermMap;
            ArrayList<Term> fuzzyTermList;
            if (((Term)helpTermList.get(0)).getTermStr().toLowerCase().indexOf(((Term)helpTermList.get(1)).getTermStr().toLowerCase()) == -1 && ((Term)helpTermList.get(1)).getTermStr().toLowerCase().indexOf(((Term)helpTermList.get(0)).getTermStr().toLowerCase()) == -1) {
                fuzzyTermList = new ArrayList<Term>();
                fuzzyTermList.add(new Term(((Term)helpTermList.get(0)).getTermStr()));
                fuzzyTermList.add(new Term(((Term)helpTermList.get(1)).getTermStr()));
                workTermMap = new HashMap();
                workTermMap.put("fuzzyTerm", fuzzyTermList);
                sortedTermMapList.add(workTermMap);
                if (((Term)helpTermList.get(2)).getTermStr().toLowerCase().indexOf(((Term)helpTermList.get(0)).getTermStr().toLowerCase()) == -1 && ((Term)helpTermList.get(2)).getTermStr().toLowerCase().indexOf(((Term)helpTermList.get(1)).getTermStr().toLowerCase()) == -1 && ((Term)helpTermList.get(1)).getTermStr().toLowerCase().indexOf(((Term)helpTermList.get(2)).getTermStr().toLowerCase()) == -1 && ((Term)helpTermList.get(0)).getTermStr().toLowerCase().indexOf(((Term)helpTermList.get(2)).getTermStr().toLowerCase()) == -1) {
                    fuzzyTermList.add(new Term(((Term)helpTermList.get(2)).getTermStr()));
                } else {
                    mainTermList = new ArrayList();
                    mainTermList.add(helpTermList.get(2));
                    workTermMap.put("mainTerm", mainTermList);
                }
            }
            if (((Term)helpTermList.get(0)).getTermStr().toLowerCase().indexOf(((Term)helpTermList.get(2)).getTermStr().toLowerCase()) == -1 || ((Term)helpTermList.get(2)).getTermStr().toLowerCase().indexOf(((Term)helpTermList.get(0)).getTermStr().toLowerCase()) == -1) {
                fuzzyTermList = new ArrayList();
                fuzzyTermList.add(new Term(((Term)helpTermList.get(0)).getTermStr()));
                fuzzyTermList.add(new Term(((Term)helpTermList.get(2)).getTermStr()));
                workTermMap = new HashMap();
                workTermMap.put("fuzzyTerm", fuzzyTermList);
                sortedTermMapList.add(workTermMap);
                if (((Term)helpTermList.get(1)).getTermStr().toLowerCase().indexOf(((Term)helpTermList.get(0)).getTermStr().toLowerCase()) == -1 && ((Term)helpTermList.get(1)).getTermStr().toLowerCase().indexOf(((Term)helpTermList.get(2)).getTermStr().toLowerCase()) == -1 && ((Term)helpTermList.get(2)).getTermStr().toLowerCase().indexOf(((Term)helpTermList.get(1)).getTermStr().toLowerCase()) == -1 && ((Term)helpTermList.get(0)).getTermStr().toLowerCase().indexOf(((Term)helpTermList.get(1)).getTermStr().toLowerCase()) == -1) {
                    fuzzyTermList.add(new Term(((Term)helpTermList.get(1)).getTermStr()));
                } else {
                    mainTermList = new ArrayList();
                    mainTermList.add(helpTermList.get(1));
                    workTermMap.put("mainTerm", mainTermList);
                }
            }
            if (((Term)helpTermList.get(1)).getTermStr().toLowerCase().indexOf(((Term)helpTermList.get(2)).getTermStr().toLowerCase()) == -1 || ((Term)helpTermList.get(2)).getTermStr().toLowerCase().indexOf(((Term)helpTermList.get(1)).getTermStr().toLowerCase()) == -1) {
                fuzzyTermList = new ArrayList();
                fuzzyTermList.add(new Term(((Term)helpTermList.get(2)).getTermStr()));
                fuzzyTermList.add(new Term(((Term)helpTermList.get(1)).getTermStr()));
                workTermMap = new HashMap();
                workTermMap.put("fuzzyTerm", fuzzyTermList);
                sortedTermMapList.add(workTermMap);
                if (((Term)helpTermList.get(0)).getTermStr().toLowerCase().indexOf(((Term)helpTermList.get(1)).getTermStr().toLowerCase()) == -1 && ((Term)helpTermList.get(0)).getTermStr().toLowerCase().indexOf(((Term)helpTermList.get(2)).getTermStr().toLowerCase()) == -1 && ((Term)helpTermList.get(1)).getTermStr().toLowerCase().indexOf(((Term)helpTermList.get(0)).getTermStr().toLowerCase()) == -1 && ((Term)helpTermList.get(2)).getTermStr().toLowerCase().indexOf(((Term)helpTermList.get(0)).getTermStr().toLowerCase()) == -1) {
                    fuzzyTermList.add(new Term(((Term)helpTermList.get(0)).getTermStr()));
                } else {
                    mainTermList = new ArrayList();
                    mainTermList.add(helpTermList.get(0));
                    workTermMap.put("mainTerm", mainTermList);
                }
            }
        } else if (helpTermList.size() == 2 && (((Term)helpTermList.get(0)).getTermStr().toLowerCase().indexOf(((Term)helpTermList.get(1)).getTermStr().toLowerCase()) == -1 || ((Term)helpTermList.get(1)).getTermStr().toLowerCase().indexOf(((Term)helpTermList.get(0)).getTermStr().toLowerCase()) == -1)) {
            ArrayList<Term> fuzzyTermList = new ArrayList<Term>();
            fuzzyTermList.add(new Term(((Term)helpTermList.get(0)).getTermStr()));
            fuzzyTermList.add(new Term(((Term)helpTermList.get(1)).getTermStr()));
            HashMap<String, ArrayList<Term>> workTermMap = new HashMap<String, ArrayList<Term>>();
            workTermMap.put("fuzzyTerm", fuzzyTermList);
            sortedTermMapList.add(workTermMap);
        }
        return sortedTermMapList;
    }

    @Deprecated
    private BoolQueryBuilder buildCompositeToWordFuzzyQueryOld(List<Term> workTermList, String fuzzyMatchFieldName, String normalMatchFieldName) {
        BoolQueryBuilder mainQueryBuilder = null;
        List<Map<String, List<Term>>> sortedTermList = this.genCompositedWordTerm(workTermList);
        for (Map<String, List<Term>> termMap : sortedTermList) {
            List<Term> mainTermList = termMap.get("mainTerm");
            List<Term> fuzzyTermList = termMap.get("fuzzyTerm");
            MatchQueryBuilder mainQuery = null;
            if (!CollectionUtils.isEmpty(mainTermList)) {
                mainQuery = QueryBuilders.matchQuery((String)normalMatchFieldName, (Object)mainTermList.get(0).getTermStr()).analyzer("whitespace");
            }
            ArrayList<MatchQueryBuilder> fuzzyQueryList = new ArrayList<MatchQueryBuilder>();
            for (Term term : fuzzyTermList) {
                MatchQueryBuilder fuzzyQuery = QueryBuilders.matchQuery((String)fuzzyMatchFieldName, (Object)term.getTermStr()).analyzer(this.getFuzzyAnalyzerName(term.getTermStr().length())).operator(Operator.AND);
                fuzzyQueryList.add(fuzzyQuery);
            }
            QueryBuilder finalFuzzyQuery = null;
            if (fuzzyQueryList.size() > 1) {
                BoolQueryBuilder boolFinalFuzzyQuery = QueryBuilders.boolQuery();
                for (QueryBuilder queryBuilder : fuzzyQueryList) {
                    boolFinalFuzzyQuery.should(queryBuilder);
                }
                finalFuzzyQuery = boolFinalFuzzyQuery;
            } else {
                finalFuzzyQuery = fuzzyQueryList.size() == 1 ? (QueryBuilder)fuzzyQueryList.get(0) : null;
            }
            QueryBuilder finalQuery = null;
            if (mainQuery != null) {
                if (finalFuzzyQuery != null) {
                    BoolQueryBuilder boolFinalQuery = QueryBuilders.boolQuery();
                    boolFinalQuery.must(finalFuzzyQuery).must((QueryBuilder)mainQuery);
                    finalQuery = boolFinalQuery;
                } else {
                    finalQuery = null;
                }
            } else {
                finalQuery = finalFuzzyQuery;
            }
            if (finalQuery == null) continue;
            if (mainQueryBuilder == null) {
                mainQueryBuilder = QueryBuilders.boolQuery();
            }
            mainQueryBuilder.should(finalQuery);
        }
        if (mainQueryBuilder != null) {
            mainQueryBuilder.queryName("CompositeToWordFuzzy");
        }
        return mainQueryBuilder;
    }

    private BoolQueryBuilder buildCompositeToWordFuzzyQuery(List<Term> workTermList, String fuzzyMatchFieldName, String normalMatchFieldName) {
        if (CollectionUtils.isEmpty(workTermList)) {
            return null;
        }
        if (!SearchUtils.isLatin(this.q)) {
            return null;
        }
        BoolQueryBuilder mainQueryBuilder = null;
        List<Map<String, List<Term>>> sortedTermList = this.tryMoreCompositedWordTerm(workTermList);
        for (Map<String, List<Term>> termMap : sortedTermList) {
            List<Term> mainTermList = termMap.get("mainTerm");
            List<Term> fuzzyTermList = termMap.get("fuzzyTerm");
            MatchQueryBuilder mainQuery = null;
            if (!CollectionUtils.isEmpty(mainTermList)) {
                mainQuery = QueryBuilders.matchQuery((String)normalMatchFieldName, (Object)SearchUtils.takeStrByPrefixLimit(mainTermList.get(0).getTermStr().toLowerCase(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT)).analyzer("whitespace");
            }
            ArrayList<MatchQueryBuilder> fuzzyQueryList = new ArrayList<MatchQueryBuilder>();
            for (Term fuzzyTerm : fuzzyTermList) {
                if (!SearchUtils.isLatin(fuzzyTerm.getTermStr())) {
                    return null;
                }
                MatchQueryBuilder fuzzyQuery = QueryBuilders.matchQuery((String)fuzzyMatchFieldName, (Object)SearchUtils.takeStrByPrefixLimit(fuzzyTerm.getTermStr().toLowerCase(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT)).analyzer("whitespace");
                fuzzyQueryList.add(fuzzyQuery);
            }
            QueryBuilder finalFuzzyQuery = null;
            if (fuzzyQueryList.size() > 1) {
                BoolQueryBuilder boolFinalFuzzyQuery = QueryBuilders.boolQuery();
                for (QueryBuilder queryBuilder : fuzzyQueryList) {
                    boolFinalFuzzyQuery.must(queryBuilder);
                }
                finalFuzzyQuery = boolFinalFuzzyQuery;
            } else {
                finalFuzzyQuery = fuzzyQueryList.size() == 1 ? (QueryBuilder)fuzzyQueryList.get(0) : null;
            }
            QueryBuilder finalQuery = null;
            if (mainQuery != null) {
                if (finalFuzzyQuery != null) {
                    BoolQueryBuilder boolFinalQuery = QueryBuilders.boolQuery();
                    boolFinalQuery.must(finalFuzzyQuery).must((QueryBuilder)mainQuery);
                    finalQuery = boolFinalQuery;
                } else {
                    finalQuery = mainQuery;
                }
            } else {
                finalQuery = finalFuzzyQuery;
            }
            if (finalQuery == null) continue;
            if (mainQueryBuilder == null) {
                mainQueryBuilder = QueryBuilders.boolQuery();
            }
            mainQueryBuilder.should(finalQuery.queryName("check_CompositeToWordFuzzy"));
        }
        if (mainQueryBuilder != null) {
            mainQueryBuilder.queryName("CompositeToWordFuzzy");
        }
        LinkedHashSet<String> querySentenceMatchedFieldNames = new LinkedHashSet<String>();
        querySentenceMatchedFieldNames.add(fuzzyMatchFieldName);
        querySentenceMatchedFieldNames.add(normalMatchFieldName);
        DefaultKeyValue querySentenceAndMatchFieldNamePair = new DefaultKeyValue((Object)"check_CompositeToWordFuzzy", querySentenceMatchedFieldNames);
        this.querySentenceMatchedFieldNamePairsList.add(querySentenceAndMatchFieldNamePair);
        return mainQueryBuilder;
    }

    @Deprecated
    private BoolQueryBuilder buildPrefixFuzzyQueryNew(List<String> fuzzyMatchFieldName, String normalMatchFieldName) {
        BoolQueryBuilder mainQueryBuilder = QueryBuilders.boolQuery();
        String[] newQs = this.q.trim().split("([\\s\\p{Zs}])+");
        Term prefixTerm = new Term(newQs[newQs.length - 1]);
        ArrayList<Term> matchTermList = new ArrayList<Term>();
        if (newQs.length > 1) {
            for (int index = 0; index < newQs.length - 1; ++index) {
                matchTermList.add(new Term(newQs[index]));
            }
        }
        for (String curMatchFieldName : fuzzyMatchFieldName) {
            BoolQueryBuilder subMatchQuery = QueryBuilders.boolQuery();
            BoolQueryBuilder wildCardQuery = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.wildcardQuery((String)curMatchFieldName, (String)(this.q.toLowerCase() + "*")).boost(this.boost * 5.0f)).should((QueryBuilder)QueryBuilders.wildcardQuery((String)normalMatchFieldName, (String)(prefixTerm.getTermStr().toLowerCase() + "*")));
            String matchKeyWord = "";
            StringBuffer sb = new StringBuffer();
            for (Term term : matchTermList) {
                sb.append(" ").append(term.getTermStr());
            }
            matchKeyWord = sb.toString().trim();
            MatchPhraseQueryBuilder matchPhraseQuery = (MatchPhraseQueryBuilder)QueryBuilders.matchPhraseQuery((String)curMatchFieldName, (Object)matchKeyWord).slop(20).boost(this.boost * 10.0f);
            subMatchQuery.must((QueryBuilder)wildCardQuery).must((QueryBuilder)matchPhraseQuery);
            mainQueryBuilder.should((QueryBuilder)subMatchQuery);
            this.queryUsedFieldNameSet.add(curMatchFieldName);
        }
        mainQueryBuilder.queryName("prefixFuzzy");
        return mainQueryBuilder;
    }

    private BoolQueryBuilder buildPrefixFuzzyQuery(List<Term> workTermList, int wordLengthLimit, List<String> fuzzyMatchFieldName, String normalMatchFieldName) {
        if (CollectionUtils.isEmpty(workTermList)) {
            return null;
        }
        if (!SearchUtils.isLatin(this.q)) {
            return null;
        }
        BoolQueryBuilder mainQueryBuilder = null;
        int doubleWordLengthLimit = 2 * wordLengthLimit;
        BoolQueryBuilder sentencePrefixQuery = null;
        if (workTermList.size() > 1) {
            sentencePrefixQuery = QueryBuilders.boolQuery();
            StringBuffer buffer = new StringBuffer();
            for (int index = 0; index < workTermList.size() - 1; ++index) {
                buffer.append(SearchUtils.takeStrByPrefixLimit(workTermList.get(index).getTermStr(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT)).append(" ");
            }
            StringBuffer prefixStrBuffer = new StringBuffer();
            for (int index = 0; index < workTermList.size(); ++index) {
                prefixStrBuffer.append(SearchUtils.takeStrByPrefixLimit(workTermList.get(index).getTermStr(), this.MATCHER_FUZZY_TERM_LETTER_LIMIT));
            }
            MatchQueryBuilder prefixWordQuery = QueryBuilders.matchQuery((String)this.allLettersMatchFieldName, (Object)prefixStrBuffer.toString().toLowerCase()).analyzer("whitespace").operator(Operator.AND);
            MatchPhraseQueryBuilder matchQuery = QueryBuilders.matchPhraseQuery((String)normalMatchFieldName, (Object)buffer.toString().toString());
            sentencePrefixQuery.must((QueryBuilder)prefixWordQuery).must(matchQuery.boost(2.0f)).queryName("check_prefix_sentence_wc");
            LinkedHashSet<String> querySentenceMatchedFieldNames = new LinkedHashSet<String>();
            querySentenceMatchedFieldNames.add(this.allLettersMatchFieldName);
            querySentenceMatchedFieldNames.add(normalMatchFieldName);
            DefaultKeyValue querySentenceAndMatchFieldNamePair = new DefaultKeyValue((Object)"check_prefix_sentence_wc", querySentenceMatchedFieldNames);
            this.querySentenceMatchedFieldNamePairsList.add(querySentenceAndMatchFieldNamePair);
        }
        for (int i = 0; i < Math.min(3, workTermList.size()); ++i) {
            Term fuzzyTerm = workTermList.get(i);
            if (workTermList.get(i).getTermStr().trim().length() < wordLengthLimit) continue;
            if (!SearchUtils.isLatin(fuzzyTerm.getTermStr())) {
                return null;
            }
            BoolQueryBuilder subFuzzyQuery = QueryBuilders.boolQuery();
            String opTermStr = SearchUtils.delPunctuationChars(fuzzyTerm.getTermStr());
            char[] regExpChars = new char[Math.min(5, opTermStr.length())];
            Arrays.fill(regExpChars, '?');
            StringBuffer stringBuffer = new StringBuffer();
            for (int k = 1; k <= Math.min(5, opTermStr.length()); ++k) {
                stringBuffer.append(new String(Arrays.copyOf(regExpChars, k))).append("|");
            }
            stringBuffer.append("?");
            String regExpPatten = opTermStr + "(" + stringBuffer + ")";
            BoolQueryBuilder queryItem = QueryBuilders.boolQuery();
            for (String fieldName : fuzzyMatchFieldName) {
                RegexpQueryBuilder subQueryItem = QueryBuilders.regexpQuery((String)fieldName, (String)regExpPatten);
                queryItem.should((QueryBuilder)subQueryItem);
            }
            this.queryUsedFieldNameSet.addAll(fuzzyMatchFieldName);
            subFuzzyQuery.must((QueryBuilder)queryItem);
            for (int j = 0; j < workTermList.size(); ++j) {
                Term term = workTermList.get(j);
                if (term.equals(fuzzyTerm)) continue;
                MatchQueryBuilder normalQueryItem = QueryBuilders.matchQuery((String)normalMatchFieldName, (Object)term.getTermStr()).analyzer("whitespace");
                subFuzzyQuery.must((QueryBuilder)normalQueryItem);
                this.queryUsedFieldNameSet.add(normalMatchFieldName);
            }
            if (mainQueryBuilder == null) {
                mainQueryBuilder = QueryBuilders.boolQuery();
            }
            mainQueryBuilder.should((QueryBuilder)subFuzzyQuery.queryName("check_prefixFuzzy_sentence_" + i));
            LinkedHashSet<String> querySentenceMatchedFieldNames = new LinkedHashSet<String>();
            querySentenceMatchedFieldNames.addAll(fuzzyMatchFieldName);
            querySentenceMatchedFieldNames.add(normalMatchFieldName);
            DefaultKeyValue querySentenceAndMatchFieldNamePair = new DefaultKeyValue((Object)"check_prefixFuzzy_sentence", querySentenceMatchedFieldNames);
            this.querySentenceMatchedFieldNamePairsList.add(querySentenceAndMatchFieldNamePair);
        }
        if (mainQueryBuilder != null && sentencePrefixQuery != null) {
            mainQueryBuilder.should((QueryBuilder)sentencePrefixQuery).queryName("prefixFuzzy_sentence");
        }
        return mainQueryBuilder;
    }

    private BoolQueryBuilder buildSentencePrefixMatch(String matchField, String queryWord) {
        String[] newQs = this.q.trim().split("([\\s\\p{Zs}])+");
        BoolQueryBuilder sentencePrefixQuery = null;
        if (newQs.length > 1) {
            sentencePrefixQuery = QueryBuilders.boolQuery();
            StringBuffer buffer = new StringBuffer();
            for (int index = 0; index < newQs.length - 1; ++index) {
                buffer.append(newQs[index]).append(" ");
            }
            StringBuffer prefixStrBuffer = new StringBuffer();
            for (int index = 0; index < newQs.length; ++index) {
                prefixStrBuffer.append(newQs[index]);
            }
            MatchPhrasePrefixQueryBuilder prefixWordQuery = QueryBuilders.matchPhrasePrefixQuery((String)this.allLettersMatchFieldName, (Object)prefixStrBuffer.toString().toLowerCase()).analyzer("whitespace");
            MatchPhraseQueryBuilder matchQuery = QueryBuilders.matchPhraseQuery((String)matchField, (Object)buffer.toString());
            sentencePrefixQuery.must((QueryBuilder)prefixWordQuery).must(matchQuery.boost(1.0f)).queryName("check_entry_prefix_sentence");
            LinkedHashSet<String> querySentenceMatchedFieldNames = new LinkedHashSet<String>();
            querySentenceMatchedFieldNames.add(matchField);
            querySentenceMatchedFieldNames.add(this.allLettersMatchFieldName);
            DefaultKeyValue querySentenceAndMatchFieldNamePair = new DefaultKeyValue((Object)"check_entry_prefix_sentence", querySentenceMatchedFieldNames);
            this.querySentenceMatchedFieldNamePairsList.add(querySentenceAndMatchFieldNamePair);
        }
        return sentencePrefixQuery;
    }

    @Override
    public GeneralFuzzyMatcher boost(float boost) {
        this.boost = boost;
        return this;
    }

    public GeneralFuzzyMatcher analyzer(String analyzerName) {
        this.analyzerName = analyzerName;
        return this;
    }

    @Override
    public void prepareByConfig(MatcherConfig config) {
        String strPrefixFieldName;
        this.matcherConfig = config;
        MatcherParams matcherParams = this.matcherConfig.getMatcherParams();
        this.matchFieldName = !StringUtils.isEmpty(matcherParams.getMatchFieldName()) ? matcherParams.getMatchFieldName() : this.context.getAttribure("fuzzy_full_text_field");
        this.distanceType = DISTANCE_TYPE.valueOf(matcherParams.getExtParams().get("distanceType").toString());
        this.distance = Integer.parseInt(this.matcherConfig.getMatcherParams().getExtParams().get("distance").toString());
        this.boost = this.matcherConfig.getMatcherParams().getBoost();
        this.globalBoost = this.matcherConfig.getMatcherParams().getGlobalBoost();
        this.wordLettersMatchFieldName = this.getExtParamsValue("wordLettersMatchFieldName");
        if (StringUtils.isEmpty(this.wordLettersMatchFieldName)) {
            this.wordLettersMatchFieldName = this.matchFieldName;
        }
        this.allLettersMatchFieldName = this.getExtParamsValue("allLettersMatchFieldName");
        if (StringUtils.isEmpty(this.wordLettersMatchFieldName)) {
            this.wordLettersMatchFieldName = this.matchFieldName;
        }
        this.wildCardMatchFieldName = this.getExtParamsValue("wildCardMatchFieldName");
        if (StringUtils.isEmpty(this.wildCardMatchFieldName)) {
            this.wildCardMatchFieldName = this.matchFieldName;
        }
        this.fuzzyAnalyzer = this.getExtParamsValue("fuzzyAnalyzerName");
        this.fuzzyAnalyzer = this.getExtParamsValue("fuzzyAnalyzerName");
        String strFuzzyFieldName = this.getExtParamsValue("fuzzyMatchFieldName");
        if (!StringUtils.isEmpty(strFuzzyFieldName)) {
            for (String fieldName : strFuzzyFieldName.split(",")) {
                this.fuzzyMatchFieldNames.add(fieldName);
            }
        }
        if (this.fuzzyMatchFieldNames.isEmpty()) {
            this.fuzzyMatchFieldNames.add(this.matchFieldName);
        }
        if (!StringUtils.isEmpty(strPrefixFieldName = this.getExtParamsValue("prefixMatchFieldName"))) {
            for (String fieldName : strPrefixFieldName.split(",")) {
                this.prefixMatchFieldName.add(fieldName);
            }
        }
        if (this.prefixMatchFieldName.isEmpty()) {
            this.prefixMatchFieldName.add(this.matchFieldName);
        }
        if (!StringUtils.isEmpty(this.matcherConfig.getIdName())) {
            this.matchName = this.matcherConfig.getIdName();
        }
        super.prepareByConfig(this.matcherConfig);
        this.init();
    }

    private List<String> splitUnLatinTermStr(String str) {
        List<String> strList = new ArrayList<String>();
        for (int i = 0; i < str.length() - 2; i += 4) {
            strList.add(str.substring(i, Math.min(str.length(), i + 4)));
        }
        String lastItem = (String)strList.get(strList.size() - 1);
        if (lastItem.length() < 3 && strList.size() > 1) {
            strList.set(strList.size() - 2, (String)strList.get(strList.size() - 1) + lastItem);
            strList = strList.subList(0, strList.size() - 1);
        }
        return strList;
    }

    public static enum DISTANCE_TYPE {
        BY_WORD(1),
        BY_SENTENCE(2);

        private int type;

        private DISTANCE_TYPE(int type) {
            this.type = type;
        }
    }
}

