/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.matcher;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.matcher.AbstractMatcher;
import com.valor.common.search.engine.matcher.Matcher;
import com.valor.common.search.engine.util.SearchUtils;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class GeneralQueryMatcher
extends AbstractMatcher {
    private CMD queryCMD = CMD.MATCH;
    public static final String DEFAULT_MATCH_NAME = "GeneralQueryMatcher";

    public GeneralQueryMatcher(RequestContext context, String matchFieldName, String word) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.matchFieldName = matchFieldName;
        this.q = SearchUtils.rebuildQ(word);
        this.context = context;
        this.init();
    }

    public GeneralQueryMatcher(RequestContext context, String matchFieldName, String word, CMD cmd) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.matchFieldName = matchFieldName;
        this.q = SearchUtils.rebuildQ(word);
        this.context = context;
        this.queryCMD = cmd;
        this.init();
    }

    private void init() {
        this.context.saveMatcheNameandMatcheFieldNamePair(this.matchName, this.matchFieldName);
    }

    @Override
    public Matcher.MATCHER_TYPE getMatcherType() {
        return Matcher.MATCHER_TYPE.GENERAL_TERM;
    }

    @Override
    public Matcher assembly() {
        return this;
    }

    @Override
    public QueryBuilder buildBase() {
        if (this.queryCMD.ordinal() == CMD.PREFIX.ordinal()) {
            return QueryBuilders.prefixQuery((String)this.matchFieldName, (String)this.q.toLowerCase());
        }
        return QueryBuilders.matchQuery((String)this.matchFieldName, (Object)this.q);
    }

    public static enum CMD {
        MATCH(0),
        PREFIX(1);

        private int index;

        private CMD(int i) {
            this.index = i;
        }
    }
}

