/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.ranker;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.facade.config.InLineScoreRankerConfig;
import com.valor.common.search.engine.ranker.AbstractInlineScoreRanker;
import com.valor.common.search.engine.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilders;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;

public class WeightScoreRankerAbstract
extends AbstractInlineScoreRanker {
    private static final String DEFAULT_WEIGHT_FIELD_NAME = "weight";
    private RequestContext context;
    private String weightFieldName;
    private float scale = 1.0f;
    private CombineFunction boostMode = CombineFunction.REPLACE;
    private String expression;
    private Map<String, Object> scoreExpressParams = new HashMap<String, Object>();
    private float minScore = 1.0E-5f;

    public WeightScoreRankerAbstract() {
    }

    public WeightScoreRankerAbstract(RequestContext context, String weightFieldName) {
        this.context = context;
        this.weightFieldName = weightFieldName;
        this.scale = 1.0f;
    }

    public WeightScoreRankerAbstract(RequestContext context) {
        this.context = context;
        this.weightFieldName = DEFAULT_WEIGHT_FIELD_NAME;
        this.scale = 1.0f;
    }

    public WeightScoreRankerAbstract expression(String expression) {
        this.expression = expression;
        return this;
    }

    public WeightScoreRankerAbstract scale(float scale) {
        this.scale = scale;
        return this;
    }

    public WeightScoreRankerAbstract boostMode(CombineFunction boostMode) {
        this.boostMode = boostMode;
        return this;
    }

    @Override
    public QueryBuilder build(QueryBuilder wrapQueryBuilder) {
        String funcStr = this.expression;
        if (!StringUtils.isEmpty(funcStr)) {
            int index;
            StringBuilder builder;
            String[] strList;
            if (funcStr.indexOf("#scale") != -1) {
                strList = funcStr.trim().split("#scale");
                builder = new StringBuilder();
                for (index = 0; index < strList.length - 1; ++index) {
                    builder.append(strList[index]).append(this.scale);
                }
                funcStr = builder.append(strList[strList.length - 1]).toString();
            }
            if (funcStr.indexOf("#weightFieldName") != -1) {
                strList = funcStr.trim().split("#weightFieldName");
                builder = new StringBuilder();
                for (index = 0; index < strList.length - 1; ++index) {
                    builder.append(strList[index]).append(this.weightFieldName);
                }
                funcStr = builder.append(strList[strList.length - 1]).toString();
            }
        } else {
            funcStr = "_score*" + this.scale + "*(doc['" + this.weightFieldName + "'].value+100)/100";
        }
        Script script = new Script(ScriptType.INLINE, "painless", funcStr, this.scoreExpressParams);
        FunctionScoreQueryBuilder query = QueryBuilders.functionScoreQuery((QueryBuilder)wrapQueryBuilder, (ScoreFunctionBuilder)ScoreFunctionBuilders.scriptFunction((Script)script)).boostMode(this.boostMode).setMinScore(this.minScore);
        return query;
    }

    @Override
    public void prepareByConfig(InLineScoreRankerConfig config) {
        this.inLineRankerConfig = config;
        Map<String, Object> params = config.getParams();
        this.expression = params.getOrDefault("scoreExpress", "").toString();
        this.weightFieldName = params.getOrDefault("weightFieldName", DEFAULT_WEIGHT_FIELD_NAME).toString();
        this.scale = Float.parseFloat(params.getOrDefault("scale", "1.0").toString());
        Object objParams = params.get("scoreExpressParams");
        if (objParams instanceof List) {
            List expressParams = (List)objParams;
            this.scoreExpressParams.clear();
            for (Map item : expressParams) {
                this.scoreExpressParams.put(item.get("name").toString(), item.get("value"));
            }
        }
        this.inited = true;
    }
}

