/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.buz.common;

import com.valor.common.search.engine.util.StringUtils;
import org.elasticsearch.client.RestHighLevelClient;

public class ConfigParams {
    private String indexName;
    private String mainIndexFieldName = "title";
    private String scoreExpress;
    private float weightThreshold = 4.0f;
    private String timeFilterFieldName;
    private boolean enableTimeFilter = false;
    private RestHighLevelClient restHighLevelClient;

    public ConfigParams(String indexName, String mainIndexFieldName, String scoreExpress, float weightThreshold, String timeFilterFieldName, boolean enableTimeFilter, RestHighLevelClient client) {
        if (StringUtils.isEmpty(indexName)) {
            throw new RuntimeException("IndeName must not empty");
        }
        if (StringUtils.isEmpty(mainIndexFieldName)) {
            throw new RuntimeException("mainIndexFieldName must not empty");
        }
        this.indexName = indexName;
        this.mainIndexFieldName = mainIndexFieldName;
        this.scoreExpress = scoreExpress;
        this.weightThreshold = weightThreshold;
        this.timeFilterFieldName = timeFilterFieldName;
        this.enableTimeFilter = enableTimeFilter;
        this.restHighLevelClient = client;
    }

    public ConfigParams(String indexName, RestHighLevelClient client) {
        if (StringUtils.isEmpty(indexName)) {
            throw new RuntimeException("IndeName must not empty");
        }
        this.indexName = indexName;
        this.restHighLevelClient = client;
    }

    public ConfigParams(String indexName, String scoreExpress, float weightThreshold, String timeFilterFieldName, boolean enableTimeFilter, RestHighLevelClient client) {
        if (StringUtils.isEmpty(indexName)) {
            throw new RuntimeException("IndeName must not empty");
        }
        this.indexName = indexName;
        this.scoreExpress = scoreExpress;
        this.weightThreshold = weightThreshold;
        this.timeFilterFieldName = timeFilterFieldName;
        this.enableTimeFilter = enableTimeFilter;
        this.restHighLevelClient = client;
    }

    public RestHighLevelClient getRestHighLevelClient() {
        return this.restHighLevelClient;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getMainIndexFieldName() {
        return this.mainIndexFieldName;
    }

    public String getScoreExpress() {
        return this.scoreExpress;
    }

    public float getWeightThreshold() {
        return this.weightThreshold;
    }

    public String getTimeFilterFieldName() {
        return this.timeFilterFieldName;
    }

    public boolean isEnableTimeFilter() {
        return this.enableTimeFilter;
    }
}

