/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.filter;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.facade.config.InlineFilterConfig;
import com.valor.common.search.engine.filter.FilterFuncEnum;
import com.valor.common.search.engine.filter.GeneralFilter;
import com.valor.common.search.engine.filter.InlineFilterBase;
import java.util.ArrayList;
import java.util.List;

public class GeneralFilterBase
implements InlineFilterBase {
    protected RequestContext context;
    protected String mainFilterFieldName;
    protected List<FilterCondition> filterConditionList = new ArrayList<FilterCondition>();
    protected InlineFilterConfig inLintFilterConfig = null;
    protected String filterName;

    public GeneralFilterBase() {
    }

    public GeneralFilterBase(String filterFieldName, String filterValue, FilterFuncEnum filterType, RequestContext context) {
        if (filterType.equals((Object)FilterFuncEnum.RANGE)) {
            throw new RuntimeException("Cant not construct  Range filter  ,pls choose another constructor to create it");
        }
        this.context = context;
        this.mainFilterFieldName = filterFieldName;
        this.filterConditionList.add(new FilterCondition(filterFieldName, filterValue, "", "", filterType));
    }

    public GeneralFilterBase(String filterFieldName, String filterValue, FilterFuncEnum filterType) {
        if (filterType.equals((Object)FilterFuncEnum.RANGE)) {
            throw new RuntimeException("Cant not construct  Range filter  ,pls choose another constructor to create it");
        }
        this.mainFilterFieldName = filterFieldName;
        this.filterConditionList.add(new FilterCondition(filterFieldName, filterValue, "", "", filterType));
    }

    public GeneralFilterBase(String filterFieldName, String topValue, String buttomValue, RequestContext context) {
        this.context = context;
        this.mainFilterFieldName = filterFieldName;
        this.filterConditionList.add(new FilterCondition(filterFieldName, "", topValue, buttomValue, FilterFuncEnum.RANGE));
    }

    public GeneralFilterBase(String filterFieldName, String topValue, String buttomValue) {
        this.mainFilterFieldName = filterFieldName;
        this.filterConditionList.add(new FilterCondition(filterFieldName, "", topValue, buttomValue, FilterFuncEnum.RANGE));
    }

    public GeneralFilterBase(String filterFieldName, String[] values) {
        this.mainFilterFieldName = filterFieldName;
        this.filterConditionList.add(new FilterCondition(filterFieldName, values, FilterFuncEnum.EQUAL));
    }

    public GeneralFilterBase(String filterFieldName, String[] values, FilterFuncEnum filterType) {
        this.mainFilterFieldName = filterFieldName;
        this.filterConditionList.add(new FilterCondition(filterFieldName, values, filterType));
    }

    public GeneralFilterBase append(String value, FilterFuncEnum filterType) {
        if (filterType.equals((Object)FilterFuncEnum.RANGE)) {
            throw new RuntimeException("bad filterFuncNum");
        }
        this.filterConditionList.add(new FilterCondition(this.mainFilterFieldName, value, "", "", filterType));
        return this;
    }

    public GeneralFilterBase append(String[] values) {
        this.filterConditionList.add(new FilterCondition(this.mainFilterFieldName, values, FilterFuncEnum.EQUAL));
        return this;
    }

    public GeneralFilterBase appendRange(String topValue, String buttomValue) {
        this.filterConditionList.add(new FilterCondition(this.mainFilterFieldName, "", topValue, buttomValue, FilterFuncEnum.RANGE));
        return this;
    }

    public GeneralFilterBase append(String filterFieldName, String value, FilterFuncEnum filterType) {
        if (filterType.equals((Object)FilterFuncEnum.RANGE)) {
            throw new RuntimeException("bad filterFuncNum");
        }
        this.filterConditionList.add(new FilterCondition(filterFieldName, value, "", "", filterType));
        return this;
    }

    public GeneralFilterBase append(String filterFieldName, String[] values) {
        this.filterConditionList.add(new FilterCondition(filterFieldName, values, FilterFuncEnum.EQUAL));
        return this;
    }

    public GeneralFilterBase appendRange(String filterFieldName, String topValue, String buttomValue) {
        this.filterConditionList.add(new FilterCondition(filterFieldName, "", topValue, buttomValue, FilterFuncEnum.RANGE));
        return this;
    }

    @Override
    public String getFilterName() {
        return this.filterName;
    }

    @Override
    public String getInlineFilterClassName() {
        return "com.valor.common.search.engine.filter.GeneralFilter";
    }

    public RequestContext getContext() {
        return this.context;
    }

    public String getMainFilterFieldName() {
        return this.mainFilterFieldName;
    }

    public List<FilterCondition> getFilterConditionList() {
        return this.filterConditionList;
    }

    public InlineFilterConfig getInLintFilterConfig() {
        return this.inLintFilterConfig;
    }

    public static void main(String[] args) {
        GeneralFilterBase generalFilterBase = new GeneralFilterBase();
        generalFilterBase.filterName = "dddd";
        GeneralFilter generalFilter = (GeneralFilter)generalFilterBase.convertToInlineFilter();
        generalFilter.append("title", new String[]{"ff"});
        System.out.println(generalFilter.build());
    }

    public static class FilterCondition {
        protected String filterFieldName;
        protected String filterValue;
        protected FilterFuncEnum filterType;
        protected String topValue;
        protected String buttomValue;
        protected String[] values;
        protected boolean multiValueFilter = false;

        protected FilterCondition(String filterFieldName, String filterValue, String topValue, String buttomValue, FilterFuncEnum filterType) {
            this.buttomValue = buttomValue;
            this.filterType = filterType;
            this.topValue = topValue;
            this.filterValue = filterValue;
            this.filterFieldName = filterFieldName;
        }

        protected FilterCondition(String filterFieldName, String[] values, FilterFuncEnum filterType) {
            this.filterType = filterType;
            this.multiValueFilter = true;
            this.values = new String[values.length];
            System.arraycopy(values, 0, this.values, 0, values.length);
            this.filterFieldName = filterFieldName;
        }
    }
}

