/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.matcher;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.facade.config.MatcherConfig;
import com.valor.common.search.engine.facade.config.MatcherParams;
import com.valor.common.search.engine.matcher.AbstractMatcher;
import com.valor.common.search.engine.matcher.Matcher;
import com.valor.common.search.engine.matcher.Term;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.SearchUtils;
import com.valor.common.search.engine.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchPhrasePrefixQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;

public class EntiretyMatcher
extends AbstractMatcher {
    public static final String DEFAULT_MATCH_NAME = "EntiretyMatcher";
    public static final float DEFAULT_BOOST = 5.0f;
    Set<String> queryUsedFieldNameSet = new HashSet<String>();
    private List<Map<String, Object>> enhanceFieldNames = new ArrayList<Map<String, Object>>();
    private MacthType matchType;
    private Term term;
    private Term termForYear;
    private List<Term> aliasTermList = new ArrayList<Term>();
    private AtomicInteger matchsentenceCount = new AtomicInteger(0);
    private List<Term> aliasForYearTermList = new ArrayList<Term>();

    public EntiretyMatcher() {
        this.matchName = DEFAULT_MATCH_NAME;
        this.globalBoost = 5.0f;
    }

    public EntiretyMatcher(RequestContext context, MacthType macthType) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.globalBoost = 5.0f;
        this.q = context.getQ();
        this.context = context;
        this.matchType = macthType;
        this.matchFieldName = context.getAttribure("normal_full_text_field");
        this.init();
    }

    public EntiretyMatcher(RequestContext context, MacthType macthType, String matchName) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.globalBoost = 5.0f;
        this.q = context.getQ();
        this.context = context;
        this.matchType = macthType;
        this.matchName = matchName;
        this.matchFieldName = context.getAttribure("normal_full_text_field");
        this.init();
    }

    public EntiretyMatcher(RequestContext context, String matchFieldName, String analyzerName, MacthType macthType) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.globalBoost = 5.0f;
        this.q = context.getQ().trim();
        this.context = context;
        this.matchType = macthType;
        this.matchFieldName = matchFieldName;
        this.analyzerName = analyzerName;
        this.init();
    }

    public EntiretyMatcher(String analyzerName, RequestContext context, MacthType macthType) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.globalBoost = 5.0f;
        this.q = context.getQ().trim();
        this.context = context;
        this.matchType = macthType;
        this.analyzerName = analyzerName;
        this.matchFieldName = context.getAttribure("normal_full_text_field");
        this.init();
    }

    public EntiretyMatcher(String analyzerName, String matchFieldName, RequestContext context, MacthType macthType) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.globalBoost = 5.0f;
        this.q = context.getQ().trim();
        this.context = context;
        this.matchType = macthType;
        this.analyzerName = analyzerName;
        this.matchFieldName = matchFieldName;
        this.init();
    }

    public void setMatchFieldName(String matchFieldName) {
        if (this.inited) {
            return;
        }
        this.matchFieldName = matchFieldName;
    }

    void setAnalyzerName(String analyzerName) {
        if (this.inited) {
            return;
        }
        this.analyzerName = analyzerName;
    }

    private void init() {
        this.context.saveMatcheNameandMatcheFieldNamePair(this.matchName, this.matchFieldName);
        this.inited = true;
    }

    @Override
    public Matcher.MATCHER_TYPE getMatcherType() {
        return Matcher.MATCHER_TYPE.ENTIRETY;
    }

    @Override
    public EntiretyMatcher assembly() {
        Term mainTermAliasByYear;
        Term aliasTerm;
        this.q = this.context.getQ();
        this.term = new Term(this.q);
        if (!StringUtils.isEmpty(this.analyzerName)) {
            this.term.setAnalyzer(this.analyzerName);
        }
        if (!StringUtils.isEmpty(this.matchFieldName)) {
            this.term.setMatchedFieldName(this.matchFieldName);
        } else {
            this.term.setMatchedFieldName(this.context.getAttribure("normal_full_text_field"));
        }
        String missAliasQ = SearchUtils.tryToMissWordByLooseRule(this.q).trim();
        String aliasQ = SearchUtils.delNumStr(this.q, 3).trim();
        if (!StringUtils.isEmpty(aliasQ)) {
            this.context.putAttribute("execute_extraword_alis_query", aliasQ);
        }
        if (!StringUtils.isEmpty(missAliasQ) && missAliasQ.split("([\\s\\p{Zs}])+").length < this.q.split("([\\s\\p{Zs}])+").length) {
            aliasTerm = new Term(missAliasQ);
            if (!StringUtils.isEmpty(this.analyzerName)) {
                aliasTerm.setAnalyzer(this.analyzerName);
            }
            if (!StringUtils.isEmpty(this.matchFieldName)) {
                aliasTerm.setMatchedFieldName(this.matchFieldName);
            } else {
                aliasTerm.setMatchedFieldName(this.context.getAttribure("normal_full_text_field"));
            }
            this.aliasTermList.add(aliasTerm);
        }
        if (aliasQ.length() != missAliasQ.length() && !StringUtils.isEmpty(aliasQ) && aliasQ.split("([\\s\\p{Zs}])+").length < this.q.split("([\\s\\p{Zs}])+").length) {
            aliasTerm = new Term(aliasQ);
            if (!StringUtils.isEmpty(this.analyzerName)) {
                aliasTerm.setAnalyzer(this.analyzerName);
            }
            if (!StringUtils.isEmpty(this.matchFieldName)) {
                aliasTerm.setMatchedFieldName(this.matchFieldName);
            } else {
                aliasTerm.setMatchedFieldName(this.context.getAttribure("normal_full_text_field"));
            }
            this.aliasTermList.add(aliasTerm);
        }
        String aliasQDelPunct = StringUtils.delPunctWithNoSpace(this.q).trim();
        if (aliasQ.length() != aliasQDelPunct.length() && aliasQDelPunct.length() != missAliasQ.length() && this.q.length() != aliasQDelPunct.length()) {
            Term aliasTerm2 = new Term(aliasQDelPunct);
            if (!StringUtils.isEmpty(this.analyzerName)) {
                aliasTerm2.setAnalyzer(this.analyzerName);
            }
            if (!StringUtils.isEmpty(this.matchFieldName)) {
                aliasTerm2.setMatchedFieldName(this.matchFieldName);
            } else {
                aliasTerm2.setMatchedFieldName(this.context.getAttribure("normal_full_text_field"));
            }
            this.aliasTermList.add(aliasTerm2);
        }
        if ((mainTermAliasByYear = this.assemblyForYears(this.term)) != null) {
            this.termForYear = mainTermAliasByYear;
        }
        for (Term workTerm : this.aliasTermList) {
            Term subTermAliasByYear = this.assemblyForYears(workTerm);
            if (subTermAliasByYear == null) continue;
            this.aliasForYearTermList.add(subTermAliasByYear);
        }
        return this;
    }

    private Term assemblyForYears(Term workItem) {
        Map<String, List<String>> splitQ;
        if (this.matcherConfig.getYearFlag().booleanValue() && !CollectionUtils.isEmpty(splitQ = SearchUtils.splitByYear(workItem.getTermStr())) && !CollectionUtils.isEmpty((Collection)splitQ.get("keywords")) && !CollectionUtils.isEmpty((Collection)splitQ.get("years"))) {
            List<String> newQWords = splitQ.get("keywords");
            List<String> yearList = splitQ.get("years");
            if (!newQWords.get(0).trim().equalsIgnoreCase(workItem.getTermStr().trim())) {
                Term newTerm = new Term(newQWords.get(0));
                if (!StringUtils.isEmpty(this.analyzerName)) {
                    newTerm.setAnalyzer(this.analyzerName);
                }
                if (!StringUtils.isEmpty(this.matchFieldName)) {
                    newTerm.setMatchedFieldName(this.matchFieldName);
                } else {
                    newTerm.setMatchedFieldName(this.context.getAttribure("normal_full_text_field"));
                }
                newTerm.setYearList(yearList);
                return newTerm;
            }
        }
        return null;
    }

    @Override
    public QueryBuilder buildBase() {
        this.matchsentenceCount = new AtomicInteger(0);
        QueryBuilder query = null;
        if (this.matchType.equals((Object)MacthType.NORMAL_MATCH) || this.matchType.equals((Object)MacthType.NORMAL_MATCH_WITH_TERM)) {
            query = this.buildBaseForNormalMatch();
        }
        if (this.matchType.equals((Object)MacthType.STRICT_MATCH_WITH_TERM)) {
            query = this.buildBaseForStrictMatchWithTerm();
        }
        if (this.matchType.equals((Object)MacthType.STRICT_MATCH)) {
            query = this.buildBaseForStrictMatch();
        }
        this.saveQuerySentenceMatchedFieldNameMapToContext();
        return query;
    }

    private QueryBuilder buildBaseForStrictMatch() {
        QueryBuilder aliasTermQueryBuilder;
        MatchPhraseQueryBuilder finalQueryBuilder = null;
        String sentenceQueryName = this.getSentenceQueryName();
        MatchPhraseQueryBuilder mainQuery = (MatchPhraseQueryBuilder)QueryBuilders.matchPhraseQuery((String)this.term.getMatchedFieldName(), (Object)SearchUtils.takeStrByPrefixLimit(this.term.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT)).queryName(sentenceQueryName);
        this.saveSentenceMatchFieldName(sentenceQueryName, this.context.getAttribure(this.matchFieldName + ".raw"));
        this.queryUsedFieldNameSet.add(this.term.getMatchedFieldName());
        if (!StringUtils.isEmpty(this.term.getAnalyzer())) {
            mainQuery.analyzer(this.term.getAnalyzer());
        }
        finalQueryBuilder = mainQuery;
        if (this.termForYear != null && (aliasTermQueryBuilder = this.buildAliasTermQuery(this.termForYear)) != null) {
            finalQueryBuilder = QueryBuilders.boolQuery().should((QueryBuilder)mainQuery).should(aliasTermQueryBuilder);
        }
        this.context.getQueryMatcherMatchedFieldNameMap().put(this.matchName, CollectionUtils.arrayToList(this.queryUsedFieldNameSet.toArray()));
        return finalQueryBuilder;
    }

    private QueryBuilder buildBaseForStrictMatchWithTerm() {
        MatchPhraseQueryBuilder query = QueryBuilders.matchPhraseQuery((String)this.term.getMatchedFieldName(), (Object)SearchUtils.takeStrByPrefixLimit(this.term.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT));
        String sentenceQueryName = this.getSentenceQueryName();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().should((QueryBuilder)query.queryName(sentenceQueryName));
        this.saveSentenceMatchFieldName(sentenceQueryName, this.term.getMatchedFieldName());
        sentenceQueryName = this.getSentenceQueryName();
        AbstractQueryBuilder cutSomeWordQueryBuilder = ((MatchPhraseQueryBuilder)QueryBuilders.matchPhraseQuery((String)this.context.getAttribure("word_full_text_field"), (Object)SearchUtils.takeStrByPrefixLimit(this.term.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT)).slop(0).boost(this.boost * 3.0f)).queryName(sentenceQueryName);
        this.queryUsedFieldNameSet.add(this.context.getAttribure("word_full_text_field"));
        this.saveSentenceMatchFieldName(sentenceQueryName, this.context.getAttribure("word_full_text_field"));
        boolQueryBuilder.should((QueryBuilder)cutSomeWordQueryBuilder);
        ArrayList<Term> aliasForYearTermWorkList = new ArrayList<Term>();
        aliasForYearTermWorkList.addAll(this.aliasForYearTermList);
        aliasForYearTermWorkList.add(this.termForYear);
        if (!CollectionUtils.isEmpty(aliasForYearTermWorkList)) {
            for (Term term : aliasForYearTermWorkList) {
                QueryBuilder aliasTermQueryBuilder;
                if (term == null || (aliasTermQueryBuilder = this.buildAliasTermQuery(term)) == null) continue;
                boolQueryBuilder.should(aliasTermQueryBuilder);
            }
        }
        if (this.matchType.equals((Object)MacthType.STRICT_MATCH_WITH_TERM)) {
            sentenceQueryName = this.getSentenceQueryName();
            TermQueryBuilder termQueryBuilder = new TermQueryBuilder(this.matchFieldName + ".raw", SearchUtils.takeStrByPrefixLimit(this.context.getQ(), this.MATCHER_SENTENCE_LETTER_LIMIT));
            boolQueryBuilder.should((QueryBuilder)((TermQueryBuilder)termQueryBuilder.boost(this.boost * 3.0f)).queryName(sentenceQueryName));
            this.saveSentenceMatchFieldName(sentenceQueryName, this.context.getAttribure(this.matchFieldName + ".raw"));
            this.queryUsedFieldNameSet.add(this.matchFieldName + ".raw");
        }
        if (!CollectionUtils.isEmpty(this.enhanceFieldNames)) {
            for (Map map : this.enhanceFieldNames) {
                sentenceQueryName = this.getSentenceQueryName();
                boolQueryBuilder.should((QueryBuilder)((MatchPhraseQueryBuilder)QueryBuilders.matchPhraseQuery((String)map.get("name").toString(), (Object)SearchUtils.takeStrByPrefixLimit(this.term.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT)).boost(this.boost * Float.parseFloat(map.get("rate").toString()))).queryName(sentenceQueryName));
                this.saveSentenceMatchFieldName(sentenceQueryName, map.get("name").toString());
                this.queryUsedFieldNameSet.add(map.get("name").toString());
            }
        }
        boolQueryBuilder.minimumShouldMatch(1).boost(this.boost);
        this.context.getQueryMatcherMatchedFieldNameMap().put(this.matchName, CollectionUtils.arrayToList(this.queryUsedFieldNameSet.toArray()));
        return boolQueryBuilder;
    }

    private QueryBuilder buildSentencePrefixMatch(String matchField, String wordLettersFieldName, String allLettersFieldName, String queryWord) {
        String[] newQs = this.q.trim().split("([\\s\\p{Zs}])+");
        BoolQueryBuilder sentencePrefixQuery = null;
        if (newQs.length > 1) {
            sentencePrefixQuery = QueryBuilders.boolQuery();
            StringBuffer buffer = new StringBuffer();
            StringBuffer prefixBuffer = new StringBuffer();
            for (int index = 0; index < newQs.length - 1; ++index) {
                buffer.append(newQs[index]).append(" ");
            }
            for (String str : newQs) {
                prefixBuffer.append(str);
            }
            MatchQueryBuilder prefixWordQuery = QueryBuilders.matchQuery((String)allLettersFieldName, (Object)prefixBuffer.toString().toLowerCase()).operator(Operator.AND);
            MatchPhraseQueryBuilder matchQuery = QueryBuilders.matchPhraseQuery((String)matchField, (Object)buffer.toString());
            sentencePrefixQuery.must((QueryBuilder)prefixWordQuery).must(matchQuery.boost(10.0f)).queryName("check_entry_prefix_sentence");
        } else if (newQs.length == 1) {
            sentencePrefixQuery = (BoolQueryBuilder)((BoolQueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.matchQuery((String)matchField, (Object)queryWord)).must((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.wildcardQuery((String)matchField, (String)(queryWord + "*"))).must((QueryBuilder)QueryBuilders.matchQuery((String)wordLettersFieldName, (Object)queryWord).boost(2.5f))).boost(1.0f)).queryName("check_entry_prefix_sentence");
        }
        return sentencePrefixQuery;
    }

    private QueryBuilder buildBaseForNormalMatch() {
        if (!this.matchType.equals((Object)MacthType.NORMAL_MATCH) && !this.matchType.equals((Object)MacthType.NORMAL_MATCH_WITH_TERM)) {
            return null;
        }
        String sentenceQuertName = this.getSentenceQueryName();
        MatchPhraseQueryBuilder query = (MatchPhraseQueryBuilder)QueryBuilders.matchPhraseQuery((String)this.term.getMatchedFieldName(), (Object)SearchUtils.takeStrByPrefixLimit(this.term.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT)).slop(20).boost(this.boost * 5.0f);
        this.queryUsedFieldNameSet.add(this.term.getMatchedFieldName());
        query.queryName(sentenceQuertName);
        this.saveSentenceMatchFieldName(sentenceQuertName, this.term.getMatchedFieldName());
        AbstractQueryBuilder preFixeQuery = ((MatchPhrasePrefixQueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)this.term.getMatchedFieldName(), (Object)SearchUtils.takeStrByPrefixLimit(this.term.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT)).boost(this.boost * 5.0f)).queryName("check_entirety_prefix_sentence_w");
        if (!StringUtils.isEmpty(this.term.getAnalyzer())) {
            query.analyzer(this.term.getAnalyzer());
        }
        this.queryUsedFieldNameSet.add(this.term.getMatchedFieldName());
        this.saveSentenceMatchFieldName("check_entiretyMatch_prefix_sentence_w", this.term.getMatchedFieldName());
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().should((QueryBuilder)query).should((QueryBuilder)preFixeQuery);
        sentenceQuertName = this.getSentenceQueryName();
        AbstractQueryBuilder cutSomeWordQueryBuilder = QueryBuilders.matchPhraseQuery((String)this.context.getAttribure("word_full_text_field"), (Object)SearchUtils.takeStrByPrefixLimit(this.term.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT)).slop(0).boost(this.boost * 3.0f);
        this.queryUsedFieldNameSet.add(this.context.getAttribure("word_full_text_field"));
        boolQueryBuilder.should(cutSomeWordQueryBuilder.queryName(sentenceQuertName));
        this.saveSentenceMatchFieldName(sentenceQuertName, this.context.getAttribure("word_full_text_field"));
        if (!CollectionUtils.isEmpty(this.aliasTermList)) {
            for (Term term : this.aliasTermList) {
                sentenceQuertName = this.getAliasSentenceQueryName();
                MatchPhraseQueryBuilder aliasQuery = QueryBuilders.matchPhraseQuery((String)term.getMatchedFieldName(), (Object)SearchUtils.takeStrByPrefixLimit(term.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT)).slop(20);
                if (!StringUtils.isEmpty(term.getAnalyzer())) {
                    query.analyzer(term.getAnalyzer());
                }
                boolQueryBuilder.should((QueryBuilder)aliasQuery.queryName(sentenceQuertName));
                this.saveSentenceMatchFieldName(sentenceQuertName, term.getMatchedFieldName());
                if (CollectionUtils.isEmpty(this.enhanceFieldNames)) continue;
                for (Map<String, Object> enhanceField : this.enhanceFieldNames) {
                    sentenceQuertName = this.getAliasSentenceQueryName();
                    boolQueryBuilder.should((QueryBuilder)((MatchPhraseQueryBuilder)QueryBuilders.matchPhraseQuery((String)enhanceField.get("name").toString(), (Object)SearchUtils.takeStrByPrefixLimit(term.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT)).boost(this.boost * Float.parseFloat(enhanceField.get("rate").toString()))).queryName(sentenceQuertName));
                    this.saveSentenceMatchFieldName(sentenceQuertName, enhanceField.get("name").toString());
                    this.queryUsedFieldNameSet.add(enhanceField.get("name").toString());
                }
            }
        }
        ArrayList<Term> aliasForYearTermWorkList = new ArrayList<Term>();
        aliasForYearTermWorkList.addAll(this.aliasForYearTermList);
        aliasForYearTermWorkList.add(this.termForYear);
        if (!CollectionUtils.isEmpty(aliasForYearTermWorkList)) {
            for (Term aliseTerm : aliasForYearTermWorkList) {
                QueryBuilder aliasTermQueryBuilder;
                if (aliseTerm == null || (aliasTermQueryBuilder = this.buildAliasTermQuery(aliseTerm)) == null) continue;
                boolQueryBuilder.should(aliasTermQueryBuilder);
            }
        }
        if (this.matchType.equals((Object)MacthType.NORMAL_MATCH_WITH_TERM)) {
            sentenceQuertName = this.getSentenceQueryName();
            TermQueryBuilder termQueryBuilder = (TermQueryBuilder)new TermQueryBuilder(this.matchFieldName + ".raw", SearchUtils.takeStrByPrefixLimit(this.context.getQ(), this.MATCHER_SENTENCE_LETTER_LIMIT)).queryName(sentenceQuertName);
            boolQueryBuilder.should((QueryBuilder)termQueryBuilder.boost(this.boost * 3.0f));
            this.queryUsedFieldNameSet.add(this.matchFieldName + ".raw");
            this.saveSentenceMatchFieldName(sentenceQuertName, this.matchFieldName + ".raw");
        }
        if (!CollectionUtils.isEmpty(this.enhanceFieldNames)) {
            for (Map<String, Object> enhanceField : this.enhanceFieldNames) {
                sentenceQuertName = this.getSentenceQueryName();
                boolQueryBuilder.should((QueryBuilder)((MatchPhraseQueryBuilder)QueryBuilders.matchPhraseQuery((String)enhanceField.get("name").toString(), (Object)SearchUtils.takeStrByPrefixLimit(this.term.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT)).boost(this.boost * Float.parseFloat(enhanceField.get("rate").toString()))).queryName(sentenceQuertName));
                this.queryUsedFieldNameSet.add(enhanceField.get("name").toString());
                this.saveSentenceMatchFieldName(sentenceQuertName, enhanceField.get("name").toString());
            }
        }
        boolQueryBuilder.minimumShouldMatch(1).boost(this.boost);
        this.context.getQueryMatcherMatchedFieldNameMap().put(this.matchName, CollectionUtils.arrayToList(this.queryUsedFieldNameSet.toArray()));
        return boolQueryBuilder;
    }

    private String getSentenceQueryName() {
        return "check_entiretyMatch_" + this.matchsentenceCount.getAndIncrement();
    }

    private String getAliasSentenceQueryName() {
        return "check_entiretyMatch_alias_" + this.matchsentenceCount.getAndIncrement();
    }

    private List<QueryBuilder> buildAliasTermQueryV1(Term workTerm) {
        ArrayList<QueryBuilder> queryBuilderList = new ArrayList<QueryBuilder>();
        MatchPhraseQueryBuilder aliasQuery = QueryBuilders.matchPhraseQuery((String)workTerm.getMatchedFieldName(), (Object)SearchUtils.takeStrByPrefixLimit(workTerm.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT)).slop(20);
        this.queryUsedFieldNameSet.add(workTerm.getMatchedFieldName());
        if (!StringUtils.isEmpty(workTerm.getAnalyzer())) {
            aliasQuery.analyzer(workTerm.getAnalyzer());
        }
        queryBuilderList.add((QueryBuilder)aliasQuery);
        if (!CollectionUtils.isEmpty(this.enhanceFieldNames)) {
            for (Map<String, Object> enhanceField : this.enhanceFieldNames) {
                queryBuilderList.add((QueryBuilder)QueryBuilders.matchPhraseQuery((String)enhanceField.get("name").toString(), (Object)SearchUtils.takeStrByPrefixLimit(workTerm.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT)).boost(this.boost * Float.parseFloat(enhanceField.get("rate").toString())));
                this.queryUsedFieldNameSet.add(enhanceField.get("name").toString());
            }
        }
        return queryBuilderList;
    }

    private QueryBuilder buildAliasTermQuery(Term workTerm) {
        ArrayList<Object> mainQueryBuilderList = new ArrayList<Object>();
        String sentenceQuertName = this.getAliasSentenceQueryName();
        MatchPhraseQueryBuilder aliasQuery = (MatchPhraseQueryBuilder)QueryBuilders.matchPhraseQuery((String)workTerm.getMatchedFieldName(), (Object)SearchUtils.takeStrByPrefixLimit(workTerm.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT)).slop(20).queryName(sentenceQuertName);
        this.queryUsedFieldNameSet.add(workTerm.getMatchedFieldName());
        this.saveSentenceMatchFieldName(sentenceQuertName, workTerm.getMatchedFieldName());
        if (!StringUtils.isEmpty(workTerm.getAnalyzer())) {
            aliasQuery.analyzer(workTerm.getAnalyzer());
        }
        mainQueryBuilderList.add(aliasQuery);
        if (!CollectionUtils.isEmpty(this.enhanceFieldNames)) {
            for (Map<String, Object> map : this.enhanceFieldNames) {
                sentenceQuertName = this.getAliasSentenceQueryName();
                mainQueryBuilderList.add(((MatchPhraseQueryBuilder)QueryBuilders.matchPhraseQuery((String)map.get("name").toString(), (Object)SearchUtils.takeStrByPrefixLimit(workTerm.getTermStr(), this.MATCHER_SENTENCE_LETTER_LIMIT)).boost(this.boost * Float.parseFloat(map.get("rate").toString()))).queryName(sentenceQuertName));
                this.saveSentenceMatchFieldName(sentenceQuertName, map.get("name").toString());
                this.queryUsedFieldNameSet.add(map.get("name").toString());
            }
        }
        ArrayList<TermQueryBuilder> filterLQueryBuilderList = new ArrayList<TermQueryBuilder>();
        if (!CollectionUtils.isEmpty(workTerm.getYearList())) {
            for (String string : workTerm.getYearList()) {
                if (StringUtils.isEmpty(string)) continue;
                filterLQueryBuilderList.add(QueryBuilders.termQuery((String)this.matcherConfig.getYearFieldName(), (String)string));
            }
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (CollectionUtils.isEmpty(filterLQueryBuilderList)) {
            for (QueryBuilder queryBuilder : mainQueryBuilderList) {
                boolQueryBuilder.should(queryBuilder).minimumShouldMatch(1);
            }
        } else {
            for (QueryBuilder queryBuilder : mainQueryBuilderList) {
                boolQueryBuilder.should(queryBuilder);
            }
            if (filterLQueryBuilderList.size() == 1) {
                boolQueryBuilder.filter((QueryBuilder)filterLQueryBuilderList.get(0)).minimumShouldMatch(1);
            } else {
                BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery();
                for (QueryBuilder queryBuilder : filterLQueryBuilderList) {
                    boolQueryBuilder2.should(queryBuilder);
                }
                boolQueryBuilder.filter((QueryBuilder)boolQueryBuilder2).minimumShouldMatch(1);
            }
            boolQueryBuilder.queryName("YearAlias_query");
        }
        return boolQueryBuilder;
    }

    @Override
    public void prepareByConfig(MatcherConfig config) {
        this.matcherConfig = config;
        MatcherParams matcherParams = this.matcherConfig.getMatcherParams();
        this.matchType = MacthType.valueOf(matcherParams.getMatchType());
        if (!StringUtils.isEmpty(matcherParams.getMatchFieldName())) {
            this.setMatchFieldName(matcherParams.getMatchFieldName());
        } else {
            this.setMatchFieldName(this.context.getAttribure("normal_full_text_field"));
        }
        if (!StringUtils.isEmpty(matcherParams.getAnalyzerName())) {
            this.setAnalyzerName(matcherParams.getAnalyzerName());
        }
        try {
            if (!CollectionUtils.isEmpty(matcherParams.getEnhanceField())) {
                for (Map<String, Object> item : matcherParams.getEnhanceField()) {
                    if (CollectionUtils.isEmpty(item)) continue;
                    this.enhanceFieldNames.add(item);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("enhanceFieldName in  config error " + e);
        }
        super.prepareByConfig(this.matcherConfig);
        this.init();
    }

    public static enum MacthType {
        STRICT_MATCH(1, "strict", "\u4e25\u683c\u5b8c\u5168\u5339\u914d"),
        NORMAL_MATCH(2, "non-strict", "\u975e\u4e25\u683c\u5b8c\u5168\u5339\u914d"),
        NORMAL_MATCH_WITH_TERM(3, "non-strict-with-term", "\u975e\u4e25\u683c\u5b8c\u5168\u5339\u914d,\u540c\u65f6\u9700\u8981term\u53ec\u56deQ\u5b8c\u5168\u5339\u914d\u7684\u6587\u672c"),
        STRICT_MATCH_WITH_TERM(4, "strict-with-term", "\u4e25\u683c\u5b8c\u5168\u5339\u914d,\u540c\u65f6\u9700\u8981term\u53ec\u56deQ\u5b8c\u5168\u5339\u914d\u7684\u6587\u672c");

        private final String type;
        private final String desc;
        private int index;

        private MacthType(int index, String strict, String desc) {
            this.type = strict;
            this.index = index;
            this.desc = desc;
        }

        private String getType() {
            return this.type;
        }
    }
}

