/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.matcher;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.matcher.AbstractMatcher;
import com.valor.common.search.engine.matcher.Matcher;
import com.valor.common.search.engine.matcher.Term;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.SearchUtils;
import com.valor.common.search.engine.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;

public class MultiFieldEntiretyMatcher
extends AbstractMatcher {
    public static final String DEFAULT_MATCH_NAME = "EntiretyMatcher-multimatch";
    public static final float DEFAULT_BOOST = 5.0f;
    private int titleBoostRate = 5;
    private String boostFieldName = "title";
    private MacthType matchType;
    private Term term;
    private List<Term> aliasTermList = new ArrayList<Term>();
    private Set<String> queryUsedFieldNameSet = new HashSet<String>();
    private final List<ImmutablePair<String, Float>> multiMatchFieldNames = new ArrayList<ImmutablePair<String, Float>>();

    public MultiFieldEntiretyMatcher(RequestContext context, MacthType macthType, String matchName, List<ImmutablePair<String, Float>> matchFieldNameList) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.globalBoost = 5.0f;
        this.q = context.getQ();
        this.context = context;
        this.matchType = macthType;
        this.matchName = matchName;
        this.multiMatchFieldNames.addAll(matchFieldNameList);
        this.init();
    }

    public MultiFieldEntiretyMatcher(RequestContext context, MacthType macthType, List<ImmutablePair<String, Float>> matchFieldNameList) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.globalBoost = 5.0f;
        this.q = context.getQ();
        this.context = context;
        this.matchType = macthType;
        this.multiMatchFieldNames.addAll(matchFieldNameList);
        this.init();
    }

    private void init() {
        ArrayList<String> multiFieldNamesList = new ArrayList<String>();
        for (ImmutablePair<String, Float> p : this.multiMatchFieldNames) {
            multiFieldNamesList.add((String)p.getLeft());
        }
        this.context.saveMultiMatcheNameandMatcheFieldNamePair(this.matchName, multiFieldNamesList);
    }

    @Override
    public Matcher.MATCHER_TYPE getMatcherType() {
        return Matcher.MATCHER_TYPE.ENTIRETY;
    }

    @Override
    public MultiFieldEntiretyMatcher assembly() {
        Term aliasTerm;
        this.q = this.context.getQ();
        this.term = new Term(this.q);
        if (!StringUtils.isEmpty(this.analyzerName)) {
            this.term.setAnalyzer(this.analyzerName);
        }
        this.term.setMatchedFieldName(this.context.getAttribure("normal_full_text_field"));
        String missAliasQ = SearchUtils.tryToMissWord(this.q).trim();
        String aliasQ = SearchUtils.delNumStr(this.q, 3).trim();
        if (!StringUtils.isEmpty(aliasQ)) {
            this.context.putAttribute("execute_extraword_alis_query", aliasQ);
        }
        if (!StringUtils.isEmpty(missAliasQ) && missAliasQ.split("([\\s\\p{Zs}])+").length < this.q.split("([\\s\\p{Zs}])+").length) {
            aliasTerm = new Term(missAliasQ);
            if (!StringUtils.isEmpty(this.analyzerName)) {
                aliasTerm.setAnalyzer(this.analyzerName);
            }
            aliasTerm.setMatchedFieldName(this.context.getAttribure("normal_full_text_field"));
            this.aliasTermList.add(aliasTerm);
        }
        if (aliasQ.length() != missAliasQ.length() && !StringUtils.isEmpty(aliasQ) && aliasQ.split("([\\s\\p{Zs}])+").length < this.q.split("([\\s\\p{Zs}])+").length) {
            aliasTerm = new Term(aliasQ);
            if (!StringUtils.isEmpty(this.analyzerName)) {
                aliasTerm.setAnalyzer(this.analyzerName);
            }
            aliasTerm.setMatchedFieldName(this.context.getAttribure("normal_full_text_field"));
            this.aliasTermList.add(aliasTerm);
        }
        String aliasQDelPunct = StringUtils.delPunctWithNoSpace(this.q).trim();
        if (aliasQ.length() != aliasQDelPunct.length() && aliasQDelPunct.length() != missAliasQ.length() && this.q.length() != aliasQDelPunct.length()) {
            Term aliasTerm2 = new Term(aliasQDelPunct);
            if (!StringUtils.isEmpty(this.analyzerName)) {
                aliasTerm2.setAnalyzer(this.analyzerName);
            }
            aliasTerm2.setMatchedFieldName(this.context.getAttribure("normal_full_text_field"));
            this.aliasTermList.add(aliasTerm2);
        }
        return this;
    }

    @Override
    public QueryBuilder buildBase() {
        HashMap<Object, Object> fieldBoostMap = new HashMap<Object, Object>();
        HashMap<String, Object> rawFieldBoostMap = new HashMap<String, Object>();
        HashMap<String, Object> wordSubIndexFieldBoostMap = new HashMap<String, Object>();
        int nSlop = 0;
        for (ImmutablePair<String, Float> p : this.multiMatchFieldNames) {
            fieldBoostMap.put(p.getLeft(), p.getRight());
            wordSubIndexFieldBoostMap.put((String)p.getLeft() + "." + "cut_word", p.getRight());
            rawFieldBoostMap.put((String)p.getLeft() + ".raw", p.getRight());
        }
        nSlop = this.matchType.equals((Object)MacthType.NORMAL_MATCH) || this.matchType.equals((Object)MacthType.NORMAL_MATCH_WITH_TERM) ? 20 : 0;
        MultiMatchQueryBuilder query = ((MultiMatchQueryBuilder)QueryBuilders.multiMatchQuery((Object)this.term.getTermStr(), (String[])((String[])fieldBoostMap.keySet().stream().toArray(String[]::new))).fields(fieldBoostMap).slop(nSlop).boost(this.boost * 5.0f)).operator(Operator.AND).tieBreaker(1.0f);
        this.queryUsedFieldNameSet.addAll(fieldBoostMap.keySet());
        if (!StringUtils.isEmpty(this.term.getAnalyzer())) {
            query.analyzer(this.term.getAnalyzer());
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().should((QueryBuilder)query);
        MultiMatchQueryBuilder cutSomeWordQueryBuilder = ((MultiMatchQueryBuilder)QueryBuilders.multiMatchQuery((Object)this.term.getTermStr(), (String[])((String[])wordSubIndexFieldBoostMap.keySet().stream().toArray(String[]::new))).slop(nSlop).boost(this.boost * 3.0f)).fields(wordSubIndexFieldBoostMap).operator(Operator.AND).tieBreaker(1.0f);
        this.queryUsedFieldNameSet.addAll(wordSubIndexFieldBoostMap.keySet());
        boolQueryBuilder.should((QueryBuilder)cutSomeWordQueryBuilder);
        if (!CollectionUtils.isEmpty(this.aliasTermList)) {
            for (Term term : this.aliasTermList) {
                MultiMatchQueryBuilder aliasQuery = ((MultiMatchQueryBuilder)QueryBuilders.multiMatchQuery((Object)term.getTermStr(), (String[])((String[])fieldBoostMap.keySet().stream().toArray(String[]::new))).slop(nSlop).boost(5.0f)).fields(fieldBoostMap).operator(Operator.AND).tieBreaker(1.0f);
                boolQueryBuilder.should((QueryBuilder)aliasQuery);
                MultiMatchQueryBuilder aliasCutSomeWordQueryBuilder = ((MultiMatchQueryBuilder)QueryBuilders.multiMatchQuery((Object)this.term.getTermStr(), (String[])((String[])wordSubIndexFieldBoostMap.keySet().stream().toArray(String[]::new))).slop(nSlop).boost(this.boost * 3.0f)).fields(wordSubIndexFieldBoostMap).operator(Operator.AND).tieBreaker(1.0f);
                boolQueryBuilder.should((QueryBuilder)aliasCutSomeWordQueryBuilder);
            }
        }
        if (this.matchType.equals((Object)MacthType.NORMAL_MATCH_WITH_TERM)) {
            for (Map.Entry entry : rawFieldBoostMap.entrySet()) {
                TermQueryBuilder termQueryBuilder = new TermQueryBuilder((String)entry.getKey(), this.context.getQ());
                boolQueryBuilder.should((QueryBuilder)termQueryBuilder.boost(this.boost * 3.0f * ((Float)entry.getValue()).floatValue()));
                this.queryUsedFieldNameSet.add((String)entry.getKey());
            }
        }
        this.context.putQueryMatcherMatchedFieldNameMap(this.matchName, CollectionUtils.arrayToList(this.queryUsedFieldNameSet.toArray()));
        return boolQueryBuilder;
    }

    public static enum MacthType {
        STRICT_MATCH(1, "strict", "\u4e25\u683c\u5b8c\u5168\u5339\u914d"),
        NORMAL_MATCH(2, "non-strict", "\u975e\u4e25\u683c\u5b8c\u5168\u5339\u914d"),
        NORMAL_MATCH_WITH_TERM(3, "non-strict-with-term", "\u975e\u4e25\u683c\u5b8c\u5168\u5339\u914d,\u540c\u65f6\u9700\u8981term\u53ec\u56deQ\u5b8c\u5168\u5339\u914d\u7684\u6587\u672c"),
        STRICT_MATCH_WITH_TERM(4, "strict-with-term", "\u4e25\u683c\u5b8c\u5168\u5339\u914d,\u540c\u65f6\u9700\u8981term\u53ec\u56deQ\u5b8c\u5168\u5339\u914d\u7684\u6587\u672c");

        private int index;
        private final String type;
        private final String desc;

        private MacthType(int index, String strict, String desc) {
            this.type = strict;
            this.index = index;
            this.desc = desc;
        }

        private String getType() {
            return this.type;
        }
    }
}

