/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.matcher;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.matcher.AbstractFuzzyMatcher;
import com.valor.common.search.engine.matcher.Matcher;
import com.valor.common.search.engine.matcher.Term;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.SearchUtils;
import com.valor.common.search.engine.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiFieldPartialWordMatcher
extends AbstractFuzzyMatcher {
    public static final String DEFAULT_MATCH_NAME = "PartialWordMatcher-multimatch";
    private final List<ImmutablePair<String, Float>> multiMatchFieldNames = new ArrayList<ImmutablePair<String, Float>>();
    Logger logger = LoggerFactory.getLogger(MultiFieldPartialWordMatcher.class);
    private float rate = -1.0f;
    private List<Term> mainTermList = new ArrayList<Term>();
    private List<Term> leaderTermList = new ArrayList<Term>();
    private List<Term> tailerTermList = new ArrayList<Term>();
    private List<Term> aliasTermList = new ArrayList<Term>();
    private int queryTermWorkType = 0;
    private int aliasQueryTermType = 0;
    private Set<String> queryUsedFieldNameSet = new HashSet<String>();
    private String normalFullTextFieldName;
    private OneWordAnalyzer oneWordAnalyzer = new OneWordAnalyzer();
    private TwoWordAnalyzer twoWordAnalyzer = new TwoWordAnalyzer();
    private MoreWordAnalyzer moreWordAnalyzer = new MoreWordAnalyzer();

    public MultiFieldPartialWordMatcher(RequestContext context, float rate, String matchName, List<ImmutablePair<String, Float>> matchFieldNameList) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.globalBoost = 1.0f;
        this.matchName = DEFAULT_MATCH_NAME;
        this.q = context.getQ().trim();
        this.rate = rate;
        this.context = context;
        this.matchName = matchName;
        this.multiMatchFieldNames.addAll(matchFieldNameList);
        this.init();
    }

    public MultiFieldPartialWordMatcher(RequestContext context, float rate, List<ImmutablePair<String, Float>> matchFieldNameList) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.globalBoost = 1.0f;
        this.matchName = DEFAULT_MATCH_NAME;
        this.q = context.getQ().trim();
        this.rate = rate;
        this.context = context;
        this.multiMatchFieldNames.addAll(matchFieldNameList);
        this.init();
    }

    public MultiFieldPartialWordMatcher(RequestContext context, List<ImmutablePair<String, Float>> matchFieldNameList) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.globalBoost = 1.0f;
        this.matchName = DEFAULT_MATCH_NAME;
        this.q = context.getQ().trim();
        this.context = context;
        this.multiMatchFieldNames.addAll(matchFieldNameList);
        this.init();
    }

    public MultiFieldPartialWordMatcher(RequestContext context, float rate, String matchName, List<ImmutablePair<String, Float>> matchFieldNameList, Map analyzerNameMap) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.globalBoost = 1.0f;
        this.matchName = DEFAULT_MATCH_NAME;
        this.q = context.getQ().trim();
        this.rate = rate;
        this.context = context;
        this.matchName = matchName;
        this.multiMatchFieldNames.addAll(matchFieldNameList);
        this.analyzerNameMap.putAll(analyzerNameMap);
        this.init();
    }

    public MultiFieldPartialWordMatcher(RequestContext context, float rate, List<ImmutablePair<String, Float>> matchFieldNameList, Map analyzerNameMap) {
        this.matchName = DEFAULT_MATCH_NAME;
        this.globalBoost = 1.0f;
        this.matchName = DEFAULT_MATCH_NAME;
        this.q = context.getQ().trim();
        this.rate = rate;
        this.context = context;
        this.multiMatchFieldNames.addAll(matchFieldNameList);
        this.analyzerNameMap.putAll(analyzerNameMap);
        this.init();
    }

    private void init() {
        ArrayList<String> multiFieldNamesList = new ArrayList<String>();
        for (ImmutablePair<String, Float> p : this.multiMatchFieldNames) {
            multiFieldNamesList.add((String)p.getLeft());
        }
        this.context.saveMultiMatcheNameandMatcheFieldNamePair(this.matchName, multiFieldNamesList);
    }

    @Override
    public Matcher.MATCHER_TYPE getMatcherType() {
        return Matcher.MATCHER_TYPE.PARTIAL_WORD;
    }

    public void putAnalyzerName(AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE nameType, String analyzerName) {
        this.analyzerNameMap.put(nameType, analyzerName);
    }

    @Override
    public MultiFieldPartialWordMatcher assembly() {
        String qStr;
        int queryTermType;
        this.mainTermList.clear();
        this.leaderTermList.clear();
        this.tailerTermList.clear();
        this.aliasTermList.clear();
        this.q = this.context.getQ().trim();
        this.queryTermWorkType = queryTermType = this.queryTermType(this.q).ordinal();
        if (queryTermType >= 3 && (qStr = SearchUtils.tryToMissWord(this.q)).trim().length() != this.q.trim().length()) {
            this.boost = 0.65f;
            this.queryTermWorkType = queryTermType = this.queryTermType(qStr).ordinal();
            this.q = qStr;
            this.context.putAttribute("execute_partiword_query", qStr);
        }
        this.q = this.q.replace("-", " ").trim();
        this.queryTermWorkType = queryTermType = this.queryTermType(this.q).ordinal();
        switch (this.queryTermWorkType) {
            case 1: {
                this.assemblyForOneWord();
                break;
            }
            case 2: {
                this.assemblyForTwoWord();
                String aliasQ = SearchUtils.delNumStr(this.q, 3).trim();
                if (StringUtils.isEmpty(aliasQ) || aliasQ.split("([\\s\\p{Zs}])+").length >= this.q.split("([\\s\\p{Zs}])+").length) break;
                this.assemblyForOneWord(aliasQ, this.aliasTermList);
                this.aliasQueryTermType = Matcher.QUERY_TERM_TYPE.ONE_WORD.ordinal();
                this.context.putAttribute("execute_partiword_alis_query", aliasQ);
                break;
            }
            case 3: {
                this.assemblyForMoreWord();
                String aliasQ = SearchUtils.delNumStr(this.q, 3).trim();
                if (StringUtils.isEmpty(aliasQ) || aliasQ.split("([\\s\\p{Zs}])+").length >= this.q.split("([\\s\\p{Zs}])+").length) break;
                this.context.putAttribute("execute_partiword_alis_query", aliasQ);
                int nLen = aliasQ.split("([\\s\\p{Zs}])+").length;
                if (nLen == 1) {
                    this.assemblyForOneWord(aliasQ, this.aliasTermList);
                    this.aliasQueryTermType = Matcher.QUERY_TERM_TYPE.ONE_WORD.ordinal();
                    break;
                }
                if (nLen != 2) break;
                this.assemblyForTwoWord(aliasQ, this.aliasTermList);
                this.aliasQueryTermType = Matcher.QUERY_TERM_TYPE.TWO_WORD.ordinal();
                break;
            }
            default: {
                this.logger.warn("unsupport match model ,query term is: " + this.q + " context.q:" + this.context.getQ());
                throw new RuntimeException("unsupport match model");
            }
        }
        return this;
    }

    @Override
    public QueryBuilder buildBase() {
        int queryTermType = this.queryTermWorkType;
        BoolQueryBuilder queryBuilder = null;
        switch (queryTermType) {
            case 1: {
                queryBuilder = (BoolQueryBuilder)this.buildForOneWord().boost(this.globalBoost);
                break;
            }
            case 2: {
                queryBuilder = (BoolQueryBuilder)this.buildForTwoWord().boost(this.globalBoost);
                break;
            }
            case 3: {
                queryBuilder = (BoolQueryBuilder)this.buildForMoreWord().boost(this.globalBoost);
                break;
            }
            default: {
                throw new RuntimeException("unsupport match model");
            }
        }
        this.context.putQueryMatcherMatchedFieldNameMap(this.matchName, CollectionUtils.arrayToList(this.queryUsedFieldNameSet.toArray()));
        return queryBuilder;
    }

    private void prepareAnalyzerName(Term term) {
        int fuzzinessCharLength = Math.round((float)term.getTermStr().length() * term.getMatchRate());
        String analyzerName = this.getFuzzyAnalyzerName(fuzzinessCharLength);
        term.setAnalyzer(analyzerName);
    }

    private BoolQueryBuilder buildForOneWord() {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        QueryBuilder queryBuilder = this.buildForOneWordInternal(this.mainTermList);
        boolQueryBuilder.must(queryBuilder);
        return boolQueryBuilder;
    }

    private QueryBuilder buildForOneWordInternal(List<Term> terms) {
        Term term = terms.get(0);
        HashMap<String, Object> fieldBoostMap = new HashMap<String, Object>();
        for (ImmutablePair<String, Float> p : this.multiMatchFieldNames) {
            if (StringUtils.isEmpty(term.getMatchedFieldName())) {
                term.setMatchedFieldName("NONE");
            }
            fieldBoostMap.put(term.getMatchedFieldName().replaceAll("NONE", (String)p.getLeft()), p.getRight());
        }
        MultiMatchQueryBuilder queryBuilder = QueryBuilders.multiMatchQuery((Object)term.getTermStr(), (String[])((String[])fieldBoostMap.keySet().stream().toArray(String[]::new))).fields(fieldBoostMap).analyzer(term.getAnalyzer()).fuzziness((Object)term.getFuzzyDistance()).fuzzyTranspositions(false).tieBreaker(1.0f);
        this.queryUsedFieldNameSet.addAll(fieldBoostMap.keySet());
        return queryBuilder;
    }

    private BoolQueryBuilder buildForTwoWord() {
        BoolQueryBuilder boolQueryBuilder = this.buildForTwoWordInternal(this.mainTermList);
        if (this.aliasQueryTermType == Matcher.QUERY_TERM_TYPE.ONE_WORD.ordinal()) {
            boolQueryBuilder.should(this.buildForOneWordInternal(this.aliasTermList));
        }
        return boolQueryBuilder;
    }

    private BoolQueryBuilder buildForTwoWordInternal(List<Term> workTermsList) {
        HashMap<Object, Object> mainFieldBoostMap = new HashMap<Object, Object>();
        for (ImmutablePair<String, Float> p : this.multiMatchFieldNames) {
            mainFieldBoostMap.put(p.getLeft(), p.getRight());
        }
        MultiMatchQueryBuilder leaderMatcherFirstQuery = QueryBuilders.multiMatchQuery((Object)this.leaderTermList.get(0).getTermStr(), (String[])((String[])mainFieldBoostMap.keySet().stream().toArray(String[]::new))).analyzer(this.leaderTermList.get(0).getAnalyzer()).tieBreaker(1.0f).fields(mainFieldBoostMap);
        MultiMatchQueryBuilder leaderMatcherSubStrQuery = QueryBuilders.multiMatchQuery((Object)this.leaderTermList.get(1).getTermStr(), (String[])((String[])mainFieldBoostMap.keySet().stream().toArray(String[]::new))).analyzer(this.leaderTermList.get(1).getAnalyzer()).tieBreaker(1.0f).fields(mainFieldBoostMap);
        MultiMatchQueryBuilder tailerMatcherFirstQuery = QueryBuilders.multiMatchQuery((Object)this.tailerTermList.get(0).getTermStr(), (String[])((String[])mainFieldBoostMap.keySet().stream().toArray(String[]::new))).analyzer(this.tailerTermList.get(0).getAnalyzer()).tieBreaker(1.0f).fields(mainFieldBoostMap);
        MultiMatchQueryBuilder tailerMatcherSubStrQuery = QueryBuilders.multiMatchQuery((Object)this.tailerTermList.get(1).getTermStr(), (String[])((String[])mainFieldBoostMap.keySet().stream().toArray(String[]::new))).analyzer(this.tailerTermList.get(1).getAnalyzer()).tieBreaker(1.0f).fields(mainFieldBoostMap);
        this.queryUsedFieldNameSet.addAll(mainFieldBoostMap.keySet());
        ArrayList<MultiMatchQueryBuilder> queryList = new ArrayList<MultiMatchQueryBuilder>();
        Map<String, List<Term>> termSplitByFieldNameMap = this.splitTermIntoGroupByFieldName(workTermsList);
        for (Map.Entry<String, List<Term>> entry : termSplitByFieldNameMap.entrySet()) {
            HashMap<String, Object> workTermFieldBoostMap = new HashMap<String, Object>();
            for (ImmutablePair<String, Float> p : this.multiMatchFieldNames) {
                String newFieldName = entry.getKey().replaceAll("NONE", (String)p.getLeft());
                workTermFieldBoostMap.put(newFieldName, p.getRight());
            }
            this.queryUsedFieldNameSet.addAll(workTermFieldBoostMap.keySet());
            for (Term term : entry.getValue()) {
                MultiMatchQueryBuilder query = QueryBuilders.multiMatchQuery((Object)term.getTermStr(), (String[])((String[])workTermFieldBoostMap.keySet().stream().toArray(String[]::new))).analyzer(term.getAnalyzer()).tieBreaker(1.0f).fields(workTermFieldBoostMap);
                queryList.add(query);
            }
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)leaderMatcherFirstQuery).must((QueryBuilder)leaderMatcherSubStrQuery)).should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)tailerMatcherFirstQuery).must((QueryBuilder)tailerMatcherSubStrQuery)).should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)queryList.get(0)).must((QueryBuilder)queryList.get(1))).minimumShouldMatch(1);
        return boolQueryBuilder;
    }

    private BoolQueryBuilder buildForMoreWord() {
        BoolQueryBuilder wrapQueryBuilder;
        BoolQueryBuilder mainQueryBuilder = QueryBuilders.boolQuery();
        Map<String, List<Term>> termSplitByFieldNameMap = this.splitTermIntoGroupByFieldName(this.mainTermList);
        for (Map.Entry<String, List<Term>> entry : termSplitByFieldNameMap.entrySet()) {
            HashMap<String, Object> workTermFieldBoostMap = new HashMap<String, Object>();
            for (ImmutablePair<String, Float> p : this.multiMatchFieldNames) {
                String newFieldName = entry.getKey().replaceAll("NONE", (String)p.getLeft());
                workTermFieldBoostMap.put(newFieldName, p.getRight());
            }
            this.queryUsedFieldNameSet.addAll(workTermFieldBoostMap.keySet());
            for (Term term : entry.getValue()) {
                MultiMatchQueryBuilder query = QueryBuilders.multiMatchQuery((Object)term.getTermStr(), (String[])((String[])workTermFieldBoostMap.keySet().stream().toArray(String[]::new))).analyzer(term.getAnalyzer()).fuzziness((Object)term.getFuzzyDistance()).fuzzyTranspositions(false).tieBreaker(1.0f).fields(workTermFieldBoostMap);
                mainQueryBuilder.must((QueryBuilder)query);
            }
        }
        if (this.aliasQueryTermType == Matcher.QUERY_TERM_TYPE.ONE_WORD.ordinal()) {
            wrapQueryBuilder = QueryBuilders.boolQuery();
            wrapQueryBuilder.should(this.buildForOneWordInternal(this.aliasTermList)).should((QueryBuilder)mainQueryBuilder).minimumShouldMatch(1);
            mainQueryBuilder = wrapQueryBuilder;
        }
        if (this.aliasQueryTermType == Matcher.QUERY_TERM_TYPE.TWO_WORD.ordinal()) {
            wrapQueryBuilder = QueryBuilders.boolQuery();
            wrapQueryBuilder.should((QueryBuilder)this.buildForTwoWordInternal(this.aliasTermList)).should((QueryBuilder)mainQueryBuilder).minimumShouldMatch(1);
            mainQueryBuilder = wrapQueryBuilder;
        }
        return mainQueryBuilder;
    }

    private void assemblyForTwoWord() {
        this.assemblyForTwoWord(this.q, this.mainTermList);
    }

    private void assemblyForTwoWord(String strQ, List<Term> parsedTermList) {
        String[] newQs;
        String q = strQ.replaceAll("-", " ").trim();
        for (String s : newQs = q.split("([\\s\\p{Zs}])+")) {
            Term term = new Term(s);
            if (this.rate != -1.0f) {
                term.setMatchRate(this.rate);
            }
            if (!StringUtils.isEmpty(this.matchFieldName)) {
                term.setMatchedFieldName(this.matchFieldName);
            }
            parsedTermList.add(term);
        }
        Term[] terms = new Term[2];
        parsedTermList.toArray(terms);
        this.twoWordAnalyzer.analyze(terms, this.context);
    }

    private void assemblyForMoreWord() {
        String[] newQs;
        String q = this.q.replaceAll("-", " ").trim();
        for (String s : newQs = q.trim().split("([\\s\\p{Zs}])+")) {
            Term term = new Term(s);
            if (this.rate == -1.0f) {
                term.setMatchRate(0.7f);
            } else {
                term.setMatchRate(this.rate);
            }
            this.mainTermList.add(term);
        }
        this.moreWordAnalyzer.analyze(this.mainTermList, this.context);
    }

    private void assemblyForOneWord() {
        this.assemblyForOneWord(this.q.trim(), this.mainTermList);
    }

    private void assemblyForOneWord(String aliasQ, List<Term> parsedTermsList) {
        Term term = new Term(aliasQ);
        if (this.rate == -1.0f) {
            term.setMatchRate(0.75f);
        } else {
            term.setMatchRate(this.rate);
        }
        this.oneWordAnalyzer.analyze(term, this.context);
        parsedTermsList.add(term);
    }

    public Matcher.QUERY_TERM_TYPE queryTermType(String q) {
        if (q.isEmpty()) {
            return Matcher.QUERY_TERM_TYPE.NONE;
        }
        String[] newQs = (q = q.replaceAll("-", " ").trim()).split("([\\s\\p{Zs}])+");
        if (newQs.length == 1) {
            return Matcher.QUERY_TERM_TYPE.ONE_WORD;
        }
        if (newQs.length == 2) {
            return Matcher.QUERY_TERM_TYPE.TWO_WORD;
        }
        if (newQs.length >= 3) {
            return Matcher.QUERY_TERM_TYPE.MORE_WORD;
        }
        return Matcher.QUERY_TERM_TYPE.NONE;
    }

    private class MoreWordAnalyzer {
        private MoreWordAnalyzer() {
        }

        public void analyze(List<Term> terms, RequestContext context) {
            for (Term term : terms) {
                term.setBoost(MultiFieldPartialWordMatcher.this.boost);
                if (term.getTermStr().length() <= 3) {
                    term.setAnalyzer(MultiFieldPartialWordMatcher.this.getFuzzyAnalyzerName(term.getTermStr().length()));
                    if (!StringUtils.isEmpty(term.getMatchedFieldName())) continue;
                    term.setMatchedFieldName(context.getAttribure("normal_full_text_field"));
                    continue;
                }
                if (StringUtils.isEmpty(term.getMatchedFieldName())) {
                    term.setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                }
                if (term.getMatchRate() == -1.0f) {
                    term.setMatchRate(0.75f);
                }
                if (!StringUtils.isEmpty(term.getAnalyzer())) continue;
                MultiFieldPartialWordMatcher.this.prepareAnalyzerName(term);
            }
        }
    }

    private class TwoWordAnalyzer {
        private TwoWordAnalyzer() {
        }

        public void analyze(Term[] terms, RequestContext context) {
            this.mainTerm(terms, context);
            this.leaderTailTerm(terms, context);
        }

        private void leaderTailTerm(Term[] terms, RequestContext context) {
            String mainWord = "";
            String subStr = "";
            Term term = new Term(terms[0].getTermStr());
            term.setAnalyzer(context.getAttribure("word_analyzer_name"));
            term.setBoost(MultiFieldPartialWordMatcher.this.boost);
            MultiFieldPartialWordMatcher.this.leaderTermList.add(term);
            term = new Term(terms[1].getTermStr());
            term.setAnalyzer(this.getAnalyzerName4LeaderTail(terms[1].getTermStr()));
            term.setBoost(MultiFieldPartialWordMatcher.this.boost);
            MultiFieldPartialWordMatcher.this.leaderTermList.add(term);
            term = new Term(terms[1].getTermStr());
            term.setAnalyzer(context.getAttribure("word_analyzer_name"));
            term.setBoost(MultiFieldPartialWordMatcher.this.boost);
            MultiFieldPartialWordMatcher.this.tailerTermList.add(term);
            term = new Term(terms[0].getTermStr());
            term.setAnalyzer(this.getAnalyzerName4LeaderTail(terms[0].getTermStr()));
            term.setBoost(MultiFieldPartialWordMatcher.this.boost);
            MultiFieldPartialWordMatcher.this.tailerTermList.add(term);
        }

        private String getAnalyzerName4LeaderTail(String termStr) {
            int len = termStr.trim().length();
            int analyzeNameLen = 0;
            analyzeNameLen = len >= 12 ? (int)Math.round((double)len * 0.7) : (len >= 9 && len < 12 ? (int)Math.round((double)len * 0.65) : (len >= 6 && len < 9 ? (int)Math.round((double)len * 0.6) : (int)Math.round((double)len * 0.55)));
            return MultiFieldPartialWordMatcher.this.getFuzzyAnalyzerName(analyzeNameLen);
        }

        private void mainTerm(Term[] terms, RequestContext context) {
            terms[0].setBoost(MultiFieldPartialWordMatcher.this.boost);
            terms[1].setBoost(MultiFieldPartialWordMatcher.this.boost);
            if (terms[1].getTermStr().length() >= 9) {
                if (terms[0].getTermStr().length() <= 6 && terms[0].getTermStr().length() > 4) {
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        terms[0].setAnalyzer((String)MultiFieldPartialWordMatcher.this.analyzerNameMap.get((Object)AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_THREE_CHARS));
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.9f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("normal_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("normal_full_text_field"));
                    }
                } else if (terms[0].getTermStr().length() > 6 && terms[0].getTermStr().length() < 9) {
                    if (terms[0].getMatchRate() == -1.0f) {
                        terms[0].setMatchRate(0.5f);
                    }
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[0]);
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.9f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("normal_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("normal_full_text_field"));
                    }
                } else if (terms[0].getTermStr().length() >= 9) {
                    if (terms[0].getMatchRate() == -1.0f) {
                        terms[0].setMatchRate(0.65f);
                    }
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[0]);
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.65f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("normal_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("normal_full_text_field"));
                    }
                } else {
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        terms[0].setAnalyzer(context.getAttribure("word_analyzer_name"));
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.9f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("normal_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    terms[0].setFuzzyDistance(1);
                }
            } else if (terms[1].getTermStr().length() > 6 && terms[1].getTermStr().length() < 9) {
                if (terms[0].getTermStr().length() <= 6 && terms[0].getTermStr().length() > 4) {
                    if (terms[0].getMatchRate() == -1.0f) {
                        terms[0].setMatchRate(0.69f);
                    }
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[0]);
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.75f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                } else if (terms[0].getTermStr().length() > 6 && terms[0].getTermStr().length() < 9) {
                    if (terms[0].getMatchRate() == -1.0f) {
                        terms[0].setMatchRate(0.65f);
                    }
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[0]);
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.65f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                } else if (terms[0].getTermStr().length() >= 9) {
                    if (terms[0].getMatchRate() == -1.0f) {
                        terms[0].setMatchRate(0.9f);
                    }
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[0]);
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.55f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                } else if (terms[0].getTermStr().length() == 4) {
                    if (terms[0].getMatchRate() == -1.0f) {
                        terms[0].setMatchRate(0.7f);
                    }
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[0]);
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.75f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                } else {
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        terms[0].setAnalyzer(context.getAttribure("word_analyzer_name"));
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.9f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("normal_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    terms[0].setFuzzyDistance(1);
                }
            } else if (terms[1].getTermStr().length() > 4 && terms[1].getTermStr().length() <= 6) {
                if (terms[0].getTermStr().length() <= 6 && terms[0].getTermStr().length() > 4) {
                    if (terms[0].getMatchRate() == -1.0f) {
                        terms[0].setMatchRate(0.75f);
                    }
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[0]);
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.75f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                } else if (terms[0].getTermStr().length() > 6 && terms[0].getTermStr().length() < 9) {
                    if (terms[0].getMatchRate() == -1.0f) {
                        terms[0].setMatchRate(0.75f);
                    }
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[0]);
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.69f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                } else if (terms[0].getTermStr().length() >= 9) {
                    if (terms[0].getMatchRate() == -1.0f) {
                        terms[0].setMatchRate(0.9f);
                    }
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[0]);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        terms[1].setAnalyzer((String)MultiFieldPartialWordMatcher.this.analyzerNameMap.get((Object)AbstractFuzzyMatcher.CHARS_ANALYZER_TYPE.LIMIT_THREE_CHARS));
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                } else {
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        terms[0].setAnalyzer(context.getAttribure("word_analyzer_name"));
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.9f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                }
            } else if (terms[1].getTermStr().length() <= 4) {
                if (terms[0].getTermStr().length() <= 6 && terms[0].getTermStr().length() > 4) {
                    if (terms[0].getMatchRate() == -1.0f) {
                        terms[0].setMatchRate(0.9f);
                    }
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[0]);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                        terms[1].setAnalyzer(context.getAttribure("word_analyzer_name"));
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                } else if (terms[0].getTermStr().length() > 6 && terms[0].getTermStr().length() < 9) {
                    if (terms[0].getMatchRate() == -1.0f) {
                        terms[0].setMatchRate(0.75f);
                    }
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[0]);
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.7f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                } else if (terms[0].getTermStr().length() >= 9) {
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        terms[0].setAnalyzer(context.getAttribure("word_analyzer_name"));
                    }
                    if (terms[1].getMatchRate() == -1.0f) {
                        terms[1].setMatchRate(0.69f);
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        MultiFieldPartialWordMatcher.this.prepareAnalyzerName(terms[1]);
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("normal_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    terms[0].setFuzzyDistance(1);
                } else {
                    if (StringUtils.isEmpty(terms[0].getAnalyzer())) {
                        terms[0].setAnalyzer(context.getAttribure("word_analyzer_name"));
                    }
                    if (StringUtils.isEmpty(terms[1].getAnalyzer())) {
                        terms[1].setAnalyzer(context.getAttribure("word_analyzer_name"));
                    }
                    if (StringUtils.isEmpty(terms[0].getMatchedFieldName())) {
                        terms[0].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                    if (StringUtils.isEmpty(terms[1].getMatchedFieldName())) {
                        terms[1].setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
                    }
                }
            }
        }
    }

    private class OneWordAnalyzer {
        private OneWordAnalyzer() {
        }

        public void analyze(Term term, RequestContext context) {
            MultiFieldPartialWordMatcher.this.prepareAnalyzerName(term);
            term.setMatchedFieldName(context.getAttribure("fuzzy_full_text_field"));
            term.setBoost(MultiFieldPartialWordMatcher.this.boost);
        }
    }
}

