/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.matcher;

import com.valor.common.search.engine.util.CollectionUtils;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.index.query.Operator;

public class Term {
    private String termStr;
    private String analyzer;
    private int fuzzyDistance = 0;
    private float matchRate = -1.0f;
    private String matchedFieldName = "";
    private float boost = 1.0f;
    private List<String> yearList;
    private Operator operator = Operator.OR;

    public Term(String termStr) {
        this.termStr = termStr;
    }

    public Term(String termStr, Operator operator) {
        this.termStr = termStr;
        this.operator = operator;
    }

    public Term(String termStr, String analyzer, int fuzzyDistance) {
        this.termStr = termStr;
        this.analyzer = analyzer;
        this.fuzzyDistance = fuzzyDistance;
        this.operator = Operator.OR;
    }

    public Term(String termStr, String analyzer, int fuzzyDistance, Operator operator) {
        this.termStr = termStr;
        this.analyzer = analyzer;
        this.fuzzyDistance = fuzzyDistance;
        this.operator = operator;
    }

    public List<String> getYearList() {
        return this.yearList;
    }

    public void setYearList(List<String> yearList) {
        this.yearList = yearList;
    }

    public String getMatchedFieldName() {
        return this.matchedFieldName;
    }

    public void setMatchedFieldName(String matchedFieldName) {
        this.matchedFieldName = matchedFieldName;
    }

    public float getMatchRate() {
        return this.matchRate;
    }

    public void setMatchRate(float matchRate) {
        this.matchRate = matchRate;
    }

    public String getTermStr() {
        return this.termStr;
    }

    public void setTermStr(String termStr) {
        this.termStr = termStr;
    }

    public String getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(String analyzer) {
        this.analyzer = analyzer;
    }

    public int getFuzzyDistance() {
        return this.fuzzyDistance;
    }

    public void setFuzzyDistance(int fuzzyDistance) {
        this.fuzzyDistance = fuzzyDistance;
    }

    public float getBoost() {
        return this.boost;
    }

    public void setBoost(float boost) {
        this.boost = boost;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Term)) {
            return false;
        }
        Term t = (Term)o;
        if (CollectionUtils.isEmpty(t.yearList) && !CollectionUtils.isEmpty(this.yearList) || CollectionUtils.isEmpty(this.yearList) && !CollectionUtils.isEmpty(t.yearList)) {
            return false;
        }
        Boolean isEqual = t.getTermStr().equalsIgnoreCase(this.getTermStr()) && t.getMatchedFieldName().equalsIgnoreCase(this.getMatchedFieldName());
        if (!CollectionUtils.isEmpty(this.yearList) && !CollectionUtils.isEmpty(t.getYearList())) {
            isEqual = isEqual & t.getYearList().equals(this.getYearList());
        }
        return isEqual;
    }

    public int hashCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.fuzzyDistance).append(" ").append(this.boost).append(" ").append(this.analyzer).append(" ").append(this.matchedFieldName).append(" ").append(this.matchRate).append(" ").append(this.operator.ordinal()).append(" ").append(this.termStr).append(" ");
        if (!CollectionUtils.isEmpty(this.yearList)) {
            stringBuffer.append(Arrays.toString(this.yearList.toArray())).toString().hashCode();
        }
        return stringBuffer.toString().hashCode();
    }
}

