/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.ranker;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.ranker.AbstractInlineScoreRanker;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilders;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionScoreRanker
extends AbstractInlineScoreRanker {
    private static Logger logger = LoggerFactory.getLogger(FunctionScoreRanker.class);
    private RequestContext context;
    private Map<String, Object> scriptParamsMap = new HashMap<String, Object>();
    private String expression;
    private CombineFunction boostMode = CombineFunction.REPLACE;

    public FunctionScoreRanker(RequestContext context) {
        this.context = context;
    }

    @Override
    public QueryBuilder build(QueryBuilder wrapQueryBuilder) {
        String funcStr = this.expression;
        Script script = new Script(ScriptType.INLINE, "painless", this.expression, this.scriptParamsMap);
        FunctionScoreQueryBuilder query = QueryBuilders.functionScoreQuery((QueryBuilder)wrapQueryBuilder, (ScoreFunctionBuilder)ScoreFunctionBuilders.scriptFunction((Script)script)).boostMode(this.boostMode).setMinScore(1.0E-7f);
        return query;
    }

    public FunctionScoreRanker expression(String expression) {
        this.expression = expression;
        return this;
    }

    public FunctionScoreRanker params(Map<String, Object> params) {
        this.scriptParamsMap.clear();
        this.scriptParamsMap.putAll(params);
        return this;
    }

    public FunctionScoreRanker boostMode(CombineFunction boostMode) {
        this.boostMode = boostMode;
        return this;
    }

    public static void main(String[] args) {
    }
}

