/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.ranker;

import com.valor.common.search.engine.RequestContext;
import com.valor.common.search.engine.facade.config.PostRankerConfig;
import com.valor.common.search.engine.facade.config.RankerComparatorConfig;
import com.valor.common.search.engine.ranker.AbstractPostScoreRanker;
import com.valor.common.search.engine.ranker.comparator.AbstractRankerComparator;
import com.valor.common.search.engine.ranker.comparator.CelebsHotWeightComparator;
import com.valor.common.search.engine.ranker.comparator.MovieSeriesYearPopularityWeightComparator;
import com.valor.common.search.engine.ranker.comparator.ScoreDescComparator;
import com.valor.common.search.engine.ranker.comparator.ScoreWeightDescComparator;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.SearchUtils;
import com.valor.common.search.engine.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.nfunk.jep.JEP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeliplatTunningAllMatchRanker
extends AbstractPostScoreRanker {
    public static final String DEFAULT_THRESHOLD_TYPE_NAME = "default";
    public static final String KEY_ENABLE_TUNNING_RANKER_NEW_SORT = "enable-tunning-ranker-new-sort";
    private static Logger logger = LoggerFactory.getLogger(PeliplatTunningAllMatchRanker.class);
    private String searchName;
    private List<String> sortFieldNames = new ArrayList<String>();
    private String thresholdFieldName = "weight";
    private Map<String, Float> thresholdTypeValueMap = new HashMap<String, Float>();
    private String thresholdTypeFieldName = "mark";
    private Map<String, Comparator> comparatorMap = new HashMap<String, Comparator>();
    private boolean enableTunningRankerNewSort = true;

    public PeliplatTunningAllMatchRanker() {
    }

    public PeliplatTunningAllMatchRanker(RequestContext context, String searchName, String sortFieldNames) {
        this.context = context;
        this.searchName = searchName;
        this.sortFieldNames.add(sortFieldNames);
        this.initComparator();
    }

    public PeliplatTunningAllMatchRanker(RequestContext context) {
        this.context = context;
        this.searchName = "EntiretyMatcher";
        this.sortFieldNames.add(context.getAttribure("normal_full_text_field"));
        this.enableTunningRankerNewSort = "true".equalsIgnoreCase(context.getAttribure(KEY_ENABLE_TUNNING_RANKER_NEW_SORT));
        this.initComparator();
    }

    public PeliplatTunningAllMatchRanker(RequestContext context, String ... sortFieldNames) {
        this.context = context;
        this.searchName = "EntiretyMatcher";
        this.sortFieldNames.addAll(Arrays.asList(sortFieldNames));
        this.enableTunningRankerNewSort = "true".equalsIgnoreCase(context.getAttribure(KEY_ENABLE_TUNNING_RANKER_NEW_SORT));
        this.initComparator();
    }

    public static void main(String[] args) {
        JEP jep = new JEP();
        jep.addStandardFunctions();
        jep.addVariable("popularity", 99000.0);
        jep.addVariable("hot", 99990.0);
        jep.parseExpression("if(popularity>9900000,log(popularity)/log(1.5),if(hot>99000,log(hot)/log(1.5),0))");
        System.out.println(jep.getErrorInfo());
        System.out.println(jep.getValue());
    }

    private void initComparator() {
        this.comparatorMap.put("CelebsComparator", new CelebsHotWeightComparator());
        this.comparatorMap.put("MovieSeriesComparator", new MovieSeriesYearPopularityWeightComparator());
        this.comparatorMap.put("NormalComparator", new ScoreWeightDescComparator());
        this.comparatorMap.put("ScoreDescComparator", new ScoreDescComparator());
    }

    public String getThresholdTypeFieldName() {
        return this.thresholdTypeFieldName;
    }

    public Map<String, Float> getThresholdTypeValueMap() {
        return this.thresholdTypeValueMap;
    }

    public PeliplatTunningAllMatchRanker appendThresholdTypeValueMap(String thresholdTypeName, float thresholdTypeValue) {
        this.thresholdTypeValueMap.put(thresholdTypeName, Float.valueOf(thresholdTypeValue));
        return this;
    }

    public PeliplatTunningAllMatchRanker thresholdTypeFieldName(String thresholdTypeFieldName) {
        this.thresholdTypeFieldName = thresholdTypeFieldName;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute() throws RuntimeException {
        Object[] cutoffList;
        SearchResponse response = this.context.getResponse();
        SearchHits hits = response.getHits();
        SearchHit[] hitDocs = hits.getHits();
        List<Object> otherMatchHitList = new ArrayList<SearchHit>();
        ArrayList<Object> finalHits = new ArrayList<Object>();
        ArrayList finalHitsSameWordsAndPos = new ArrayList();
        ArrayList finalHitsSameWordOnly = new ArrayList();
        ArrayList<SearchHit> willSortingDataList = new ArrayList<SearchHit>();
        String q = this.context.getQ().toLowerCase();
        q = org.apache.commons.lang3.StringUtils.stripAccents((String)q);
        SearchHit topHit = null;
        for (SearchHit hit : hitDocs) {
            if (this.hasAllMatchQuery(hit.getMatchedQueries())) {
                willSortingDataList.add(hit);
                continue;
            }
            otherMatchHitList.add(hit);
        }
        ArrayList<SearchHit> notSortDataList = new ArrayList<SearchHit>();
        ArrayList<SearchHit> hasSameWordAndPosList = new ArrayList<SearchHit>();
        ArrayList<SearchHit> hasSameWordList = new ArrayList<SearchHit>();
        ArrayList<SearchHit> extraAllMatchHitList = new ArrayList<SearchHit>();
        List<SearchHit> sameWordSortedList = new ArrayList<SearchHit>();
        for (String sortingFieldName : this.sortFieldNames) {
            for (SearchHit hit : willSortingDataList) {
                Object v = hit.getSourceAsMap().get(sortingFieldName);
                if (v == null) continue;
                ArrayList<String> titleList = null;
                if (v instanceof String) {
                    titleList = new ArrayList<String>();
                    titleList.add(v.toString());
                } else {
                    titleList = (ArrayList<String>)v;
                }
                boolean isExtraAllMatch = false;
                boolean isHasSameWordandPos = false;
                String extraAliasQ = this.context.getAttribure("execute_extraword_alis_query");
                if (!StringUtils.isEmpty(extraAliasQ)) {
                    extraAliasQ = extraAliasQ.toLowerCase(Locale.ROOT).trim();
                    extraAliasQ = org.apache.commons.lang3.StringUtils.stripAccents((String)extraAliasQ);
                }
                for (String s : titleList) {
                    s = s.toLowerCase().trim();
                    if ((s = org.apache.commons.lang3.StringUtils.stripAccents((String)s)).equals(q)) {
                        isExtraAllMatch = true;
                        continue;
                    }
                    if (isExtraAllMatch || s.indexOf(q) < 0 && (StringUtils.isEmpty(extraAliasQ) || s.indexOf(extraAliasQ) < 0)) continue;
                    isHasSameWordandPos = true;
                }
                if (isExtraAllMatch) {
                    if (this.canApplyThreshold(hit)) {
                        if (extraAllMatchHitList.contains(hit)) continue;
                        extraAllMatchHitList.add(hit);
                        continue;
                    }
                    if (notSortDataList.contains(hit)) continue;
                    notSortDataList.add(hit);
                    continue;
                }
                if (isHasSameWordandPos) {
                    if (!this.canApplyThreshold(hit)) {
                        if (notSortDataList.contains(hit)) continue;
                        notSortDataList.add(hit);
                        continue;
                    }
                    if (hasSameWordAndPosList.contains(hit)) continue;
                    hasSameWordAndPosList.add(hit);
                    continue;
                }
                if (this.canApplyThreshold(hit)) {
                    if (hasSameWordList.contains(hit)) continue;
                    hasSameWordList.add(hit);
                    continue;
                }
                if (notSortDataList.contains(hit)) continue;
                notSortDataList.add(hit);
            }
            cutoffList = new ArrayList();
            extraAllMatchHitList.removeAll(sameWordSortedList);
            hasSameWordAndPosList.removeAll(sameWordSortedList);
            extraAllMatchHitList.forEach(m -> m.getSourceAsMap().put("matchType", "extractSameWord"));
            hasSameWordAndPosList.forEach(m -> m.getSourceAsMap().put("matchType", "sameWord"));
            sameWordSortedList.addAll(extraAllMatchHitList);
            sameWordSortedList.addAll(hasSameWordAndPosList);
            sameWordSortedList = this.filterHitsforSortByWeight(sameWordSortedList, (List<SearchHit>)cutoffList);
            for (SearchHit searchHit : cutoffList) {
                searchHit.getSourceAsMap().put("weight", Float.valueOf(Float.parseFloat(searchHit.getSourceAsMap().get("weight").toString()) * 2.0f));
            }
            cutoffList.removeAll(notSortDataList);
            notSortDataList.addAll((Collection<SearchHit>)cutoffList);
            if (topHit == null) {
                topHit = !CollectionUtils.isEmpty(extraAllMatchHitList) && !((SearchHit)extraAllMatchHitList.get(0)).equals((Object)sameWordSortedList.get(0)) ? (SearchHit)extraAllMatchHitList.get(0) : this.getTopHitDoc(willSortingDataList, q, sortingFieldName);
            }
            willSortingDataList.clear();
            willSortingDataList.addAll(notSortDataList);
            notSortDataList.clear();
        }
        AbstractRankerComparator comparator = this.enableTunningRankerNewSort ? (this.context.getMarks().size() == 1 && ("movies".equalsIgnoreCase(this.context.getMarks().get(0)) || "series".equalsIgnoreCase(this.context.getMarks().get(0))) ? (AbstractRankerComparator)this.comparatorMap.get("MovieSeriesComparator") : (this.context.getMarks().size() == 1 && "celebs".equalsIgnoreCase(this.context.getMarks().get(0)) ? (AbstractRankerComparator)this.comparatorMap.get("CelebsComparator") : (this.context.getMarks().size() == 1 && ("article".equalsIgnoreCase(this.context.getMarks().get(0)) || "user".equalsIgnoreCase(this.context.getMarks().get(0)) || "video".equalsIgnoreCase(this.context.getMarks().get(0))) ? (AbstractRankerComparator)this.comparatorMap.get("ScoreDescComparator") : (this.context.getMarks().size() > 0 && this.context.getMarks().contains("meta") ? (AbstractRankerComparator)this.comparatorMap.get("NormalComparator") : (AbstractRankerComparator)this.comparatorMap.get("NormalComparator"))))) : (AbstractRankerComparator)this.comparatorMap.get("NormalComparator");
        sameWordSortedList = new ArrayList(sameWordSortedList.parallelStream().map(m -> {
            comparator.computeScore((SearchHit)m);
            Float newScore = Float.valueOf(Float.parseFloat(m.getSourceAsMap().get("newScore").toString()));
            if (newScore.isNaN()) {
                newScore = Float.valueOf(0.0f);
            }
            m.getSourceAsMap().put("newScore", newScore);
            m.getSourceAsMap().put("rankerType", "sameWord");
            return m;
        }).collect(Collectors.toList()));
        hasSameWordList = new ArrayList(hasSameWordList.parallelStream().map(m -> {
            comparator.computeScore((SearchHit)m);
            Float newScore = Float.valueOf(Float.parseFloat(m.getSourceAsMap().get("newScore").toString()));
            if (newScore.isNaN()) {
                newScore = Float.valueOf(0.0f);
            }
            m.getSourceAsMap().put("newScore", newScore);
            m.getSourceAsMap().put("rankerType", "lowCreditSameWord");
            m.getSourceAsMap().put("matchType", "includeSameWord");
            return m;
        }).collect(Collectors.toList()));
        sameWordSortedList.sort(comparator);
        hasSameWordList.sort(comparator);
        finalHits.addAll(sameWordSortedList);
        finalHits.addAll(hasSameWordList);
        otherMatchHitList.addAll(willSortingDataList);
        AbstractRankerComparator otherComparator = (AbstractRankerComparator)this.comparatorMap.get("ScoreDescComparator");
        otherMatchHitList = otherMatchHitList.parallelStream().map(m -> {
            otherComparator.computeScore((SearchHit)m);
            this.raiseScoreByPopularityAndHot((SearchHit)m);
            m.getSourceAsMap().put("rankerType", "other");
            m.getSourceAsMap().put("matchType", "other");
            return m;
        }).collect(Collectors.toList());
        otherMatchHitList.sort(otherComparator);
        if (logger.isDebugEnabled()) {
            void var20_28;
            cutoffList = finalHits.toArray();
            int n = cutoffList.length;
            boolean bl = false;
            while (var20_28 < n) {
                Object obj = cutoffList[var20_28];
                SearchHit hit = (SearchHit)obj;
                System.out.println("publicationYear," + hit.getSourceAsMap().get("publicationYear") + ",weight," + hit.getSourceAsMap().get("weight") + ",popularity," + hit.getSourceAsMap().get("popularity") + ",new score," + hit.getSourceAsMap().get("newScore") + ",hot," + hit.getSourceAsMap().get("hot"));
                ++var20_28;
            }
        }
        finalHits.addAll(otherMatchHitList);
        if (!this.enableTunningRankerNewSort && topHit != null) {
            finalHits.remove(topHit);
            finalHits.add(0, topHit);
        }
        try {
            SearchUtils.replaceHits(hits, finalHits.toArray());
        }
        catch (Exception e) {
            logger.error("Error while repalce hits into response. Exception:", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void raiseScoreByPopularityAndHot(SearchHit hit) {
        for (String matchedQuerie : hit.getMatchedQueries()) {
            if (StringUtils.isEmpty(matchedQuerie) || matchedQuerie.toLowerCase().indexOf("prefix") == -1 && matchedQuerie.toLowerCase().indexOf("check_defaultCompensator".toLowerCase()) == -1) continue;
            float newScore = Float.parseFloat(hit.getSourceAsMap().get("newScore").toString());
            try {
                float popularity = Float.parseFloat(hit.getSourceAsMap().get("popularity").toString());
                if (popularity > 9980000.0f) {
                    hit.getSourceAsMap().put("newScore", Float.valueOf(newScore *= 1.0f + (popularity - 9980000.0f) / 7000.0f));
                    hit.getSourceAsMap().put("reComputeScoreBy", "other");
                }
            }
            catch (Exception popularity) {
                // empty catch block
            }
            try {
                float hot = Float.parseFloat(hit.getSourceAsMap().get("hot").toString());
                if (!(hot > 98000.0f)) continue;
                hit.getSourceAsMap().put("newScore", Float.valueOf(newScore *= 1.0f + (hot - 98000.0f) / 700.0f));
                hit.getSourceAsMap().put("reComputeScoreBy", "other");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private List<SearchHit> buildTopGroup(List<SearchHit> finalHits) {
        ArrayList<SearchHit> topGroupItemList = new ArrayList<SearchHit>();
        Map<String, Object> configParams = this.postRankerConfig.getParams();
        List topGroupConfigList = null;
        try {
            topGroupConfigList = (List)configParams.get("topGroups");
        }
        catch (Exception e) {
            return new ArrayList<SearchHit>();
        }
        ArrayList<SearchHit> workHitList = new ArrayList<SearchHit>(finalHits);
        if (!CollectionUtils.isEmpty(topGroupConfigList)) {
            for (Map configItem : topGroupConfigList) {
                String itemTypeConfig = configItem.get("itemType").toString();
                Integer takeCount = Integer.parseInt(configItem.getOrDefault("takeCount", "0").toString());
                Map thresholdValues = (Map)configItem.get("thresholdValues");
                List itemTypeList = CollectionUtils.arrayToList(itemTypeConfig.split(","));
                int count = 0;
                ArrayList<SearchHit> groupItems = new ArrayList<SearchHit>();
                block3: for (SearchHit hit : workHitList) {
                    if (count >= takeCount) break;
                    for (String itemType : itemTypeList) {
                        if (count >= takeCount) continue block3;
                        if (!hit.getSourceAsMap().getOrDefault("mark", "").toString().equalsIgnoreCase(itemType)) continue;
                        groupItems.add(hit);
                        ++count;
                    }
                }
                workHitList.removeAll(groupItems);
                topGroupItemList.addAll(groupItems);
            }
        }
        return topGroupItemList;
    }

    private List<SearchHit> filterHitsforSortByWeight(List<SearchHit> sourceList, List<SearchHit> cutoffList) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return sourceList;
        }
        SearchHit topScoreHit = sourceList.get(0);
        ArrayList<SearchHit> weightSortList = new ArrayList<SearchHit>();
        for (SearchHit hit : sourceList) {
            if ((double)hit.getScore() > (double)topScoreHit.getScore() * 0.1) {
                weightSortList.add(hit);
                continue;
            }
            cutoffList.add(hit);
        }
        sourceList.clear();
        sourceList.addAll(weightSortList);
        return sourceList;
    }

    private boolean canApplyThreshold(SearchHit hit) {
        String thresholdType = hit.getSourceAsMap().get(this.thresholdTypeFieldName).toString();
        if (StringUtils.isEmpty(thresholdType) || this.thresholdTypeValueMap.get(thresholdType) == null && this.thresholdTypeValueMap.get(DEFAULT_THRESHOLD_TYPE_NAME) == null || StringUtils.isEmpty(this.thresholdFieldName)) {
            return true;
        }
        float f = Float.parseFloat(hit.getSourceAsMap().get(this.thresholdFieldName).toString());
        return !(this.thresholdTypeValueMap.get(thresholdType) != null && f < this.thresholdTypeValueMap.get(thresholdType).floatValue()) && (this.thresholdTypeValueMap.get(DEFAULT_THRESHOLD_TYPE_NAME) == null || !(f < this.thresholdTypeValueMap.get(DEFAULT_THRESHOLD_TYPE_NAME).floatValue()));
    }

    private float getCurrentScore(SearchHit hit) {
        return 1.0f;
    }

    private SearchHit getTopHitDoc(List<SearchHit> soureHitsList, String qStr, String sourceFieldName) {
        boolean isExtraAllMatch = false;
        float maxScore = -10.0f;
        SearchHit topHit = null;
        block0: for (SearchHit hit : soureHitsList) {
            Object obj = hit.getSourceAsMap().get(sourceFieldName);
            if (obj == null) continue;
            ArrayList<String> titleList = null;
            if (obj instanceof String) {
                titleList = new ArrayList<String>();
                titleList.add(obj.toString());
            } else {
                titleList = (ArrayList<String>)obj;
            }
            for (String s : titleList) {
                if (!(s = s.toLowerCase()).trim().equals(qStr)) continue;
                if (maxScore < hit.getScore()) {
                    topHit = hit;
                    maxScore = hit.getScore();
                }
                if (this.canApplyThreshold(hit)) continue block0;
                topHit = null;
            }
        }
        return topHit;
    }

    @Override
    public List<String> sortFieldNames() {
        return this.sortFieldNames;
    }

    private boolean hasAllMatchQuery(String[] matchQueries) {
        boolean retVal = false;
        for (String str : matchQueries) {
            if (str.indexOf(this.searchName) == -1) continue;
            return true;
        }
        return retVal;
    }

    @Override
    public void prepareByConfig(PostRankerConfig config) {
        this.postRankerConfig = config;
        Map<String, Object> params = config.getParams();
        this.searchName = params.getOrDefault("SearchName", "EntiretyMatcher").toString();
        this.thresholdTypeFieldName = params.getOrDefault("thresholdTypeFieldName", "mark").toString();
        this.thresholdFieldName = params.getOrDefault("thresholdFieldName", "weight").toString();
        this.enableTunningRankerNewSort = Boolean.valueOf(params.getOrDefault("enableTunningRankerNewSort", "true").toString());
        List sortedFieldNameList = (List)params.get("sortFieldNames");
        this.sortFieldNames.clear();
        this.sortFieldNames.addAll(sortedFieldNameList);
        Object objItem = params.get("thresholdTypeValue");
        if (objItem instanceof List) {
            List thresholdTypeValueMapList = (List)objItem;
            this.thresholdTypeValueMap.clear();
            for (Map thresholdTypeValueMap : thresholdTypeValueMapList) {
                String name = thresholdTypeValueMap.get("name").toString();
                float value = Float.parseFloat(thresholdTypeValueMap.get("value").toString());
                this.thresholdTypeValueMap.put(name, Float.valueOf(value));
            }
        }
        for (RankerComparatorConfig rankerComparatorConfig : config.getComparators()) {
            if (StringUtils.isEmpty(rankerComparatorConfig.getFullClassName())) {
                throw new RuntimeException("PostRanker class name must not empty!");
            }
            try {
                Class<?> clz = Class.forName(rankerComparatorConfig.getFullClassName());
                AbstractRankerComparator abstractRankerComparator = (AbstractRankerComparator)clz.newInstance();
                abstractRankerComparator.prepareByConfig(rankerComparatorConfig.getComputeExpress());
                abstractRankerComparator.appendSysParams(this.bizSysConfig);
                this.comparatorMap.put(rankerComparatorConfig.getIdName(), abstractRankerComparator);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        this.inited = true;
    }
}

