/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.engine.ranker;

import com.valor.common.search.engine.facade.config.PostRankerConfig;
import com.valor.common.search.engine.ranker.AbstractPostScoreRanker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.action.search.SearchResponse;
import org.nfunk.jep.JEP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScoreScalePostRanker
extends AbstractPostScoreRanker {
    Logger logger = LoggerFactory.getLogger(ScoreScalePostRanker.class);
    private String targetMatcherRegexp = "^EntiretyMatcher.*";
    private String rankerName = "ScoreScaleRanker";
    private String scaleExpress = "a";
    private String weightLimit = "8.0";
    private List<String> variableNames = new ArrayList<String>();

    @Override
    public void execute() {
        SearchResponse searchResponse = this.context.getResponse();
        Pattern pattern = Pattern.compile(this.targetMatcherRegexp);
        Arrays.stream(searchResponse.getHits().getHits()).forEach(hit -> {
            JEP jep = new JEP();
            jep.addStandardFunctions();
            for (String matcherName : hit.getMatchedQueries()) {
                Matcher matcher = pattern.matcher(matcherName);
                if (!matcher.matches()) continue;
                for (String variableName : this.variableNames) {
                    float value = Float.parseFloat(((Object)hit.getSourceAsMap().getOrDefault(variableName, 0)).toString());
                    jep.addVariable(variableName, value);
                }
                if (!(Float.parseFloat(((Object)hit.getSourceAsMap().getOrDefault("weight", 0)).toString()) > Float.parseFloat(this.weightLimit))) continue;
                jep.addVariable("a", hit.getScore());
                jep.parseExpression(this.scaleExpress);
                hit.score((float)jep.getValue());
            }
        });
    }

    @Override
    public List<String> sortFieldNames() {
        return null;
    }

    @Override
    public void prepareByConfig(PostRankerConfig config) {
        this.rankerName = config.getIdName();
        this.scaleExpress = config.getParams().getOrDefault("scaleExpress", "a").toString();
        this.weightLimit = config.getParams().getOrDefault("weightLimit", "8.0").toString();
        this.variableNames = config.getParams().getOrDefault("variableNames", new ArrayList());
    }
}

